/*
 * Decompiled with CFR 0.152.
 */
package net.bis5.mattermost.client4.integrationtest.api;

import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.bis5.mattermost.client4.ApiResponse;
import net.bis5.mattermost.client4.MattermostClient;
import net.bis5.mattermost.client4.integrationtest.Assertions;
import net.bis5.mattermost.client4.integrationtest.MattermostClientTest;
import net.bis5.mattermost.client4.integrationtest.MattermostClientTestExtension;
import net.bis5.mattermost.client4.integrationtest.TestHelper;
import net.bis5.mattermost.model.SamlCertificateStatus;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.function.Executable;

@ExtendWith(value={MattermostClientTestExtension.class})
class SamlApiTest
implements MattermostClientTest {
    private TestHelper th;
    private MattermostClient client;

    SamlApiTest() {
    }

    @Override
    public void setHelper(TestHelper helper) {
        this.th = helper;
    }

    @BeforeEach
    void setup() {
        this.client = this.createClient();
        this.th.changeClient(this.client).initBasic();
    }

    @AfterEach
    void tearDown() {
        this.th.logout();
        this.client.close();
    }

    @Test
    void getSamlMetadata() throws IOException {
        this.th.logout().loginSystemAdmin();
        ApiResponse response = this.client.getSamlMetadata();
        Assertions.assertStatus(response, Response.Status.NOT_IMPLEMENTED);
    }

    @Test
    void uploadSamlIdpCertificate() throws IOException {
        this.th.logout().loginSystemAdmin();
        Path file = Files.createTempFile("", ".crt", new FileAttribute[0]);
        String fileName = file.getName(file.getNameCount() - 1).toString();
        ApiResponse response = this.client.uploadSamlIdpCertificate(file, fileName);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((Boolean)response.readEntity()));
    }

    @Test
    void uploadSamlPublicCertificate() throws IOException {
        this.th.logout().loginSystemAdmin();
        Path file = Files.createTempFile("", ".crt", new FileAttribute[0]);
        String fileName = file.getName(file.getNameCount() - 1).toString();
        ApiResponse response = this.client.uploadSamlPublicCertificate(file, fileName);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((Boolean)response.readEntity()));
    }

    @Test
    void uploadSamlPrivateCertificate() throws IOException {
        this.th.logout().loginSystemAdmin();
        Path file = Files.createTempFile("", ".key", new FileAttribute[0]);
        String fileName = file.getName(file.getNameCount() - 1).toString();
        ApiResponse response = this.client.uploadSamlPrivateCertificate(file, fileName);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((Boolean)response.readEntity()));
    }

    @Test
    void deleteSamlIdpCertificate() throws IOException {
        this.th.logout().loginSystemAdmin();
        Path file = Files.createTempFile("", ".crt", new FileAttribute[0]);
        String fileName = file.getName(file.getNameCount() - 1).toString();
        Assertions.assertNoError(this.client.uploadSamlIdpCertificate(file, fileName));
        ApiResponse response = this.client.deleteSamlIdpCertificate();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((Boolean)response.readEntity()));
    }

    @Test
    void deleteSamlPublicCertificate() throws IOException {
        this.th.logout().loginSystemAdmin();
        Path file = Files.createTempFile("", ".crt", new FileAttribute[0]);
        String fileName = file.getName(file.getNameCount() - 1).toString();
        Assertions.assertNoError(this.client.uploadSamlPublicCertificate(file, fileName));
        ApiResponse response = this.client.deleteSamlPublicCertificate();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((Boolean)response.readEntity()));
    }

    @Test
    void deleteSamlPrivateCertificate() throws IOException {
        this.th.logout().loginSystemAdmin();
        Path file = Files.createTempFile("", ".key", new FileAttribute[0]);
        String fileName = file.getName(file.getNameCount() - 1).toString();
        Assertions.assertNoError(this.client.uploadSamlPrivateCertificate(file, fileName));
        ApiResponse response = this.client.deleteSamlPrivateCertificate();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((Boolean)response.readEntity()));
    }

    @Test
    void getSamlCertificateStatus() throws IOException {
        this.th.logout().loginSystemAdmin();
        Path file = Files.createTempFile("", ".key", new FileAttribute[0]);
        String fileName = file.getName(file.getNameCount() - 1).toString();
        Assertions.assertNoError(this.client.uploadSamlPrivateCertificate(file, fileName));
        ApiResponse response = this.client.getSamlCertificateStatus();
        if (Assertions.isMajorMinorVersionMatches("5.10", response) || Assertions.isMajorMinorVersionMatches("5.11", response)) {
            return;
        }
        SamlCertificateStatus status = (SamlCertificateStatus)response.readEntity();
        org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> org.junit.jupiter.api.Assertions.assertFalse((boolean)status.isIdpCertificateFile()), () -> org.junit.jupiter.api.Assertions.assertFalse((boolean)status.isPublicCertificateFile()), () -> org.junit.jupiter.api.Assertions.assertTrue((boolean)status.isPrivateKeyFile())});
    }
}

