/*
 * Decompiled with CFR 0.152.
 */
package net.bis5.mattermost.client4.integrationtest.api;

import java.util.stream.Collectors;
import net.bis5.mattermost.client4.ApiResponse;
import net.bis5.mattermost.client4.MattermostClient;
import net.bis5.mattermost.client4.integrationtest.Assertions;
import net.bis5.mattermost.client4.integrationtest.MattermostClientTest;
import net.bis5.mattermost.client4.integrationtest.MattermostClientTestExtension;
import net.bis5.mattermost.client4.integrationtest.TestHelper;
import net.bis5.mattermost.model.Post;
import net.bis5.mattermost.model.Reaction;
import net.bis5.mattermost.model.ReactionList;
import net.bis5.mattermost.model.User;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsIterableContainingInAnyOrder;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={MattermostClientTestExtension.class})
class ReactionApiTest
implements MattermostClientTest {
    private TestHelper th;
    private MattermostClient client;

    ReactionApiTest() {
    }

    @Override
    public void setHelper(TestHelper helper) {
        this.th = helper;
    }

    @BeforeEach
    void setup() {
        this.client = this.createClient();
        this.th.changeClient(this.client).initBasic();
    }

    @AfterEach
    void tearDown() {
        this.th.logout();
        this.client.close();
    }

    @Test
    void saveReaction() {
        Post targetPost = this.th.basicPost();
        User reactedUser = this.th.basicUser();
        Reaction reaction = new Reaction();
        reaction.setUserId(reactedUser.getId());
        reaction.setPostId(targetPost.getId());
        reaction.setEmojiName("mattermost");
        Reaction savedReaction = (Reaction)Assertions.assertNoError(this.client.saveReaction(reaction)).readEntity();
        org.junit.jupiter.api.Assertions.assertNotEquals((long)0L, (long)savedReaction.getCreateAt());
    }

    @Test
    void deleteReaction() {
        Post targetPost = this.th.basicPost();
        User reactedUser = this.th.basicUser();
        Reaction reaction = new Reaction();
        reaction.setUserId(reactedUser.getId());
        reaction.setPostId(targetPost.getId());
        reaction.setEmojiName("mattermost");
        reaction = (Reaction)Assertions.assertNoError(this.client.saveReaction(reaction)).readEntity();
        ApiResponse deleteReactionResult = Assertions.assertNoError(this.client.deleteReaction(reaction));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((Boolean)deleteReactionResult.readEntity()));
    }

    @Test
    void getReactions() {
        Post targetPost = this.th.basicPost();
        User reactedUser = this.th.basicUser();
        Reaction reaction = new Reaction();
        reaction.setUserId(reactedUser.getId());
        reaction.setPostId(targetPost.getId());
        reaction.setEmojiName("mattermost");
        Assertions.assertNoError(this.client.saveReaction(reaction));
        reaction.setEmojiName("+1");
        Assertions.assertNoError(this.client.saveReaction(reaction));
        ReactionList reactions = (ReactionList)Assertions.assertNoError(this.client.getReactions(targetPost.getId())).readEntity();
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)reactions.size());
        MatcherAssert.assertThat(reactions.stream().map(Reaction::getEmojiName).collect(Collectors.toSet()), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"mattermost", "+1"}));
    }
}

