/*
 * Decompiled with CFR 0.152.
 */
package net.bis5.mattermost.client4.integrationtest.api;

import java.util.stream.Collectors;
import net.bis5.mattermost.client4.ApiResponse;
import net.bis5.mattermost.client4.MattermostClient;
import net.bis5.mattermost.client4.integrationtest.Assertions;
import net.bis5.mattermost.client4.integrationtest.MattermostClientTest;
import net.bis5.mattermost.client4.integrationtest.MattermostClientTestExtension;
import net.bis5.mattermost.client4.integrationtest.TestHelper;
import net.bis5.mattermost.model.Preference;
import net.bis5.mattermost.model.PreferenceCategory;
import net.bis5.mattermost.model.Preferences;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsIterableContainingInAnyOrder;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={MattermostClientTestExtension.class})
class PreferencesApiTest
implements MattermostClientTest {
    private TestHelper th;
    private MattermostClient client;

    PreferencesApiTest() {
    }

    @Override
    public void setHelper(TestHelper helper) {
        this.th = helper;
    }

    @BeforeEach
    void setup() {
        this.client = this.createClient();
        this.th.changeClient(this.client).initBasic();
    }

    @AfterEach
    void tearDown() {
        this.th.logout();
        this.client.close();
    }

    @Test
    void getPreferences() {
        String userId = this.th.basicUser().getId();
        ApiResponse response = Assertions.assertNoError(this.client.getPreferences(userId));
        Preferences preferences = (Preferences)response.readEntity();
        MatcherAssert.assertThat((Object)preferences.isEmpty(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat(preferences.stream().map(Preference::getUserid).collect(Collectors.toSet()), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{userId}));
    }

    @Test
    void savePreferences() {
        String userId = this.th.basicUser().getId();
        Preferences preferences = (Preferences)this.client.getPreferences(userId).readEntity();
        Preference preference = preferences.stream().filter(p -> p.getCategory() == PreferenceCategory.TUTORIAL_STEPS).findAny().get();
        preference.setValue("1");
        ApiResponse response = Assertions.assertNoError(this.client.updatePreferences(userId, preferences));
        boolean result = (Boolean)response.readEntity();
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    void deletePreference() {
        String userId = this.th.basicUser().getId();
        Preferences currentPreferences = (Preferences)this.client.getPreferences(userId).readEntity();
        Preference tutorial = currentPreferences.stream().filter(p -> p.getCategory() == PreferenceCategory.TUTORIAL_STEPS).findAny().get();
        Preferences deleteTargets = new Preferences();
        deleteTargets.add((Object)tutorial);
        ApiResponse response = Assertions.assertNoError(this.client.deletePreferences(userId, deleteTargets));
        boolean result = (Boolean)response.readEntity();
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    void getPreferencesByCategory() {
        String userId = this.th.basicUser().getId();
        PreferenceCategory category = PreferenceCategory.TUTORIAL_STEPS;
        ApiResponse response = Assertions.assertNoError(this.client.getPreferencesByCategory(userId, category));
        Preferences preferences = (Preferences)response.readEntity();
        MatcherAssert.assertThat((Object)preferences.isEmpty(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    void getPreference() {
        String userId = this.th.basicUser().getId();
        PreferenceCategory category = PreferenceCategory.DISPLAY_SETTINGS;
        String name = Preference.Name.ChannelDisplayMode.getKey();
        String value = "full";
        Preference preference = new Preference();
        preference.setUserid(userId);
        preference.setCategory(category);
        preference.setName(name);
        preference.setValue(value);
        Preferences preferences = new Preferences();
        preferences.add((Object)preference);
        Assertions.assertNoError(this.client.updatePreferences(userId, preferences));
        ApiResponse response = Assertions.assertNoError(this.client.getPreferenceByCategoryAndName(userId, category, name));
        Preference preference2 = (Preference)response.readEntity();
        MatcherAssert.assertThat((Object)preference2.getCategory(), (Matcher)CoreMatchers.is((Object)PreferenceCategory.DISPLAY_SETTINGS));
        MatcherAssert.assertThat((Object)preference2.getName(), (Matcher)CoreMatchers.is((Object)name));
        MatcherAssert.assertThat((Object)preference2.getValue(), (Matcher)CoreMatchers.is((Object)value));
    }
}

