/*
 * Decompiled with CFR 0.152.
 */
package net.bis5.mattermost.client4.integrationtest.api;

import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.bis5.mattermost.client4.ApiResponse;
import net.bis5.mattermost.client4.MattermostClient;
import net.bis5.mattermost.client4.Pager;
import net.bis5.mattermost.client4.integrationtest.Assertions;
import net.bis5.mattermost.client4.integrationtest.MattermostClientTest;
import net.bis5.mattermost.client4.integrationtest.MattermostClientTestExtension;
import net.bis5.mattermost.client4.integrationtest.TestHelper;
import net.bis5.mattermost.client4.model.FileUploadResult;
import net.bis5.mattermost.model.FileInfo;
import net.bis5.mattermost.model.Post;
import net.bis5.mattermost.model.PostImage;
import net.bis5.mattermost.model.PostList;
import net.bis5.mattermost.model.PostPatch;
import net.bis5.mattermost.model.PostType;
import net.bis5.mattermost.model.Preference;
import net.bis5.mattermost.model.PreferenceCategory;
import net.bis5.mattermost.model.Preferences;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.function.Executable;

@ExtendWith(value={MattermostClientTestExtension.class})
class PostsApiTest
implements MattermostClientTest {
    private TestHelper th;
    private MattermostClient client;

    PostsApiTest() {
    }

    @Override
    public void setHelper(TestHelper helper) {
        this.th = helper;
    }

    @BeforeEach
    void setup() {
        this.client = this.createClient();
        this.th.changeClient(this.client).initBasic();
    }

    @AfterEach
    void tearDown() {
        this.th.logout();
        this.client.close();
    }

    @Test
    void createPost() {
        Post post = new Post();
        post.setChannelId(this.th.basicChannel().getId());
        post.setMessage("Hello World!");
        ApiResponse response = Assertions.assertNoError(this.client.createPost(post));
        Post postedPost = (Post)response.readEntity();
        MatcherAssert.assertThat((Object)postedPost.getMessage(), (Matcher)CoreMatchers.is((Object)post.getMessage()));
        MatcherAssert.assertThat((Object)postedPost.getChannelId(), (Matcher)CoreMatchers.is((Object)post.getChannelId()));
    }

    @Test
    void createEphemeralPost() {
        this.th.logout().loginSystemAdmin();
        Post post = new Post();
        post.setChannelId(this.th.basicChannel().getId());
        post.setMessage("Hello World!");
        ApiResponse response = Assertions.assertNoError(this.client.createEphemeralPost(this.th.basicUser().getId(), post));
        Post postedPost = (Post)response.readEntity();
        MatcherAssert.assertThat((Object)postedPost.getMessage(), (Matcher)CoreMatchers.is((Object)post.getMessage()));
        MatcherAssert.assertThat((Object)postedPost.getChannelId(), (Matcher)CoreMatchers.is((Object)post.getChannelId()));
        MatcherAssert.assertThat((Object)postedPost.getType(), (Matcher)CoreMatchers.is((Object)PostType.EPHEMERAL));
    }

    @Test
    void getPost() {
        String postId = this.th.basicPost().getId();
        ApiResponse response = Assertions.assertNoError(this.client.getPost(postId, null));
        Post post = (Post)response.readEntity();
        MatcherAssert.assertThat((Object)post.getId(), (Matcher)CoreMatchers.is((Object)postId));
    }

    @Test
    void getPostHasEmbedImage() throws IOException, URISyntaxException {
        String channelId = this.th.basicChannel().getId();
        Post post = new Post();
        post.setChannelId(channelId);
        post.setMessage("logo file from: https://github.com/hmhealey/test-files/raw/master/logoVertical.png");
        ApiResponse response = Assertions.assertNoError(this.client.createPost(post));
        if (Assertions.isNotSupportVersion("5.8.0", response)) {
            return;
        }
        Post createdPost = (Post)response.readEntity();
        response = Assertions.assertNoError(this.client.getPost(createdPost.getId()));
        createdPost = (Post)response.readEntity();
        PostImage image = (PostImage)createdPost.getMetadata().getImages().values().stream().findFirst().get();
        org.junit.jupiter.api.Assertions.assertNotEquals((int)0, (int)image.getWidth());
        org.junit.jupiter.api.Assertions.assertNotEquals((int)0, (int)image.getHeight());
        if (Assertions.isSupportVersion("5.11.0", response)) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)"png", (Object)image.getFormat());
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)image.getFrameCount());
        }
    }

    @Test
    void deletePost() {
        String postId = this.th.createPost(this.th.basicChannel()).getId();
        ApiResponse response = Assertions.assertNoError(this.client.deletePost(postId));
        boolean result = (Boolean)response.readEntity();
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    void updatePost() {
        Post post = this.th.createPost(this.th.basicChannel());
        post.setMessage("UPDATE:" + post.getMessage());
        ApiResponse response = Assertions.assertNoError(this.client.updatePost(post));
        Post updatedPost = (Post)response.readEntity();
        MatcherAssert.assertThat((Object)updatedPost.getMessage(), (Matcher)CoreMatchers.is((Object)post.getMessage()));
    }

    @Test
    void patchPost() {
        String postId = this.th.createPost(this.th.basicChannel()).getId();
        PostPatch patch = new PostPatch();
        patch.setMessage("NEW MESSAGE");
        ApiResponse response = Assertions.assertNoError(this.client.patchPost(postId, patch));
        Post updatedPost = (Post)response.readEntity();
        MatcherAssert.assertThat((Object)updatedPost.getMessage(), (Matcher)CoreMatchers.is((Object)patch.getMessage()));
    }

    @Test
    void getThread() {
        String postId = this.th.basicPost().getId();
        ApiResponse response = Assertions.assertNoError(this.client.getPostThread(postId, null));
        PostList posts = (PostList)response.readEntity();
        MatcherAssert.assertThat(posts.getPosts().values().stream().map(Post::getId).collect(Collectors.toSet()), (Matcher)CoreMatchers.hasItem((Object)postId));
    }

    @Test
    void getFlaggedPosts() {
        Post post = this.th.basicPost();
        Preferences prefs = new Preferences();
        Preference flag = new Preference();
        flag.setUserid(this.th.basicUser().getId());
        flag.setCategory(PreferenceCategory.FLAGGED_POST);
        flag.setName(post.getId());
        flag.setValue(Boolean.toString(true));
        prefs.add((Object)flag);
        Assertions.assertNoError(this.client.updatePreferences(this.th.basicUser().getId(), prefs));
        PostList flaggedPosts = (PostList)Assertions.assertNoError(this.client.getFlaggedPostsForUser(this.th.basicUser().getId())).readEntity();
        MatcherAssert.assertThat((Object)flaggedPosts.getOrder().contains(post.getId()), (Matcher)CoreMatchers.is((Object)true));
        flaggedPosts = (PostList)Assertions.assertNoError(this.client.getFlaggedPostsForUserInChannel(this.th.basicUser().getId(), post.getChannelId())).readEntity();
        MatcherAssert.assertThat((Object)flaggedPosts.getOrder().contains(post.getId()), (Matcher)CoreMatchers.is((Object)true));
        flaggedPosts = (PostList)Assertions.assertNoError(this.client.getFlaggedPostsForUserInTeam(this.th.basicUser().getId(), this.th.basicTeam().getId())).readEntity();
        MatcherAssert.assertThat((Object)flaggedPosts.getOrder().contains(post.getId()), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    void getFileInfoForPost() throws IOException, URISyntaxException {
        Path file1 = this.th.getResourcePath("/noto-emoji_u1f6a7.png");
        Path file2 = this.th.getResourcePath("/noto-emoji_u1f310.png");
        String channelId = this.th.basicChannel().getId();
        FileUploadResult uploadResult = (FileUploadResult)Assertions.assertNoError(this.client.uploadFile(channelId, new Path[]{file1, file2})).readEntity();
        FileInfo fileInfo1 = uploadResult.getFileInfos()[0];
        FileInfo fileInfo2 = uploadResult.getFileInfos()[1];
        Post post = new Post(channelId, "file attached");
        post.setFileIds(Arrays.asList(fileInfo1.getId(), fileInfo2.getId()));
        post = (Post)Assertions.assertNoError(this.client.createPost(post)).readEntity();
        String postId = post.getId();
        FileInfo[] fileInfosForPost = (FileInfo[])Assertions.assertNoError(this.client.getFileInfoForPost(postId)).readEntity();
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)fileInfosForPost.length);
        HashSet<String> fileIds = new HashSet<String>(Arrays.asList(fileInfo1.getId(), fileInfo2.getId()));
        org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> fileIds.contains(fileInfosForPost[0].getId()), () -> fileIds.contains(fileInfosForPost[1].getId())});
    }

    @Test
    void getPostsForChannel() {
        String channelId = this.th.basicChannel().getId();
        ApiResponse response = Assertions.assertNoError(this.client.getPostsForChannel(channelId, Pager.of((int)0, (int)60), null));
        PostList posts = (PostList)response.readEntity();
        MatcherAssert.assertThat(posts.getPosts().values().stream().map(Post::getChannelId).collect(Collectors.toSet()), (Matcher)CoreMatchers.hasItem((Object)channelId));
    }

    @Test
    void getPostsForChannel_Since() {
        String channelId = this.th.basicChannel().getId();
        ZonedDateTime since = ZonedDateTime.of(2000, 1, 1, 0, 0, 0, 0, ZoneOffset.UTC);
        ApiResponse response = Assertions.assertNoError(this.client.getPostsSince(channelId, since.toEpochSecond()));
        PostList posts = (PostList)response.readEntity();
        MatcherAssert.assertThat(posts.getPosts().values().stream().map(Post::getChannelId).collect(Collectors.toSet()), (Matcher)CoreMatchers.hasItem((Object)channelId));
    }

    @Test
    void getPostsForChannel_Before() {
        String channelId = this.th.basicChannel().getId();
        Post post1 = this.th.createPost(this.th.basicChannel());
        Post post2 = this.th.createPost(this.th.basicChannel());
        Post post3 = this.th.createPost(this.th.basicChannel());
        ApiResponse response = Assertions.assertNoError(this.client.getPostsBefore(channelId, post2.getId(), Pager.of((int)0, (int)60), null));
        PostList posts = (PostList)response.readEntity();
        Set channelIds = posts.getPosts().values().stream().map(Post::getChannelId).collect(Collectors.toSet());
        Set postIds = posts.getPosts().values().stream().map(Post::getId).collect(Collectors.toSet());
        MatcherAssert.assertThat(channelIds, (Matcher)CoreMatchers.hasItem((Object)channelId));
        MatcherAssert.assertThat(postIds, (Matcher)CoreMatchers.hasItem((Object)post1.getId()));
        MatcherAssert.assertThat(postIds, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItem((Object)post2.getId())));
        MatcherAssert.assertThat(postIds, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItem((Object)post3.getId())));
    }

    @Test
    void getPostsForChannel_After() {
        String channelId = this.th.basicChannel().getId();
        Post post1 = this.th.createPost(this.th.basicChannel());
        Post post2 = this.th.createPost(this.th.basicChannel());
        Post post3 = this.th.createPost(this.th.basicChannel());
        ApiResponse response = Assertions.assertNoError(this.client.getPostsAfter(channelId, post2.getId(), Pager.of((int)0, (int)60), null));
        PostList posts = (PostList)response.readEntity();
        Set channelIds = posts.getPosts().values().stream().map(Post::getChannelId).collect(Collectors.toSet());
        Set postIds = posts.getPosts().values().stream().map(Post::getId).collect(Collectors.toSet());
        MatcherAssert.assertThat(channelIds, (Matcher)CoreMatchers.hasItem((Object)channelId));
        MatcherAssert.assertThat(postIds, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItem((Object)post1.getId())));
        MatcherAssert.assertThat(postIds, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItem((Object)post2.getId())));
        MatcherAssert.assertThat(postIds, (Matcher)CoreMatchers.hasItem((Object)post3.getId()));
    }

    @Test
    void searchForTeamPosts() {
        String teamId = this.th.basicTeam().getId();
        String channelId = this.th.basicChannel().getId();
        Post post1 = new Post(channelId, "hello");
        Post post2 = new Post(channelId, "mattermost");
        Post post3 = new Post(channelId, "world");
        post1 = (Post)Assertions.assertNoError(this.client.createPost(post1)).readEntity();
        post2 = (Post)Assertions.assertNoError(this.client.createPost(post2)).readEntity();
        post3 = (Post)Assertions.assertNoError(this.client.createPost(post3)).readEntity();
        ApiResponse response = Assertions.assertNoError(this.client.searchPosts(teamId, "hello", false));
        PostList posts = (PostList)response.readEntity();
        MatcherAssert.assertThat(posts.getPosts().keySet(), (Matcher)CoreMatchers.hasItem((Object)post1.getId()));
        MatcherAssert.assertThat(posts.getPosts().keySet(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItems((Object[])new String[]{post2.getId(), post3.getId()})));
        response = Assertions.assertNoError(this.client.searchPosts(teamId, "hello world", true));
        posts = (PostList)response.readEntity();
        MatcherAssert.assertThat(posts.getPosts().keySet(), (Matcher)CoreMatchers.hasItems((Object[])new String[]{post1.getId(), post3.getId()}));
        MatcherAssert.assertThat(posts.getPosts().keySet(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItem((Object)post2.getId())));
    }

    @Test
    void pinPostToChannel() {
        Post post = this.th.createPost(this.th.basicChannel());
        ApiResponse response = Assertions.assertNoError(this.client.pinPost(post.getId()));
        boolean result = (Boolean)response.readEntity();
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)true));
        Post pinnedPost = post;
        response = Assertions.assertNoError(this.client.pinPost(pinnedPost.getId()));
        result = (Boolean)response.readEntity();
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    void unPinPost() {
        Post post = this.th.createPost(this.th.basicChannel());
        Assertions.assertNoError(this.client.pinPost(post.getId()));
        ApiResponse response = Assertions.assertNoError(this.client.unpinPost(post.getId()));
        boolean result = (Boolean)response.readEntity();
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)true));
        Post unpinnedPost = post;
        response = Assertions.assertNoError(this.client.unpinPost(unpinnedPost.getId()));
        result = (Boolean)response.readEntity();
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)true));
    }
}

