/*
 * Decompiled with CFR 0.152.
 */
package net.bis5.mattermost.client4.integrationtest.api;

import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Optional;
import net.bis5.mattermost.client4.ApiResponse;
import net.bis5.mattermost.client4.MattermostClient;
import net.bis5.mattermost.client4.integrationtest.Assertions;
import net.bis5.mattermost.client4.integrationtest.MattermostClientTest;
import net.bis5.mattermost.client4.integrationtest.MattermostClientTestExtension;
import net.bis5.mattermost.client4.integrationtest.TestHelper;
import net.bis5.mattermost.model.PluginManifest;
import net.bis5.mattermost.model.Plugins;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.function.Executable;

@ExtendWith(value={MattermostClientTestExtension.class})
class PluginApiTest
implements MattermostClientTest {
    private TestHelper th;
    private MattermostClient client;
    private static Path simpleLockPluginArchivePath;
    private static Path drawPluginArchivePath;

    PluginApiTest() {
    }

    @Override
    public void setHelper(TestHelper helper) {
        this.th = helper;
    }

    @BeforeEach
    void setup() {
        this.client = this.createClient();
        this.th.changeClient(this.client).initBasic();
    }

    @AfterEach
    void tearDown() {
        this.th.logout();
        this.client.close();
    }

    @BeforeAll
    static void setupPluginArchivePath() throws IOException {
        InputStream resource = PluginApiTest.class.getResourceAsStream("/net.bis5.mattermost.simplelock-0.0.1.tar.gz");
        simpleLockPluginArchivePath = Files.createTempFile(null, null, new FileAttribute[0]);
        IOUtils.copy((InputStream)resource, (OutputStream)Files.newOutputStream(simpleLockPluginArchivePath, StandardOpenOption.TRUNCATE_EXISTING));
        resource = PluginApiTest.class.getResourceAsStream("/com.mattermost.draw-plugin-0.0.1.tar.gz");
        drawPluginArchivePath = Files.createTempFile(null, null, new FileAttribute[0]);
        IOUtils.copy((InputStream)resource, (OutputStream)Files.newOutputStream(drawPluginArchivePath, StandardOpenOption.TRUNCATE_EXISTING));
    }

    @AfterAll
    static void deletePluginArchive() {
        if (simpleLockPluginArchivePath != null) {
            simpleLockPluginArchivePath.toFile().delete();
        }
        if (drawPluginArchivePath != null) {
            drawPluginArchivePath.toFile().delete();
        }
    }

    @Test
    void getPlugins() throws IOException {
        this.th.logout().loginSystemAdmin();
        ApiResponse response = Assertions.assertNoError(this.client.getPlugins());
        if (Assertions.isNotSupportVersion("5.2.0", response)) {
            return;
        }
        if (Assertions.isSupportVersion("5.20.0", response)) {
            PluginManifest uploadResult = (PluginManifest)Assertions.assertNoError(this.client.uploadPlugin(simpleLockPluginArchivePath)).readEntity();
            Plugins plugins = (Plugins)Assertions.assertNoError(this.client.getPlugins()).readEntity();
            Optional<PluginManifest> simpleLockPlugin = Arrays.asList(plugins.getInactive()).stream().filter(p -> p.getId().equals(uploadResult.getId())).findFirst();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)simpleLockPlugin.isPresent());
            this.client.removePlugin(uploadResult.getId());
        } else {
            Plugins plugins = (Plugins)response.readEntity();
            org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> {
                Optional<PluginManifest> zoomPlugin = Arrays.asList(plugins.getInactive()).stream().filter(p -> p.getId().equals("zoom")).findFirst();
                org.junit.jupiter.api.Assertions.assertTrue((boolean)zoomPlugin.isPresent(), (String)"zoom");
            }, () -> {
                Optional<PluginManifest> jiraPlugin = Arrays.asList(plugins.getInactive()).stream().filter(p -> p.getId().equals("jira")).findFirst();
                org.junit.jupiter.api.Assertions.assertTrue((boolean)jiraPlugin.isPresent(), (String)"jira");
            }});
        }
    }

    @Test
    void uploadPlugin() throws IOException {
        this.th.logout().loginSystemAdmin();
        ApiResponse response = this.client.getPlugins();
        if (Assertions.isNotSupportVersion("5.2.0", response)) {
            return;
        }
        ApiResponse uploadResult = Assertions.assertNoError(this.client.uploadPlugin(simpleLockPluginArchivePath));
        uploadResult.readEntity();
        ApiResponse blockedUploadResult = this.client.uploadPlugin(simpleLockPluginArchivePath);
        Assertions.assertStatus(blockedUploadResult, Response.Status.BAD_REQUEST);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)blockedUploadResult.readError().getMessage().contains("A plugin with the same ID"));
        if (!Assertions.isNotSupportVersion("5.8.0", blockedUploadResult)) {
            ApiResponse forceUploadResult = Assertions.assertNoError(this.client.uploadPlugin(simpleLockPluginArchivePath, true));
            forceUploadResult.readEntity();
        }
        this.client.removePlugin(((PluginManifest)uploadResult.readEntity()).getId());
    }

    @Test
    void removePlugin() throws IOException {
        this.th.logout().loginSystemAdmin();
        ApiResponse response = this.client.getPlugins();
        if (Assertions.isNotSupportVersion("5.2.0", response)) {
            return;
        }
        ApiResponse uploadResult = Assertions.assertNoError(this.client.uploadPlugin(simpleLockPluginArchivePath));
        PluginManifest plugin = (PluginManifest)uploadResult.readEntity();
        String pluginId = plugin.getId();
        ApiResponse removeResult = Assertions.assertNoError(this.client.removePlugin(pluginId));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((Boolean)removeResult.readEntity()));
        this.client.removePlugin(pluginId);
    }

    @Test
    void enablePlugin() throws IOException {
        this.th.logout().loginSystemAdmin();
        ApiResponse response = this.client.getPlugins();
        if (Assertions.isNotSupportVersion("5.2.0", response)) {
            return;
        }
        ApiResponse uploadResult = Assertions.assertNoError(this.client.uploadPlugin(simpleLockPluginArchivePath));
        PluginManifest plugin = (PluginManifest)uploadResult.readEntity();
        String pluginId = plugin.getId();
        ApiResponse enableResult = Assertions.assertNoError(this.client.enablePlugin(pluginId));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((Boolean)enableResult.readEntity()));
        this.client.removePlugin(pluginId);
    }

    @Test
    void disablePlugin() throws IOException {
        this.th.logout().loginSystemAdmin();
        ApiResponse response = this.client.getPlugins();
        if (Assertions.isNotSupportVersion("5.2.0", response)) {
            return;
        }
        ApiResponse uploadResult = Assertions.assertNoError(this.client.uploadPlugin(simpleLockPluginArchivePath));
        PluginManifest plugin = (PluginManifest)uploadResult.readEntity();
        String pluginId = plugin.getId();
        Assertions.assertNoError(this.client.enablePlugin(pluginId));
        ApiResponse disableResult = Assertions.assertNoError(this.client.disablePlugin(pluginId));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((Boolean)disableResult.readEntity()));
        this.client.removePlugin(pluginId);
    }

    @Test
    void getWebappPlugins() throws IOException {
        this.th.logout().loginSystemAdmin();
        ApiResponse response = this.client.getPlugins();
        if (Assertions.isNotSupportVersion("5.2.0", response)) {
            return;
        }
        ApiResponse uploadResult = Assertions.assertNoError(this.client.uploadPlugin(drawPluginArchivePath));
        PluginManifest plugin = (PluginManifest)uploadResult.readEntity();
        String pluginId = plugin.getId();
        Assertions.assertNoError(this.client.enablePlugin(pluginId));
        ApiResponse webappResponse = Assertions.assertNoError(this.client.getWebappPlugins());
        PluginManifest[] webapps = (PluginManifest[])webappResponse.readEntity();
        PluginManifest drawWebapp = Arrays.stream(webapps).filter(m -> m.getId().equals(pluginId)).findFirst().get();
        org.junit.jupiter.api.Assertions.assertEquals((Object)pluginId, (Object)drawWebapp.getId());
        this.client.removePlugin(pluginId);
    }
}

