/*
 * Decompiled with CFR 0.152.
 */
package net.bis5.mattermost.client4.integrationtest.api;

import fi.iki.elonen.NanoHTTPD;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.bis5.mattermost.client4.ApiResponse;
import net.bis5.mattermost.client4.MattermostClient;
import net.bis5.mattermost.client4.integrationtest.Assertions;
import net.bis5.mattermost.client4.integrationtest.MattermostClientTest;
import net.bis5.mattermost.client4.integrationtest.MattermostClientTestExtension;
import net.bis5.mattermost.client4.integrationtest.TestHelper;
import net.bis5.mattermost.model.Config;
import net.bis5.opengraph.models.OpenGraph;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={MattermostClientTestExtension.class})
class OpenGraphApiTest
implements MattermostClientTest {
    private TestHelper th;
    private MattermostClient client;
    NanoHTTPD server;

    OpenGraphApiTest() {
    }

    @Override
    public void setHelper(TestHelper helper) {
        this.th = helper;
    }

    @BeforeEach
    void setup() {
        this.client = this.createClient();
        this.th.changeClient(this.client).initBasic();
    }

    @AfterEach
    void tearDown() {
        this.th.logout();
        this.client.close();
    }

    private String dummyHttpServerHost() {
        return this.getEnv("DUMMY_HTTP_SERVER_HOST", "static.bis5.net");
    }

    private int dummyHttpServerPort() {
        return Integer.valueOf(this.getEnv("DUMMY_HTTP_SERVER_PORT", "0"));
    }

    private boolean useLocalDummyServer() {
        return Boolean.valueOf(this.getEnv("USE_LOCAL_DUMMY_SERVER", "false"));
    }

    @BeforeEach
    void setupServer() throws IOException {
        if (!this.useLocalDummyServer()) {
            return;
        }
        this.server = new NanoHTTPD("0.0.0.0", this.dummyHttpServerPort()){

            public NanoHTTPD.Response serve(NanoHTTPD.IHTTPSession session) {
                List<String> contents = Arrays.asList("<html><head>", "<meta property=\"og:type\" content=\"article\" />", "<meta property=\"og:title\" content=\"The Great WebSite\" />", "<meta property=\"og:url\" content=\"http://localhost:8888/\" />", "</head><body>Hello World!</body></html>");
                return 1.newFixedLengthResponse((String)StringUtils.join(contents, (String)"\r\n"));
            }
        };
        this.server.start();
    }

    @AfterEach
    void tearDownServer() {
        if (!this.useLocalDummyServer()) {
            return;
        }
        this.server.stop();
    }

    @Test
    void getMetadata() {
        this.th.logout().loginSystemAdmin();
        Config config = (Config)this.client.getConfig().readEntity();
        config.getServiceSettings().setAllowedUntrustedInternalConnections(config.getServiceSettings().getAllowedUntrustedInternalConnections() + " " + this.dummyHttpServerHost());
        Assertions.assertNoError(this.client.updateConfig(config));
        this.th.logout().loginBasic();
        int port = this.dummyHttpServerPort();
        String url = "http://" + this.dummyHttpServerHost() + (String)(port != 0 ? ":" + port : "");
        ApiResponse response = this.client.getOpenGraphMetadata(url);
        OpenGraph og = (OpenGraph)response.readEntity();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)og);
    }
}

