/*
 * Decompiled with CFR 0.152.
 */
package net.bis5.mattermost.client4.integrationtest.api;

import jakarta.ws.rs.core.Response;
import net.bis5.mattermost.client4.ApiResponse;
import net.bis5.mattermost.client4.MattermostClient;
import net.bis5.mattermost.client4.integrationtest.Assertions;
import net.bis5.mattermost.client4.integrationtest.MattermostClientTest;
import net.bis5.mattermost.client4.integrationtest.MattermostClientTestExtension;
import net.bis5.mattermost.client4.integrationtest.TestHelper;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={MattermostClientTestExtension.class})
class LdapApiTest
implements MattermostClientTest {
    private TestHelper th;
    private MattermostClient client;

    LdapApiTest() {
    }

    @Override
    public void setHelper(TestHelper helper) {
        this.th = helper;
    }

    @BeforeEach
    void setup() {
        this.client = this.createClient();
        this.th.changeClient(this.client).initBasic();
    }

    @AfterEach
    void tearDown() {
        this.th.logout();
        this.client.close();
    }

    @Test
    void syncLdap() {
        this.th.logout().loginSystemAdmin();
        ApiResponse response = this.client.syncLdap();
        if (Assertions.isSupportVersion("5.12.0", response)) {
            Assertions.assertStatus(response, Response.Status.NOT_IMPLEMENTED);
        }
    }

    @Test
    void testLdap() {
        this.th.logout().loginSystemAdmin();
        ApiResponse response = this.client.testLdap();
        if (Assertions.isSupportVersion("5.12.0", response)) {
            Assertions.assertStatus(response, Response.Status.NOT_IMPLEMENTED);
        }
    }
}

