/*
 * Decompiled with CFR 0.152.
 */
package net.bis5.mattermost.client4.integrationtest.api;

import net.bis5.mattermost.client4.ApiResponse;
import net.bis5.mattermost.client4.MattermostClient;
import net.bis5.mattermost.client4.hook.IncomingWebhookClient;
import net.bis5.mattermost.client4.integrationtest.Assertions;
import net.bis5.mattermost.client4.integrationtest.MattermostClientTest;
import net.bis5.mattermost.client4.integrationtest.MattermostClientTestExtension;
import net.bis5.mattermost.client4.integrationtest.TestHelper;
import net.bis5.mattermost.model.IncomingWebhook;
import net.bis5.mattermost.model.IncomingWebhookRequest;
import net.bis5.mattermost.model.Post;
import net.bis5.mattermost.model.PostList;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={MattermostClientTestExtension.class})
class IncomingWebhookClientTest
implements MattermostClientTest {
    private TestHelper th;
    private MattermostClient client;

    IncomingWebhookClientTest() {
    }

    @Override
    public void setHelper(TestHelper helper) {
        this.th = helper;
    }

    @BeforeEach
    void setup() {
        this.client = this.createClient();
        this.th.changeClient(this.client).initBasic();
    }

    @AfterEach
    void tearDown() {
        this.th.logout();
        this.client.close();
    }

    @Test
    void testHook_IncomingWebhook_Post() {
        this.th.logout().loginTeamAdmin();
        IncomingWebhook webhook = new IncomingWebhook();
        String channelId = this.th.basicChannel().getId();
        String displayName = "webhook" + this.th.newId();
        String description = "description" + this.th.newId();
        webhook.setChannelId(channelId);
        webhook.setDisplayName(displayName);
        webhook.setDescription(description);
        ApiResponse createWebhookResponse = Assertions.assertNoError(this.client.createIncomingWebhook(webhook));
        webhook = (IncomingWebhook)createWebhookResponse.readEntity();
        String hookUrl = this.getApplicationUrl() + "/hooks/" + webhook.getId();
        IncomingWebhookRequest payload = new IncomingWebhookRequest();
        payload.setText("Hello Webhook World");
        IncomingWebhookClient webhookClient = new IncomingWebhookClient(hookUrl);
        ApiResponse response = webhookClient.postByIncomingWebhook(payload);
        Assertions.assertNoError(response);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)response.hasError());
    }

    @Test
    void testHook_IncomingWebhookWithIconEmoji() {
        this.th.logout().loginTeamAdmin();
        IncomingWebhook webhook = new IncomingWebhook();
        String channelId = this.th.basicChannel().getId();
        String displayName = "webhook" + this.th.newId();
        String description = "description" + this.th.newId();
        webhook.setChannelId(channelId);
        webhook.setDisplayName(displayName);
        webhook.setDescription(description);
        ApiResponse createWebhookResponse = Assertions.assertNoError(this.client.createIncomingWebhook(webhook));
        if (Assertions.isNotSupportVersion("5.14.0", createWebhookResponse)) {
            return;
        }
        webhook = (IncomingWebhook)createWebhookResponse.readEntity();
        String hookUrl = this.getApplicationUrl() + "/hooks/" + webhook.getId();
        IncomingWebhookRequest payload = new IncomingWebhookRequest();
        payload.setText("Webhook with icon_emoji" + this.th.newId());
        payload.setIconEmoji("mattermost");
        IncomingWebhookClient webhookClient = new IncomingWebhookClient(hookUrl);
        ApiResponse response = webhookClient.postByIncomingWebhook(payload);
        Assertions.assertNoError(response);
        PostList posts = (PostList)Assertions.assertNoError(this.client.getPostsForChannel(this.th.basicChannel().getId())).readEntity();
        Post webhookPost = posts.getPosts().values().stream().filter(p -> p.getMessage().equals(payload.getText())).findFirst().get();
        MatcherAssert.assertThat(webhookPost.getProps().get("override_icon_url"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
    }
}

