/*
 * Decompiled with CFR 0.152.
 */
package net.bis5.mattermost.client4.integrationtest.api;

import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import net.bis5.mattermost.client4.MattermostClient;
import net.bis5.mattermost.client4.integrationtest.Assertions;
import net.bis5.mattermost.client4.integrationtest.MattermostClientTest;
import net.bis5.mattermost.client4.integrationtest.MattermostClientTestExtension;
import net.bis5.mattermost.client4.integrationtest.TestHelper;
import net.bis5.mattermost.client4.model.FileUploadResult;
import net.bis5.mattermost.model.FileInfo;
import net.bis5.mattermost.model.Post;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={MattermostClientTestExtension.class})
class FilesApiTest
implements MattermostClientTest {
    private TestHelper th;
    private MattermostClient client;

    FilesApiTest() {
    }

    @Override
    public void setHelper(TestHelper helper) {
        this.th = helper;
    }

    @BeforeEach
    void setup() {
        this.client = this.createClient();
        this.th.changeClient(this.client).initBasic();
    }

    @AfterEach
    void tearDown() {
        this.th.logout();
        this.client.close();
    }

    @Test
    void uploadNoFileThrowsException() {
        String channelId = this.th.basicChannel().getId();
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> this.client.uploadFile(channelId, new Path[0]));
    }

    @Test
    void uplaodFile() throws URISyntaxException, IOException {
        Path filePath = this.th.getResourcePath("/noto-emoji_u1f310.png");
        String channelId = this.th.basicChannel().getId();
        FileUploadResult uploadResult = (FileUploadResult)Assertions.assertNoError(this.client.uploadFile(channelId, new Path[]{filePath})).readEntity();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)uploadResult.getFileInfos().length);
        org.junit.jupiter.api.Assertions.assertEquals((Object)filePath.getFileName().toString(), (Object)uploadResult.getFileInfos()[0].getName());
    }

    @Test
    void uploadMultipleFile() throws URISyntaxException, IOException {
        Path file1 = this.th.getResourcePath("/noto-emoji_u1f310.png");
        Path file2 = this.th.getResourcePath("/noto-emoji_u1f6a7.png");
        String channelId = this.th.basicChannel().getId();
        FileUploadResult uploadResult = (FileUploadResult)Assertions.assertNoError(this.client.uploadFile(channelId, new Path[]{file1, file2})).readEntity();
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)uploadResult.getFileInfos().length);
        boolean foundFile1 = false;
        boolean foundFile2 = false;
        for (FileInfo fileInfo : uploadResult.getFileInfos()) {
            foundFile1 = foundFile1 || fileInfo.getName().equals(file1.getFileName().toString());
            foundFile2 = foundFile2 || fileInfo.getName().equals(file2.getFileName().toString());
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)foundFile1);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)foundFile2);
    }

    @Test
    void getFile() throws URISyntaxException, IOException {
        Path filePath = this.th.getResourcePath("/LICENSE.txt");
        String channelId = this.th.basicChannel().getId();
        FileUploadResult uploadResult = (FileUploadResult)Assertions.assertNoError(this.client.uploadFile(channelId, new Path[]{filePath})).readEntity();
        FileInfo fileInfo = uploadResult.getFileInfos()[0];
        String fileId = fileInfo.getId();
        Path receivedFile = (Path)Assertions.assertNoError(this.client.getFile(fileId)).readEntity();
        Assertions.assertSameFile(filePath, receivedFile);
    }

    @Test
    void getFileThumbnail() throws URISyntaxException, IOException {
        Path filePath = this.th.getResourcePath("/noto-emoji_u1f310.png");
        String channelId = this.th.basicChannel().getId();
        FileUploadResult uploadResult = (FileUploadResult)Assertions.assertNoError(this.client.uploadFile(channelId, new Path[]{filePath})).readEntity();
        FileInfo fileInfo = uploadResult.getFileInfos()[0];
        String fileId = fileInfo.getId();
        Path thumbnail = (Path)Assertions.assertNoError(this.client.getFileThumbnail(fileId)).readEntity();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)thumbnail.toFile().exists());
    }

    @Test
    void getFilePreview() throws URISyntaxException, IOException {
        Path filePath = this.th.getResourcePath("/noto-emoji_u1f310.png");
        String channelId = this.th.basicChannel().getId();
        FileUploadResult uploadResult = (FileUploadResult)Assertions.assertNoError(this.client.uploadFile(channelId, new Path[]{filePath})).readEntity();
        FileInfo fileInfo = uploadResult.getFileInfos()[0];
        String fileId = fileInfo.getId();
        Path preview = (Path)Assertions.assertNoError(this.client.getFilePreview(fileId)).readEntity();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)preview.toFile().exists());
    }

    @Test
    void getPublicFileLink() throws URISyntaxException, IOException {
        Path filePath = this.th.getResourcePath("/noto-emoji_u1f310.png");
        String channelId = this.th.basicChannel().getId();
        FileUploadResult uploadResult = (FileUploadResult)Assertions.assertNoError(this.client.uploadFile(channelId, new Path[]{filePath})).readEntity();
        FileInfo fileInfo = uploadResult.getFileInfos()[0];
        String fileId = fileInfo.getId();
        Post post = new Post(channelId, "file attached post");
        post.setFileIds(Collections.singletonList(fileId));
        post = (Post)Assertions.assertNoError(this.client.createPost(post)).readEntity();
        String publicLink = (String)Assertions.assertNoError(this.client.getPublicFileLink(fileId)).readEntity();
        Client jaxrsClient = ClientBuilder.newClient();
        WebTarget target = jaxrsClient.target(publicLink);
        Response response = target.request().get();
        InputStream downloadFile = (InputStream)response.readEntity(InputStream.class);
        Path tempFile = Files.createTempFile(null, null, new FileAttribute[0]);
        Files.copy(downloadFile, tempFile, StandardCopyOption.REPLACE_EXISTING);
        Assertions.assertSameFile(filePath, tempFile);
    }

    @Test
    void getFileMetadata() throws URISyntaxException, IOException {
        Path filePath = this.th.getResourcePath("/noto-emoji_u1f310.png");
        String channelId = this.th.basicChannel().getId();
        FileUploadResult uploadResult = (FileUploadResult)Assertions.assertNoError(this.client.uploadFile(channelId, new Path[]{filePath})).readEntity();
        FileInfo fileInfo = uploadResult.getFileInfos()[0];
        String fileId = fileInfo.getId();
        FileInfo metadata = (FileInfo)Assertions.assertNoError(this.client.getFileMetadata(fileId)).readEntity();
        org.junit.jupiter.api.Assertions.assertEquals((Object)filePath.getFileName().toString(), (Object)metadata.getName());
    }
}

