/*
 * Decompiled with CFR 0.152.
 */
package net.bis5.mattermost.client4.integrationtest.api;

import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import net.bis5.mattermost.client4.ApiResponse;
import net.bis5.mattermost.client4.MattermostClient;
import net.bis5.mattermost.client4.integrationtest.Assertions;
import net.bis5.mattermost.client4.integrationtest.MattermostClientTest;
import net.bis5.mattermost.client4.integrationtest.MattermostClientTestExtension;
import net.bis5.mattermost.client4.integrationtest.TestHelper;
import net.bis5.mattermost.client4.model.SearchEmojiRequest;
import net.bis5.mattermost.model.Emoji;
import net.bis5.mattermost.model.EmojiList;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsIterableContainingInOrder;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={MattermostClientTestExtension.class})
class EmojiApiTest
implements MattermostClientTest {
    private TestHelper th;
    private MattermostClient client;

    EmojiApiTest() {
    }

    @Override
    public void setHelper(TestHelper helper) {
        this.th = helper;
    }

    @BeforeEach
    void setup() {
        this.client = this.createClient();
        this.th.changeClient(this.client).initBasic();
    }

    @AfterEach
    void tearDown() {
        this.th.logout();
        this.client.close();
    }

    @Test
    void createCustomEmoji() throws URISyntaxException, IOException {
        Path image = this.th.getResourcePath("/noto-emoji_u1f310.png");
        Emoji emoji = new Emoji();
        String emojiName = "custom" + this.th.newId();
        emoji.setName(emojiName);
        emoji.setCreatorId(this.th.basicUser().getId());
        ApiResponse response = this.client.createEmoji(emoji, image);
        if (Assertions.isNotSupportVersion("5.4.0", response)) {
            return;
        }
        Emoji createdEmoji = (Emoji)Assertions.assertNoError(response).readEntity();
        MatcherAssert.assertThat((Object)createdEmoji.getName(), (Matcher)CoreMatchers.is((Object)emojiName));
        MatcherAssert.assertThat((Object)createdEmoji.getId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
    }

    @Test
    void getCustomEmojiList() throws URISyntaxException, IOException {
        Path image = this.th.getResourcePath("/noto-emoji_u1f310.png");
        Emoji emoji1 = new Emoji();
        emoji1.setName("custom_" + this.th.newId());
        emoji1.setCreatorId(this.th.basicUser().getId());
        ApiResponse resp1 = this.client.createEmoji(emoji1, image);
        if (Assertions.isNotSupportVersion("5.4.0", resp1)) {
            return;
        }
        emoji1 = (Emoji)Assertions.assertNoError(resp1).readEntity();
        Emoji emoji2 = new Emoji();
        emoji2.setName("custom_" + this.th.newId());
        emoji2.setCreatorId(this.th.basicUser().getId());
        emoji2 = (Emoji)this.client.createEmoji(emoji2, image).readEntity();
        ApiResponse response = Assertions.assertNoError(this.client.getEmojiList());
        List emojiList = (List)response.readEntity();
        MatcherAssert.assertThat(emojiList.stream().map(Emoji::getId).collect(Collectors.toList()), (Matcher)CoreMatchers.hasItems((Object[])new String[]{emoji1.getId(), emoji2.getId()}));
    }

    @Test
    void getCustomEmojiListInOrder() throws URISyntaxException, IOException {
        Path image = this.th.getResourcePath("/noto-emoji_u1f310.png");
        Emoji emoji1 = new Emoji();
        emoji1.setName("custom1_" + this.th.newId());
        emoji1.setCreatorId(this.th.basicUser().getId());
        ApiResponse resp1 = this.client.createEmoji(emoji1, image);
        if (Assertions.isNotSupportVersion("5.4.0", resp1)) {
            return;
        }
        emoji1 = (Emoji)Assertions.assertNoError(resp1).readEntity();
        Emoji emoji2 = new Emoji();
        emoji2.setName("custom2_" + this.th.newId());
        emoji2.setCreatorId(this.th.basicUser().getId());
        emoji2 = (Emoji)this.client.createEmoji(emoji2, image).readEntity();
        ApiResponse response = Assertions.assertNoError(this.client.getEmojiListSorted());
        List emojiList = (List)response.readEntity();
        HashSet<String> validIds = new HashSet<String>(Arrays.asList(emoji1.getId(), emoji2.getId()));
        List returnedEmojiIdOrder = emojiList.stream().map(Emoji::getId).filter(i -> validIds.contains(i)).collect(Collectors.toList());
        MatcherAssert.assertThat(returnedEmojiIdOrder, (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{emoji1.getId(), emoji2.getId()}));
    }

    @Test
    void getCustomEmoji() throws URISyntaxException, IOException {
        Path image = this.th.getResourcePath("/noto-emoji_u1f310.png");
        Emoji emoji = new Emoji();
        emoji.setName("custom" + this.th.newId());
        emoji.setCreatorId(this.th.basicUser().getId());
        ApiResponse resp1 = this.client.createEmoji(emoji, image);
        if (Assertions.isNotSupportVersion("5.4.0", resp1)) {
            return;
        }
        emoji = (Emoji)Assertions.assertNoError(resp1).readEntity();
        String emojiId = emoji.getId();
        ApiResponse response = Assertions.assertNoError(this.client.getEmoji(emojiId));
        Emoji responseEmoji = (Emoji)response.readEntity();
        MatcherAssert.assertThat((Object)responseEmoji.getName(), (Matcher)CoreMatchers.is((Object)emoji.getName()));
    }

    @Test
    void deleteCustomEmoji() throws URISyntaxException, IOException {
        Path image = this.th.getResourcePath("/noto-emoji_u1f310.png");
        Emoji emoji = new Emoji();
        emoji.setName("custom" + this.th.newId());
        emoji.setCreatorId(this.th.basicUser().getId());
        ApiResponse resp1 = this.client.createEmoji(emoji, image);
        if (Assertions.isNotSupportVersion("5.4.0", resp1)) {
            return;
        }
        emoji = (Emoji)Assertions.assertNoError(resp1).readEntity();
        String emojiId = emoji.getId();
        ApiResponse response = Assertions.assertNoError(this.client.deleteEmoji(emojiId));
        Boolean result = (Boolean)response.readEntity();
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat(((EmojiList)this.client.getEmojiList().readEntity()).stream().map(Emoji::getId).collect(Collectors.toSet()), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItem((Object)emojiId))));
    }

    @Test
    void getCustomEmojiImage() throws URISyntaxException, IOException {
        Path originalImage = this.th.getResourcePath("/noto-emoji_u1f310.png");
        Emoji emoji = new Emoji();
        emoji.setName("custom" + this.th.newId());
        emoji.setCreatorId(this.th.basicUser().getId());
        ApiResponse response = this.client.createEmoji(emoji, originalImage);
        if (Assertions.isNotSupportVersion("5.4.0", response)) {
            return;
        }
        emoji = (Emoji)Assertions.assertNoError(response).readEntity();
        String emojiId = emoji.getId();
        ApiResponse emojiImage = Assertions.assertNoError(this.client.getEmojiImage(emojiId));
        Path downloadedFile = (Path)emojiImage.readEntity();
        Assertions.assertSameFile(originalImage, downloadedFile);
    }

    @Test
    void getCustomEmojiByName() throws URISyntaxException, IOException {
        Path image = this.th.getResourcePath("/noto-emoji_u1f310.png");
        Emoji emoji = new Emoji();
        emoji.setName("custom" + this.th.newId());
        emoji.setCreatorId(this.th.basicUser().getId());
        ApiResponse resp1 = this.client.createEmoji(emoji, image);
        if (Assertions.isNotSupportVersion("5.4.0", resp1)) {
            return;
        }
        emoji = (Emoji)Assertions.assertNoError(resp1).readEntity();
        String emojiName = emoji.getName();
        ApiResponse response = Assertions.assertNoError(this.client.getEmojiByName(emojiName));
        Emoji responseEmoji = (Emoji)response.readEntity();
        org.junit.jupiter.api.Assertions.assertEquals((Object)emoji.getId(), (Object)responseEmoji.getId());
    }

    @Test
    void searchEmoji() throws URISyntaxException, IOException {
        Path emojiGlobe = this.th.getResourcePath("/noto-emoji_u1f310.png");
        Emoji emoji = new Emoji();
        emoji.setName("customGlobe" + this.th.newId());
        emoji.setCreatorId(this.th.basicUser().getId());
        ApiResponse createEmojiResponse = this.client.createEmoji(emoji, emojiGlobe);
        if (Assertions.isNotSupportVersion("5.4.0", createEmojiResponse)) {
            return;
        }
        emoji = (Emoji)Assertions.assertNoError(createEmojiResponse).readEntity();
        SearchEmojiRequest criteria = SearchEmojiRequest.builder().term("Globe").build();
        ApiResponse searchResponse = Assertions.assertNoError(this.client.searchEmoji(criteria));
        EmojiList searchResult = (EmojiList)searchResponse.readEntity();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)searchResult.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)emoji.getId(), (Object)((Emoji)searchResult.get(0)).getId());
        criteria = SearchEmojiRequest.builder().term("Globe").prefixOnly(true).build();
        searchResponse = Assertions.assertNoError(this.client.searchEmoji(criteria));
        searchResult = (EmojiList)searchResponse.readEntity();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)searchResult.isEmpty());
    }

    @Test
    void autocompleteEmoji() throws URISyntaxException, IOException {
        Path emojiGlobe = this.th.getResourcePath("/noto-emoji_u1f310.png");
        Emoji emoji = new Emoji();
        emoji.setName("customAutocompleteGlobe" + this.th.newId());
        emoji.setCreatorId(this.th.basicUser().getId());
        ApiResponse createEmojiResponse = this.client.createEmoji(emoji, emojiGlobe);
        if (Assertions.isNotSupportVersion("5.4.0", createEmojiResponse)) {
            return;
        }
        emoji = (Emoji)Assertions.assertNoError(createEmojiResponse).readEntity();
        String name = "customAuto";
        ApiResponse autocompleteResponse = Assertions.assertNoError(this.client.autocompleteEmoji(name));
        EmojiList autocompleteList = (EmojiList)autocompleteResponse.readEntity();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)autocompleteList.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)emoji.getId(), (Object)((Emoji)autocompleteList.get(0)).getId());
    }
}

