/*
 * Decompiled with CFR 0.152.
 */
package net.bis5.mattermost.client4.integrationtest.api;

import java.util.List;
import java.util.stream.Collectors;
import net.bis5.mattermost.client4.ApiResponse;
import net.bis5.mattermost.client4.MattermostClient;
import net.bis5.mattermost.client4.integrationtest.Assertions;
import net.bis5.mattermost.client4.integrationtest.MattermostClientTest;
import net.bis5.mattermost.client4.integrationtest.MattermostClientTestExtension;
import net.bis5.mattermost.client4.integrationtest.TestHelper;
import net.bis5.mattermost.model.Command;
import net.bis5.mattermost.model.CommandList;
import net.bis5.mattermost.model.CommandMethod;
import net.bis5.mattermost.model.CommandResponse;
import net.bis5.mattermost.model.CommandResponseType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={MattermostClientTestExtension.class})
class CommandsApiTest
implements MattermostClientTest {
    private TestHelper th;
    private MattermostClient client;

    CommandsApiTest() {
    }

    @Override
    public void setHelper(TestHelper helper) {
        this.th = helper;
    }

    @BeforeEach
    void setup() {
        this.client = this.createClient();
        this.th.changeClient(this.client).initBasic();
    }

    @AfterEach
    void tearDown() {
        this.th.logout();
        this.client.close();
    }

    @Test
    void createCommand() {
        this.th.loginTeamAdmin();
        Command command = new Command();
        command.setTeamId(this.th.basicTeam().getId());
        command.setMethod(CommandMethod.GET);
        command.setTrigger("trigger");
        command.setUrl("http://url");
        command.setDescription(this.th.newRandomString(32));
        command.setUserName("username");
        command.setIconUrl("http://icon-url");
        command.setAutoComplete(true);
        command.setAutoCompleteDesc(this.th.newRandomString(32));
        command.setAutoCompleteHint(this.th.newRandomString(32));
        ApiResponse response = Assertions.assertNoError(this.client.createCommand(command));
        Command created = (Command)response.readEntity();
        MatcherAssert.assertThat((Object)created.getId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        MatcherAssert.assertThat((Object)created.getToken(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        MatcherAssert.assertThat((Object)created.getTeamId(), (Matcher)CoreMatchers.is((Object)command.getTeamId()));
        MatcherAssert.assertThat((Object)created.getMethod(), (Matcher)CoreMatchers.is((Object)command.getMethod()));
        MatcherAssert.assertThat((Object)created.getTrigger(), (Matcher)CoreMatchers.is((Object)command.getTrigger()));
        MatcherAssert.assertThat((Object)created.getUrl(), (Matcher)CoreMatchers.is((Object)command.getUrl()));
        MatcherAssert.assertThat((Object)created.getDescription(), (Matcher)CoreMatchers.is((Object)command.getDescription()));
        MatcherAssert.assertThat((Object)created.getUserName(), (Matcher)CoreMatchers.is((Object)command.getUserName()));
        MatcherAssert.assertThat((Object)created.getIconUrl(), (Matcher)CoreMatchers.is((Object)command.getIconUrl()));
        MatcherAssert.assertThat((Object)created.isAutoComplete(), (Matcher)CoreMatchers.is((Object)command.isAutoComplete()));
        MatcherAssert.assertThat((Object)created.getAutoCompleteDesc(), (Matcher)CoreMatchers.is((Object)command.getAutoCompleteDesc()));
        MatcherAssert.assertThat((Object)created.getAutoCompleteHint(), (Matcher)CoreMatchers.is((Object)command.getAutoCompleteHint()));
    }

    @Test
    void listCommandsForTeam() {
        this.th.logout().loginTeamAdmin();
        String teamId = this.th.basicTeam().getId();
        Command command = new Command();
        command.setTeamId(teamId);
        command.setMethod(CommandMethod.GET);
        command.setTrigger("trigger");
        command.setUrl("http://url");
        command = (Command)Assertions.assertNoError(this.client.createCommand(command)).readEntity();
        ApiResponse response = Assertions.assertNoError(this.client.listCommands(teamId));
        List commands = (List)response.readEntity();
        MatcherAssert.assertThat((Object)commands.size(), (Matcher)CoreMatchers.is((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1))));
        MatcherAssert.assertThat(commands.stream().map(Command::getId).collect(Collectors.toSet()), (Matcher)CoreMatchers.hasItem((Object)command.getId()));
    }

    @Test
    void listCommandForTeamExcludeSystemCommands() {
        this.th.logout().loginTeamAdmin();
        String teamId = this.th.basicTeam().getId();
        Command command = new Command();
        command.setTeamId(teamId);
        command.setMethod(CommandMethod.GET);
        command.setTrigger("trigger");
        command.setUrl("http://ur)");
        command = (Command)Assertions.assertNoError(this.client.createCommand(command)).readEntity();
        ApiResponse response = Assertions.assertNoError(this.client.listCommands(teamId, true));
        List commands = (List)response.readEntity();
        MatcherAssert.assertThat((Object)commands.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat(commands.stream().map(Command::getId).collect(Collectors.toSet()), (Matcher)CoreMatchers.hasItem((Object)command.getId()));
    }

    @Test
    void getAutoCompleteCommands() {
        this.th.loginTeamAdmin();
        String teamId = this.th.basicTeam().getId();
        Command autoCompleteCmd = new Command();
        autoCompleteCmd.setAutoComplete(true);
        autoCompleteCmd.setAutoCompleteDesc(this.th.newRandomString(32));
        autoCompleteCmd.setAutoCompleteHint(this.th.newRandomString(32));
        autoCompleteCmd.setTeamId(teamId);
        autoCompleteCmd.setMethod(CommandMethod.GET);
        autoCompleteCmd.setTrigger("trigger1");
        autoCompleteCmd.setUrl("http://url1");
        autoCompleteCmd = (Command)Assertions.assertNoError(this.client.createCommand(autoCompleteCmd)).readEntity();
        Command noCompleteCmd = new Command();
        noCompleteCmd.setTeamId(teamId);
        noCompleteCmd.setMethod(CommandMethod.GET);
        noCompleteCmd.setTrigger("trigger2");
        noCompleteCmd.setUrl("http://url2");
        noCompleteCmd = (Command)Assertions.assertNoError(this.client.createCommand(noCompleteCmd)).readEntity();
        this.th.logout();
        this.th.loginBasic();
        ApiResponse response = Assertions.assertNoError(this.client.listAutocompleteCommands(teamId));
        List commandList = (List)response.readEntity();
        MatcherAssert.assertThat(commandList.stream().map(Command::getId).collect(Collectors.toSet()), (Matcher)CoreMatchers.hasItem((Object)autoCompleteCmd.getId()));
    }

    @Test
    void updateCommand() {
        this.th.logout().loginTeamAdmin();
        Command command = new Command();
        command.setTeamId(this.th.basicTeam().getId());
        command.setMethod(CommandMethod.GET);
        command.setTrigger("trigger");
        command.setUrl("http://url");
        command.setUserName(this.th.newRandomString(8));
        command.setIconUrl("http://icon-url");
        command.setAutoComplete(true);
        command.setAutoCompleteDesc(this.th.newRandomString(32));
        command.setAutoCompleteHint(this.th.newRandomString(32));
        command.setDisplayName(this.th.newRandomString(32));
        command.setDescription(this.th.newRandomString(32));
        command = (Command)Assertions.assertNoError(this.client.createCommand(command)).readEntity();
        command.setMethod(CommandMethod.POST);
        command.setTrigger("new" + command.getTrigger());
        command.setUrl(command.getUrl() + "/new");
        command.setUserName("new" + command.getUserName());
        command.setIconUrl(command.getIconUrl() + "/new");
        command.setAutoCompleteDesc("new" + command.getAutoCompleteDesc());
        command.setAutoCompleteHint("new" + command.getAutoCompleteHint());
        command.setDisplayName("new" + command.getDisplayName());
        command.setDescription("new" + command.getDescription());
        ApiResponse response = Assertions.assertNoError(this.client.updateCommand(command));
        Command updated = (Command)response.readEntity();
        MatcherAssert.assertThat((Object)updated.getId(), (Matcher)CoreMatchers.is((Object)command.getId()));
        MatcherAssert.assertThat((Object)updated.getMethod(), (Matcher)CoreMatchers.is((Object)command.getMethod()));
        MatcherAssert.assertThat((Object)updated.getTrigger(), (Matcher)CoreMatchers.is((Object)command.getTrigger()));
        MatcherAssert.assertThat((Object)updated.getUrl(), (Matcher)CoreMatchers.is((Object)command.getUrl()));
        MatcherAssert.assertThat((Object)updated.getUserName(), (Matcher)CoreMatchers.is((Object)command.getUserName()));
        MatcherAssert.assertThat((Object)updated.getIconUrl(), (Matcher)CoreMatchers.is((Object)command.getIconUrl()));
        MatcherAssert.assertThat((Object)updated.isAutoComplete(), (Matcher)CoreMatchers.is((Object)command.isAutoComplete()));
        MatcherAssert.assertThat((Object)updated.getAutoCompleteDesc(), (Matcher)CoreMatchers.is((Object)command.getAutoCompleteDesc()));
        MatcherAssert.assertThat((Object)updated.getAutoCompleteHint(), (Matcher)CoreMatchers.is((Object)command.getAutoCompleteHint()));
        MatcherAssert.assertThat((Object)updated.getDisplayName(), (Matcher)CoreMatchers.is((Object)command.getDisplayName()));
        MatcherAssert.assertThat((Object)updated.getDescription(), (Matcher)CoreMatchers.is((Object)command.getDescription()));
    }

    @Test
    void deleteCommand() {
        this.th.logout().loginTeamAdmin();
        Command command = new Command();
        command.setTeamId(this.th.basicTeam().getId());
        command.setMethod(CommandMethod.GET);
        command.setTrigger("trigger");
        command.setUrl("http://url");
        command = (Command)Assertions.assertNoError(this.client.createCommand(command)).readEntity();
        String commandId = command.getId();
        ApiResponse response = Assertions.assertNoError(this.client.deleteCommand(commandId));
        boolean result = (Boolean)response.readEntity();
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat(((CommandList)this.client.listCommands(this.th.basicTeam().getId(), true).readEntity()).stream().map(Command::getId).collect(Collectors.toSet()), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItem((Object)commandId)));
    }

    @Test
    void generateNewToken() {
        this.th.logout().loginTeamAdmin();
        Command command = new Command();
        command.setTeamId(this.th.basicTeam().getId());
        command.setMethod(CommandMethod.GET);
        command.setTrigger("trigger");
        command.setUrl("http://url");
        command = (Command)Assertions.assertNoError(this.client.createCommand(command)).readEntity();
        String currentToken = command.getToken();
        String commandId = command.getId();
        ApiResponse response = Assertions.assertNoError(this.client.regenCommandToken(commandId));
        String newToken = (String)response.readEntity();
        MatcherAssert.assertThat((Object)newToken, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)currentToken)));
    }

    @Test
    void executeCommand() {
        String inChannel = this.th.basicChannel().getId();
        String command = "/away";
        ApiResponse response = Assertions.assertNoError(this.client.executeCommand(inChannel, command));
        CommandResponse commandResponse = (CommandResponse)response.readEntity();
        MatcherAssert.assertThat((Object)commandResponse.getResponseType(), (Matcher)CoreMatchers.is((Object)CommandResponseType.Ephemeral));
        MatcherAssert.assertThat((Object)commandResponse.getText(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
    }
}

