/*
 * Decompiled with CFR 0.152.
 */
package net.bis5.mattermost.client4.integrationtest.api;

import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.bis5.mattermost.client4.ApiResponse;
import net.bis5.mattermost.client4.MattermostClient;
import net.bis5.mattermost.client4.Pager;
import net.bis5.mattermost.client4.integrationtest.Assertions;
import net.bis5.mattermost.client4.integrationtest.MattermostClientTest;
import net.bis5.mattermost.client4.integrationtest.MattermostClientTestExtension;
import net.bis5.mattermost.client4.integrationtest.TestHelper;
import net.bis5.mattermost.model.Channel;
import net.bis5.mattermost.model.ChannelList;
import net.bis5.mattermost.model.ChannelMember;
import net.bis5.mattermost.model.ChannelMembers;
import net.bis5.mattermost.model.ChannelPatch;
import net.bis5.mattermost.model.ChannelStats;
import net.bis5.mattermost.model.ChannelType;
import net.bis5.mattermost.model.ChannelUnread;
import net.bis5.mattermost.model.ChannelView;
import net.bis5.mattermost.model.ChannelViewResponse;
import net.bis5.mattermost.model.Post;
import net.bis5.mattermost.model.PostList;
import net.bis5.mattermost.model.Role;
import net.bis5.mattermost.model.Team;
import net.bis5.mattermost.model.User;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsIterableContainingInAnyOrder;
import org.hamcrest.number.OrderingComparison;
import org.hamcrest.text.IsEmptyString;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={MattermostClientTestExtension.class})
class ChannelsApiTest
implements MattermostClientTest {
    private TestHelper th;
    private MattermostClient client;

    ChannelsApiTest() {
    }

    @Override
    public void setHelper(TestHelper helper) {
        this.th = helper;
    }

    @BeforeEach
    void setup() {
        this.client = this.createClient();
        this.th.changeClient(this.client).initBasic();
    }

    @AfterEach
    void tearDown() {
        this.th.logout();
        this.client.close();
    }

    @Test
    void createChannel_Open_Required() {
        Channel channel = new Channel("DisplayName", "name", ChannelType.Open, this.th.basicTeam().getId());
        this.createChannel_Success(channel);
    }

    @Test
    void createChannel_Open_All() {
        Channel channel = new Channel("DisplayName", "name", ChannelType.Open, this.th.basicTeam().getId());
        channel.setPurpose("purpose");
        channel.setHeader("header");
        this.createChannel_Success(channel);
    }

    @Test
    void createChannel_Private_Required() {
        Channel channel = new Channel("DisplayName", "name", ChannelType.Private, this.th.basicTeam().getId());
        this.createChannel_Success(channel);
    }

    @Test
    void createChannel_Private_All() {
        Channel channel = new Channel("DisplayName", "name", ChannelType.Private, this.th.basicTeam().getId());
        channel.setPurpose("purpose");
        channel.setHeader("header");
        this.createChannel_Success(channel);
    }

    @Test
    void createChannel_Fail_Direct() {
        Channel channel = new Channel("DisplayName", "name", ChannelType.Direct, this.th.basicTeam().getId());
        Assertions.assertStatus(this.client.createChannel(channel), Response.Status.BAD_REQUEST);
    }

    private void createChannel_Success(Channel channel) {
        String teamId = channel.getTeamId();
        String name = channel.getName();
        String displayName = channel.getDisplayName();
        ChannelType type = channel.getType();
        String purpose = channel.getPurpose();
        String header = channel.getHeader();
        ApiResponse response = Assertions.assertNoError(this.client.createChannel(channel));
        channel = (Channel)response.readEntity();
        MatcherAssert.assertThat((Object)channel.getTeamId(), (Matcher)CoreMatchers.is((Object)teamId));
        MatcherAssert.assertThat((Object)channel.getName(), (Matcher)CoreMatchers.is((Object)name));
        MatcherAssert.assertThat((Object)channel.getDisplayName(), (Matcher)CoreMatchers.is((Object)displayName));
        MatcherAssert.assertThat((Object)channel.getType(), (Matcher)CoreMatchers.is((Object)type));
        MatcherAssert.assertThat((Object)channel.getPurpose(), (Matcher)(purpose == null ? IsEmptyString.isEmptyOrNullString() : CoreMatchers.is((Object)purpose)));
        MatcherAssert.assertThat((Object)channel.getHeader(), (Matcher)(header == null ? IsEmptyString.isEmptyOrNullString() : CoreMatchers.is((Object)header)));
    }

    @Test
    void createDirectChannel() {
        User user1 = this.th.basicUser();
        User user2 = this.th.basicUser2();
        ApiResponse response = Assertions.assertNoError(this.client.createDirectChannel(user1.getId(), user2.getId()));
        Channel channel = (Channel)response.readEntity();
        MatcherAssert.assertThat((Object)channel, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    void createDirectChannel_OneUser() {
        Assertions.assertStatus(this.client.createDirectChannel(this.th.basicUser().getId(), null), Response.Status.BAD_REQUEST);
    }

    @Test
    void createGroupChannel() {
        User user1 = this.th.basicUser();
        User user2 = this.th.basicUser2();
        User user3 = this.th.createUser();
        this.th.loginSystemAdmin().linkUserToTeam(user3, this.th.basicTeam()).loginBasic();
        ApiResponse response = Assertions.assertNoError(this.client.createGroupChannel(new String[]{user1.getId(), user2.getId(), user3.getId()}));
        Channel channel = (Channel)response.readEntity();
        MatcherAssert.assertThat((Object)channel, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    void createGroupChannel_Fail_TwoUsers() {
        User user1 = this.th.basicUser();
        User user2 = this.th.basicUser2();
        Assertions.assertStatus(this.client.createGroupChannel(new String[]{user1.getId(), user2.getId()}), Response.Status.BAD_REQUEST);
    }

    @Test
    void channelListByTeamId() {
        Team theTeam = this.th.loginSystemAdmin().createTeam();
        User theUser = this.th.createUser();
        this.th.linkUserToTeam(theUser, theTeam);
        Channel channel1 = new Channel("displayname1", "name1", ChannelType.Open, theTeam.getId());
        Channel channel2 = new Channel("displayname2", "name2", ChannelType.Open, theTeam.getId());
        channel1 = (Channel)this.client.createChannel(channel1).readEntity();
        channel2 = (Channel)this.client.createChannel(channel2).readEntity();
        this.th.loginAs(theUser);
        ApiResponse response = Assertions.assertNoError(this.client.getPublicChannelsByIdsForTeam(theTeam.getId(), new String[]{channel1.getId(), channel2.getId()}));
        ChannelList channels = (ChannelList)response.readEntity();
        List ids = channels.stream().map(Channel::getId).collect(Collectors.toList());
        MatcherAssert.assertThat((Object)ids.size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat(ids, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{channel1.getId(), channel2.getId()}));
    }

    @Test
    void getAChannel() {
        String channelId = this.th.basicChannel().getId();
        ApiResponse response = Assertions.assertNoError(this.client.getChannel(channelId, null));
        Channel channel = (Channel)response.readEntity();
        MatcherAssert.assertThat((Object)channel.getId(), (Matcher)CoreMatchers.is((Object)channelId));
    }

    @Test
    void updateChannel() {
        String channelId = this.th.basicChannel().getId();
        String newName = "new-channel-name";
        String newDispName = "New Display Name";
        String newPurpose = "New Purpose";
        String newHeader = "New Header";
        Channel newChannel = new Channel();
        newChannel.setId(channelId);
        newChannel.setName(newName);
        newChannel.setDisplayName(newDispName);
        newChannel.setPurpose(newPurpose);
        newChannel.setHeader(newHeader);
        ApiResponse response = Assertions.assertNoError(this.client.updateChannel(newChannel));
        newChannel = (Channel)response.readEntity();
        MatcherAssert.assertThat((Object)newChannel.getName(), (Matcher)CoreMatchers.is((Object)newName));
        MatcherAssert.assertThat((Object)newChannel.getDisplayName(), (Matcher)CoreMatchers.is((Object)newDispName));
        MatcherAssert.assertThat((Object)newChannel.getPurpose(), (Matcher)CoreMatchers.is((Object)newPurpose));
        MatcherAssert.assertThat((Object)newChannel.getHeader(), (Matcher)CoreMatchers.is((Object)newHeader));
    }

    @Test
    void updateChannel_ChannelNotFound() {
        String channelId = this.th.newId();
        String newName = "new-channel-name";
        String newDispName = "New Display Name";
        String newPurpose = "New Purpose";
        String newHeader = "New Header";
        Channel newChannel = new Channel();
        newChannel.setId(channelId);
        newChannel.setName(newName);
        newChannel.setDisplayName(newDispName);
        newChannel.setPurpose(newPurpose);
        newChannel.setHeader(newHeader);
        Assertions.assertStatus(this.client.updateChannel(newChannel), Response.Status.NOT_FOUND);
    }

    @Test
    @Disabled
    void updateChannel_ChangeType() {
        String channelId = this.th.basicChannel().getId();
        MatcherAssert.assertThat((Object)this.th.basicChannel().getType(), (Matcher)CoreMatchers.is((Object)ChannelType.Open));
        ChannelType newType = ChannelType.Private;
        Channel newChannel = new Channel();
        newChannel.setId(channelId);
        newChannel.setType(newType);
        ApiResponse response = Assertions.assertNoError(this.client.updateChannel(newChannel));
        newChannel = (Channel)response.readEntity();
        MatcherAssert.assertThat((Object)newChannel.getType(), (Matcher)CoreMatchers.is((Object)newType));
    }

    @Test
    void deleteChannel() {
        String channelId = this.th.basicChannel().getId();
        ApiResponse deleteResponse = Assertions.assertNoError(this.client.deleteChannel(channelId));
        boolean deleteResult = (Boolean)deleteResponse.readEntity();
        MatcherAssert.assertThat((Object)deleteResult, (Matcher)CoreMatchers.is((Object)true));
        ApiResponse response = Assertions.assertNoError(this.client.getChannel(channelId, null));
        MatcherAssert.assertThat((Object)((Channel)response.readEntity()).getDeleteAt(), (Matcher)CoreMatchers.is((Matcher)OrderingComparison.greaterThan((Comparable)Long.valueOf(0L))));
    }

    @Test
    void patchChannel() {
        String channelId = this.th.basicChannel().getId();
        String newDispName = "new Display name";
        ChannelPatch patch = new ChannelPatch();
        patch.setDisplayName(newDispName);
        ApiResponse response = Assertions.assertNoError(this.client.patchChannel(channelId, patch));
        Channel newChannel = (Channel)response.readEntity();
        MatcherAssert.assertThat((Object)newChannel.getDisplayName(), (Matcher)CoreMatchers.is((Object)newDispName));
    }

    @Test
    void patchChannel_ChannelNotFound() {
        String channelId = this.th.newId();
        String newDispName = "new Display name";
        ChannelPatch patch = new ChannelPatch();
        patch.setDisplayName(newDispName);
        Assertions.assertStatus(this.client.patchChannel(channelId, patch), Response.Status.NOT_FOUND);
    }

    @Test
    void restoreChannel() {
        Channel channel = this.th.createPublicChannel();
        ApiResponse deleteResult = Assertions.assertNoError(this.client.deleteChannel(channel.getId()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((Boolean)deleteResult.readEntity()));
        this.th.logout().loginTeamAdmin();
        ApiResponse restoreResult = Assertions.assertNoError(this.client.restoreChannel(channel.getId()));
        Channel restoredChannel = (Channel)restoreResult.readEntity();
        org.junit.jupiter.api.Assertions.assertEquals((Object)restoredChannel.getId(), (Object)channel.getId());
        this.th.logout().loginSystemAdmin();
        Assertions.assertNoError(this.client.invalidateCaches());
        this.th.logout().loginTeamAdmin();
        restoredChannel = (Channel)this.client.getChannel(channel.getId()).readEntity();
        MatcherAssert.assertThat((Object)restoredChannel.getDeleteAt(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    void getChannelStatistics() {
        String channelId = this.th.basicChannel().getId();
        ApiResponse response = Assertions.assertNoError(this.client.getChannelStats(channelId, null));
        ChannelStats stats = (ChannelStats)response.readEntity();
        MatcherAssert.assertThat((Object)stats.getChannelId(), (Matcher)CoreMatchers.is((Object)channelId));
    }

    @Test
    void getChannelPinnedPosts() {
        String channelId = this.th.basicChannel().getId();
        Post pinned = this.th.createPinnedPost(channelId);
        ApiResponse response = Assertions.assertNoError(this.client.getPinnedPosts(channelId, null));
        PostList posts = (PostList)response.readEntity();
        MatcherAssert.assertThat((Object)posts.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)((Post)posts.getPosts().get(pinned.getId())), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    void getChannelByName() {
        String channelName = this.th.basicChannel().getName();
        ApiResponse response = Assertions.assertNoError(this.client.getChannelByName(channelName, this.th.basicTeam().getId(), null));
        Channel channel = (Channel)response.readEntity();
        MatcherAssert.assertThat((Object)channel.getId(), (Matcher)CoreMatchers.is((Object)this.th.basicChannel().getId()));
    }

    @Test
    void getChannelByName_ChannelNotFound() {
        String channelName = "fake-channel-name";
        Assertions.assertStatus(this.client.getChannelByName(channelName, this.th.basicTeam().getId(), null), Response.Status.NOT_FOUND);
    }

    @Test
    void getChannelByNameAndTeamName() {
        String channelName = this.th.basicChannel().getName();
        String teamName = this.th.basicTeam().getName();
        ApiResponse response = Assertions.assertNoError(this.client.getChannelByNameForTeamName(channelName, teamName, null));
        Channel channel = (Channel)response.readEntity();
        MatcherAssert.assertThat((Object)channel.getId(), (Matcher)CoreMatchers.is((Object)this.th.basicChannel().getId()));
    }

    @Test
    void getChannelByNameAndTeamName_ChannelNotFound() {
        String channelName = "fake-channel-name";
        String teamName = this.th.basicTeam().getName();
        Assertions.assertStatus(this.client.getChannelByNameForTeamName(channelName, teamName, null), Response.Status.NOT_FOUND);
    }

    @Test
    void getChannelByNameAndTeamName_TeamNotFound() {
        String channelName = "fake-channel-name";
        String teamName = "fake-team-name";
        Assertions.assertStatus(this.client.getChannelByNameForTeamName(channelName, teamName, null), Response.Status.NOT_FOUND);
    }

    @Test
    void getChannelMembers() {
        User user1 = this.th.createUser();
        User user2 = this.th.createUser();
        this.th.loginSystemAdmin().linkUserToTeam(user1, this.th.basicTeam()).linkUserToTeam(user2, this.th.basicTeam()).loginAs(user1);
        Channel channel = this.th.createPublicChannel();
        this.client.addChannelMember(channel.getId(), user1.getId());
        this.client.addChannelMember(channel.getId(), user2.getId());
        ApiResponse response = Assertions.assertNoError(this.client.getChannelMembers(channel.getId(), Pager.of((int)0, (int)60), null));
        ChannelMembers members = (ChannelMembers)response.readEntity();
        MatcherAssert.assertThat((Object)members.size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat(members.stream().map(m -> m.getUserId()).collect(Collectors.toSet()), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{user1.getId(), user2.getId()}));
    }

    @Test
    void addUserToChannel() {
        Channel channel = this.th.basicChannel();
        User user = this.th.createUser();
        this.th.loginSystemAdmin().linkUserToTeam(user, this.th.basicTeam()).loginBasic();
        ApiResponse response = Assertions.assertNoError(this.client.addChannelMember(channel.getId(), user.getId()));
        ChannelMember member = (ChannelMember)response.readEntity();
        MatcherAssert.assertThat((Object)member.getChannelId(), (Matcher)CoreMatchers.is((Object)channel.getId()));
        MatcherAssert.assertThat((Object)member.getUserId(), (Matcher)CoreMatchers.is((Object)user.getId()));
    }

    @Test
    void getChannelMembersByIds() {
        Channel channel = this.th.createPublicChannel();
        User user1 = this.th.createUser();
        User user2 = this.th.createUser();
        this.th.loginSystemAdmin().linkUserToTeam(user1, this.th.basicTeam()).linkUserToTeam(user2, this.th.basicTeam()).loginBasic();
        this.client.addChannelMember(channel.getId(), user1.getId());
        this.client.addChannelMember(channel.getId(), user2.getId());
        ApiResponse response = Assertions.assertNoError(this.client.getChannelMembersByIds(channel.getId(), new String[]{user1.getId(), user2.getId()}));
        ChannelMembers members = (ChannelMembers)response.readEntity();
        MatcherAssert.assertThat((Object)members.size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat(members.stream().map(m -> m.getUserId()).collect(Collectors.toSet()), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{user1.getId(), user2.getId()}));
    }

    @Test
    void getChannelMember() {
        Channel channel = this.th.basicChannel();
        User user = this.th.basicUser();
        ApiResponse response = Assertions.assertNoError(this.client.getChannelMember(channel.getId(), user.getId(), null));
        ChannelMember member = (ChannelMember)response.readEntity();
        MatcherAssert.assertThat((Object)member.getChannelId(), (Matcher)CoreMatchers.is((Object)channel.getId()));
        MatcherAssert.assertThat((Object)member.getUserId(), (Matcher)CoreMatchers.is((Object)user.getId()));
    }

    @Test
    void removeUserFromChannel() {
        Channel channel = this.th.basicChannel();
        User user = this.th.basicUser2();
        ApiResponse response = Assertions.assertNoError(this.client.removeUserFromChannel(channel.getId(), user.getId()));
        boolean result = (Boolean)response.readEntity();
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    void updateChannelRoles() {
        User channelAdmin = this.th.basicUser();
        User channelUser = this.th.basicUser2();
        Channel channel = this.th.loginAs(channelAdmin).createPublicChannel();
        this.client.addChannelMember(channel.getId(), channelUser.getId());
        ApiResponse response = Assertions.assertNoError(this.client.updateChannelRoles(channel.getId(), channelUser.getId(), new Role[]{Role.CHANNEL_ADMIN, Role.CHANNEL_USER}));
        boolean result = (Boolean)response.readEntity();
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    @Disabled
    void updateChannelNotifications() {
    }

    @Test
    void viewChannel() {
        User user = this.th.basicUser();
        Channel channel = this.th.basicChannel2();
        ChannelView view = new ChannelView(channel.getId());
        ApiResponse response = Assertions.assertNoError(this.client.viewChannel(user.getId(), view));
        boolean result = ((ChannelViewResponse)response.readEntity()).isOk();
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    void getChannelMembersForUser() {
        User user = this.th.createUser();
        this.th.loginSystemAdmin().linkUserToTeam(user, this.th.basicTeam()).loginAs(user);
        Channel channel1 = this.th.createPublicChannel();
        Channel channel2 = this.th.createPublicChannel();
        this.client.addChannelMember(channel1.getId(), user.getId());
        this.client.addChannelMember(channel2.getId(), user.getId());
        ApiResponse response = Assertions.assertNoError(this.client.getChannelMembersForUser(user.getId(), this.th.basicTeam().getId(), null));
        ChannelMembers members = (ChannelMembers)response.readEntity();
        MatcherAssert.assertThat(members.stream().map(m -> m.getChannelId()).collect(Collectors.toSet()), (Matcher)CoreMatchers.hasItems((Object[])new String[]{channel1.getId(), channel2.getId()}));
    }

    @Test
    void getChannelsForUser() {
        User user = this.th.createUser();
        this.th.loginSystemAdmin().linkUserToTeam(user, this.th.basicTeam()).loginAs(user);
        Channel channel1 = this.th.createPublicChannel();
        Channel channel2 = this.th.createPublicChannel();
        this.client.addChannelMember(channel1.getId(), user.getId());
        this.client.addChannelMember(channel2.getId(), user.getId());
        ApiResponse response = Assertions.assertNoError(this.client.getChannelsForTeamForUser(this.th.basicTeam().getId(), user.getId(), null));
        ChannelList channels = (ChannelList)response.readEntity();
        MatcherAssert.assertThat(channels.stream().map(c -> c.getId()).collect(Collectors.toSet()), (Matcher)CoreMatchers.hasItems((Object[])new String[]{channel1.getId(), channel2.getId()}));
    }

    @Test
    void getUnreadMessages() {
        User user = this.th.basicUser();
        Channel channel = this.th.basicChannel();
        ApiResponse response = Assertions.assertNoError(this.client.getChannelUnread(channel.getId(), user.getId()));
        ChannelUnread unread = (ChannelUnread)response.readEntity();
        MatcherAssert.assertThat((Object)unread.getChannelId(), (Matcher)CoreMatchers.is((Object)channel.getId()));
    }

    @Test
    void getChannelHasChannelMentionsProp() {
        Channel channelPublic1 = new Channel("Public 1", "public1", ChannelType.Open, this.th.basicTeam().getId());
        ApiResponse createChannelResponse = this.client.createChannel(channelPublic1);
        if (Assertions.isNotSupportVersion("5.1.0", createChannelResponse)) {
            return;
        }
        channelPublic1 = (Channel)Assertions.assertNoError(createChannelResponse).readEntity();
        Channel channelPublic2 = new Channel("Public 2", "public2", ChannelType.Open, this.th.basicTeam().getId());
        channelPublic2 = (Channel)Assertions.assertNoError(this.client.createChannel(channelPublic2)).readEntity();
        Channel channelPrivate = new Channel("Private", "private", ChannelType.Private, this.th.basicTeam().getId());
        channelPrivate = (Channel)Assertions.assertNoError(this.client.createChannel(channelPrivate)).readEntity();
        Team otherTeam = this.th.createTeam();
        Channel channelOtherTeam = new Channel("Other Team Channel", "other-team", ChannelType.Open, otherTeam.getId());
        channelOtherTeam = (Channel)Assertions.assertNoError(this.client.createChannel(channelOtherTeam)).readEntity();
        Channel channelNoReference = this.th.createPublicChannel();
        channelNoReference.setHeader("No references");
        channelNoReference.setPurpose("No references");
        Assertions.assertNoError(this.client.updateChannel(channelNoReference));
        channelNoReference = (Channel)Assertions.assertNoError(this.client.getChannel(channelNoReference.getId())).readEntity();
        MatcherAssert.assertThat((Object)channelNoReference.getProps(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Channel channelOnBasicTeam = this.th.createPublicChannel();
        channelOnBasicTeam.setHeader("~public1, ~private, ~other-team");
        channelOnBasicTeam.setPurpose("~public2, ~private, ~other-team");
        Assertions.assertNoError(this.client.updateChannel(channelOnBasicTeam));
        channelOnBasicTeam = (Channel)Assertions.assertNoError(this.client.getChannel(channelOnBasicTeam.getId())).readEntity();
        MatcherAssert.assertThat((Object)channelOnBasicTeam.getProps().containsKey("channel_mentions"), (Matcher)CoreMatchers.is((Object)true));
        Map channelMentions = (Map)channelOnBasicTeam.getProps().get("channel_mentions");
        MatcherAssert.assertThat((Object)channelMentions.containsKey("public1"), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((String)((Map)channelMentions.get("public1")).get("display_name")), (Matcher)CoreMatchers.is((Object)channelPublic1.getDisplayName()));
    }

    @Test
    void getDeletedChannels() {
        Channel deleted1 = this.th.createPublicChannel();
        Channel deleted2 = this.th.createPublicChannel();
        this.client.deleteChannel(deleted1.getId());
        this.client.deleteChannel(deleted2.getId());
        this.th.logout().loginTeamAdmin();
        ChannelList channels = (ChannelList)Assertions.assertNoError(this.client.getDeletedChannels(this.th.basicTeam().getId())).readEntity();
        Set channelIds = channels.stream().map(Channel::getId).collect(Collectors.toSet());
        MatcherAssert.assertThat(channelIds, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{deleted1.getId(), deleted2.getId()}));
    }

    @Test
    void convertChannelToPrivate() {
        ApiResponse pingResponse = this.th.client().getPing();
        if (Assertions.isRemovedVersion("6.0.0", pingResponse)) {
            return;
        }
        Channel publicChannel = this.th.createPublicChannel();
        String channelId = publicChannel.getId();
        this.th.logout().loginTeamAdmin();
        Channel privateChannel = (Channel)Assertions.assertNoError(this.client.convertChannelToPrivate(channelId)).readEntity();
        org.junit.jupiter.api.Assertions.assertEquals((Object)channelId, (Object)privateChannel.getId());
        org.junit.jupiter.api.Assertions.assertEquals((Object)ChannelType.Private, (Object)privateChannel.getType());
    }

    @Test
    void autocompleteChannels() {
        this.th.loginTeamAdmin();
        String teamId = this.th.basicTeam().getId();
        Channel channelA = new Channel("AliceChannel_display", "acchannelalice", ChannelType.Open, teamId);
        channelA = (Channel)Assertions.assertNoError(this.client.createChannel(channelA)).readEntity();
        Channel channelB = new Channel("BobChannel_display", "acchannelbob", ChannelType.Private, teamId);
        channelB = (Channel)Assertions.assertNoError(this.client.createChannel(channelB)).readEntity();
        Channel channelC = new Channel("CharlieChannel_display", "acchannelcharlie", ChannelType.Open, teamId);
        channelC = (Channel)Assertions.assertNoError(this.client.createChannel(channelC)).readEntity();
        this.th.logout().loginBasic();
        Assertions.assertNoError(this.client.addChannelMember(channelA.getId(), this.th.basicUser().getId()));
        String term = "acchannel";
        ChannelList completeChannels = (ChannelList)Assertions.assertNoError(this.client.autocompleteChannels(teamId, term)).readEntity();
        Set ids = completeChannels.stream().map(Channel::getId).collect(Collectors.toSet());
        MatcherAssert.assertThat((Object)ids.size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat(ids, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{channelA.getId(), channelC.getId()}));
    }

    @Test
    void autocompleteChannelsForSearch() {
        this.th.loginTeamAdmin();
        String teamId = this.th.basicTeam().getId();
        Channel channelA = new Channel("AliceChannel_display", "acchannelalice", ChannelType.Open, teamId);
        channelA = (Channel)Assertions.assertNoError(this.client.createChannel(channelA)).readEntity();
        Channel channelB = new Channel("BobChannel_display", "acchannelbob", ChannelType.Private, teamId);
        channelB = (Channel)Assertions.assertNoError(this.client.createChannel(channelB)).readEntity();
        Channel channelC = new Channel("CharlieChannel_display", "acchannelcharlie", ChannelType.Open, teamId);
        channelC = (Channel)Assertions.assertNoError(this.client.createChannel(channelC)).readEntity();
        Assertions.assertNoError(this.client.addChannelMember(channelA.getId(), this.th.basicUser().getId()));
        Assertions.assertNoError(this.client.addChannelMember(channelB.getId(), this.th.basicUser().getId()));
        this.th.logout().loginBasic();
        String term = "acchannel";
        ChannelList completeChannels = (ChannelList)Assertions.assertNoError(this.client.autocompleteChannelsForSearch(teamId, term)).readEntity();
        Set ids = completeChannels.stream().map(Channel::getId).collect(Collectors.toSet());
        MatcherAssert.assertThat((Object)ids.size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat(ids, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{channelA.getId(), channelB.getId()}));
    }
}

