/*
 * Decompiled with CFR 0.152.
 */
package net.bis5.mattermost.client4.integrationtest.api;

import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import net.bis5.mattermost.client4.ApiResponse;
import net.bis5.mattermost.client4.MattermostClient;
import net.bis5.mattermost.client4.integrationtest.Assertions;
import net.bis5.mattermost.client4.integrationtest.MattermostClientTest;
import net.bis5.mattermost.client4.integrationtest.MattermostClientTestExtension;
import net.bis5.mattermost.client4.integrationtest.TestHelper;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={MattermostClientTestExtension.class})
class BrandApiTest
implements MattermostClientTest {
    private TestHelper th;
    private MattermostClient client;

    BrandApiTest() {
    }

    @Override
    public void setHelper(TestHelper helper) {
        this.th = helper;
    }

    @BeforeEach
    void setup() {
        this.client = this.createClient();
        this.th.changeClient(this.client).initBasic();
    }

    @AfterEach
    void tearDown() {
        this.th.logout();
        this.client.close();
    }

    @Test
    void getBrandImageForNotEmpty() throws URISyntaxException, IOException {
        this.th.logout().loginSystemAdmin();
        Path brandImage = this.th.getResourcePath("/noto-emoji_u1f310.png");
        ApiResponse uploadResponse = this.client.uploadBrandImage(brandImage);
        if (Assertions.isNotSupportVersion("5.0.0", uploadResponse)) {
            return;
        }
        Assertions.assertNoError(uploadResponse);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((Boolean)uploadResponse.readEntity()));
        this.th.logout().loginBasic();
        Assertions.assertNoError(this.client.getBrandImage());
    }

    @Test
    void uploadBrandImage() throws URISyntaxException, IOException {
        this.th.logout().loginSystemAdmin();
        Path brandImage = this.th.getResourcePath("/noto-emoji_u1f310.png");
        ApiResponse uploadResponse = this.client.uploadBrandImage(brandImage);
        if (Assertions.isNotSupportVersion("5.0.0", uploadResponse)) {
            return;
        }
        Assertions.assertNoError(uploadResponse);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((Boolean)uploadResponse.readEntity()));
    }

    @Test
    void deleteBrandImage() throws URISyntaxException, IOException {
        this.th.logout().loginSystemAdmin();
        Path brandImage = this.th.getResourcePath("/noto-emoji_u1f310.png");
        ApiResponse uploadResponse = this.client.uploadBrandImage(brandImage);
        if (Assertions.isNotSupportVersion("5.6.0", uploadResponse)) {
            return;
        }
        ApiResponse deleteResponse = Assertions.assertNoError(this.client.deleteBrandImage());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((Boolean)deleteResponse.readEntity()));
    }
}

