/*
 * Decompiled with CFR 0.152.
 */
package net.bis5.mattermost.client4.integrationtest.api;

import java.util.Set;
import java.util.stream.Collectors;
import net.bis5.mattermost.client4.ApiResponse;
import net.bis5.mattermost.client4.MattermostClient;
import net.bis5.mattermost.client4.integrationtest.Assertions;
import net.bis5.mattermost.client4.integrationtest.MattermostClientTest;
import net.bis5.mattermost.client4.integrationtest.MattermostClientTestExtension;
import net.bis5.mattermost.client4.integrationtest.TestHelper;
import net.bis5.mattermost.model.Bot;
import net.bis5.mattermost.model.BotPatch;
import net.bis5.mattermost.model.Bots;
import net.bis5.mattermost.model.Config;
import net.bis5.mattermost.model.User;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={MattermostClientTestExtension.class})
class BotsApiTest
implements MattermostClientTest {
    private TestHelper th;
    private MattermostClient client;

    BotsApiTest() {
    }

    @Override
    public void setHelper(TestHelper helper) {
        this.th = helper;
    }

    @BeforeEach
    void setup() {
        this.client = this.createClient();
        this.th.changeClient(this.client).initBasic();
    }

    @AfterEach
    void tearDown() {
        this.th.logout();
        this.client.close();
    }

    @Test
    void createBot() {
        this.th.logout().loginSystemAdmin();
        ApiResponse configResponse = this.client.getConfig();
        if (Assertions.isNotSupportVersion("5.10.0", configResponse)) {
            return;
        }
        Config config = (Config)configResponse.readEntity();
        config.getServiceSettings().setEnableBotAccountCreation(true);
        Assertions.assertNoError(this.client.updateConfig(config));
        BotPatch bot = new BotPatch();
        bot.setUsername("bot_" + this.th.newId());
        bot.setDisplayName("botsApiTestName");
        bot.setDescription("Bot account for @" + bot.getUsername());
        ApiResponse response = Assertions.assertNoError(this.client.createBot(bot));
        Bot createdBot = (Bot)response.readEntity();
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.th.systemAdminUser().getId(), (Object)createdBot.getOwnerId());
        org.junit.jupiter.api.Assertions.assertEquals((Object)bot.getUsername(), (Object)createdBot.getUsername());
        org.junit.jupiter.api.Assertions.assertEquals((Object)bot.getDisplayName(), (Object)createdBot.getDisplayName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)bot.getDescription(), (Object)createdBot.getDescription());
    }

    @Test
    void patchBot() {
        this.th.logout().loginSystemAdmin();
        ApiResponse configResponse = this.client.getConfig();
        if (Assertions.isNotSupportVersion("5.10.0", configResponse)) {
            return;
        }
        Config config = (Config)configResponse.readEntity();
        config.getServiceSettings().setEnableBotAccountCreation(true);
        Assertions.assertNoError(this.client.updateConfig(config));
        BotPatch patch = new BotPatch();
        patch.setUsername("bot_" + this.th.newId());
        patch.setDisplayName("botsApiTestName");
        patch.setDescription("Bot account for @" + patch.getUsername());
        Bot originalBot = (Bot)Assertions.assertNoError(this.client.createBot(patch)).readEntity();
        patch.setUsername("up_" + this.th.newId());
        patch.setDisplayName("up_" + patch.getDisplayName());
        patch.setDescription("up_" + patch.getDescription());
        ApiResponse response = Assertions.assertNoError(this.client.patchBot(originalBot.getUserId(), patch));
        Bot patchedBot = (Bot)response.readEntity();
        org.junit.jupiter.api.Assertions.assertEquals((Object)patch.getUsername(), (Object)patchedBot.getUsername());
        org.junit.jupiter.api.Assertions.assertEquals((Object)patch.getDisplayName(), (Object)patchedBot.getDisplayName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)patch.getDescription(), (Object)patchedBot.getDescription());
    }

    @Test
    void getBot() {
        this.th.logout().loginSystemAdmin();
        ApiResponse configResponse = this.client.getConfig();
        if (Assertions.isNotSupportVersion("5.10.0", configResponse)) {
            return;
        }
        Config config = (Config)configResponse.readEntity();
        config.getServiceSettings().setEnableBotAccountCreation(true);
        Assertions.assertNoError(this.client.updateConfig(config));
        BotPatch patch = new BotPatch();
        patch.setUsername("bot_" + this.th.newId());
        patch.setDisplayName("botsApiTestName");
        patch.setDescription("Bot account for @" + patch.getUsername());
        Bot originalBot = (Bot)Assertions.assertNoError(this.client.createBot(patch)).readEntity();
        ApiResponse response = Assertions.assertNoError(this.client.getBot(originalBot.getUserId()));
        Bot receiveddBot = (Bot)response.readEntity();
        org.junit.jupiter.api.Assertions.assertEquals((Object)originalBot.getUsername(), (Object)receiveddBot.getUsername());
        org.junit.jupiter.api.Assertions.assertEquals((Object)originalBot.getDisplayName(), (Object)receiveddBot.getDisplayName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)originalBot.getDescription(), (Object)receiveddBot.getDescription());
    }

    @Test
    void getBots() {
        this.th.logout().loginSystemAdmin();
        ApiResponse configResponse = this.client.getConfig();
        if (Assertions.isNotSupportVersion("5.10.0", configResponse)) {
            return;
        }
        Config config = (Config)configResponse.readEntity();
        config.getServiceSettings().setEnableBotAccountCreation(true);
        Assertions.assertNoError(this.client.updateConfig(config));
        BotPatch patch = new BotPatch();
        patch.setUsername("bot1_" + this.th.newId());
        patch.setDisplayName("botsApiTestName1");
        patch.setDescription("Bot account for @" + patch.getUsername());
        Bot originalBot1 = (Bot)Assertions.assertNoError(this.client.createBot(patch)).readEntity();
        patch = new BotPatch();
        patch.setUsername("bot2_" + this.th.newId());
        patch.setDisplayName("botsApiTestName2");
        patch.setDescription("Bot account for @" + patch.getUsername());
        Bot originalBot2 = (Bot)Assertions.assertNoError(this.client.createBot(patch)).readEntity();
        Bots bots = (Bots)Assertions.assertNoError(this.client.getBots()).readEntity();
        Set botUserIds = bots.stream().map(Bot::getUserId).collect(Collectors.toSet());
        MatcherAssert.assertThat(botUserIds, (Matcher)CoreMatchers.hasItems((Object[])new String[]{originalBot1.getUserId(), originalBot2.getUserId()}));
    }

    @Test
    void disableBot() {
        this.th.logout().loginSystemAdmin();
        ApiResponse configResponse = this.client.getConfig();
        if (Assertions.isNotSupportVersion("5.10.0", configResponse)) {
            return;
        }
        Config config = (Config)configResponse.readEntity();
        config.getServiceSettings().setEnableBotAccountCreation(true);
        Assertions.assertNoError(this.client.updateConfig(config));
        BotPatch patch = new BotPatch();
        patch.setUsername("bot_" + this.th.newId());
        patch.setDisplayName("botsApiTestName");
        patch.setDescription("Bot account for @" + patch.getUsername());
        Bot originalBot = (Bot)Assertions.assertNoError(this.client.createBot(patch)).readEntity();
        ApiResponse response = Assertions.assertNoError(this.client.disableBot(originalBot.getUserId()));
        org.junit.jupiter.api.Assertions.assertTrue((((Bot)response.readEntity()).getDeleteAt() != 0L ? 1 : 0) != 0);
    }

    @Test
    void enableBot() {
        this.th.logout().loginSystemAdmin();
        ApiResponse configResponse = this.client.getConfig();
        if (Assertions.isNotSupportVersion("5.10.0", configResponse)) {
            return;
        }
        Config config = (Config)configResponse.readEntity();
        config.getServiceSettings().setEnableBotAccountCreation(true);
        Assertions.assertNoError(this.client.updateConfig(config));
        BotPatch patch = new BotPatch();
        patch.setUsername("bot_" + this.th.newId());
        patch.setDisplayName("botsApiTestName");
        patch.setDescription("Bot account for @" + patch.getUsername());
        Bot originalBot = (Bot)Assertions.assertNoError(this.client.createBot(patch)).readEntity();
        ApiResponse response = Assertions.assertNoError(this.client.disableBot(originalBot.getUserId()));
        org.junit.jupiter.api.Assertions.assertTrue((((Bot)response.readEntity()).getDeleteAt() != 0L ? 1 : 0) != 0);
        response = Assertions.assertNoError(this.client.enableBot(originalBot.getUserId()));
        org.junit.jupiter.api.Assertions.assertTrue((((Bot)response.readEntity()).getDeleteAt() == 0L ? 1 : 0) != 0);
    }

    @Test
    void assignBotToUser() {
        this.th.logout().loginSystemAdmin();
        ApiResponse configResponse = this.client.getConfig();
        if (Assertions.isNotSupportVersion("5.10.0", configResponse)) {
            return;
        }
        Config config = (Config)configResponse.readEntity();
        config.getServiceSettings().setEnableBotAccountCreation(true);
        Assertions.assertNoError(this.client.updateConfig(config));
        BotPatch patch = new BotPatch();
        patch.setUsername("bot_" + this.th.newId());
        patch.setDisplayName("botsApiTestName");
        patch.setDescription("Bot account for @" + patch.getUsername());
        Bot originalBot = (Bot)Assertions.assertNoError(this.client.createBot(patch)).readEntity();
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.th.systemAdminUser().getId(), (Object)originalBot.getOwnerId());
        User secondSysAdmin = this.th.createSystemAdminUser();
        ApiResponse response = Assertions.assertNoError(this.client.assignBotToUser(originalBot.getUserId(), secondSysAdmin.getId()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)secondSysAdmin.getId(), (Object)((Bot)response.readEntity()).getOwnerId());
    }
}

