/*
 * Decompiled with CFR 0.152.
 */
package net.bis5.mattermost.client4.integrationtest;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URISyntaxException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.bis5.mattermost.client4.MattermostClient;
import net.bis5.mattermost.client4.integrationtest.Assertions;
import net.bis5.mattermost.model.Channel;
import net.bis5.mattermost.model.ChannelType;
import net.bis5.mattermost.model.Config;
import net.bis5.mattermost.model.Post;
import net.bis5.mattermost.model.Role;
import net.bis5.mattermost.model.Team;
import net.bis5.mattermost.model.TeamType;
import net.bis5.mattermost.model.User;
import org.apache.commons.lang3.RandomStringUtils;

public class TestHelper {
    private MattermostClient client;
    private Path tmpDir;
    private User systemAdminUser;
    private User teamAdminUser;
    private Team basicTeam;
    private Channel basicChannel;
    private Channel basicPrivateChannel;
    private Channel basicChannel2;
    private Post basicPost;
    private User basicUser;
    private User basicUser2;
    public static final String DEFAULT_PASSWORD = "The_Passw0rd";
    public static final String EMOJI_GLOBE = "/noto-emoji_u1f310.png";
    public static final String EMOJI_CONSTRUCTION = "/noto-emoji_u1f6a7.png";

    public TestHelper(MattermostClient client) {
        this.client = client;
    }

    public TestHelper changeClient(MattermostClient client) {
        this.client = client;
        return this;
    }

    private Path ensureTempDir() {
        if (this.tmpDir == null) {
            try {
                this.tmpDir = Files.createTempDirectory(TestHelper.class.getSimpleName(), PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rwxrwxrwx")));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return this.tmpDir;
    }

    public void clearTempFiles() throws IOException {
        if (this.tmpDir == null) {
            return;
        }
        Files.walkFileTree(this.tmpDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException ioe) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }
        });
        this.tmpDir = null;
    }

    public Path getResourcePath(String name) throws URISyntaxException, IOException {
        Path extracted = this.ensureTempDir().resolve(name.replace("/", ""));
        Files.createFile(extracted, new FileAttribute[0]);
        Files.copy(this.getClass().getResourceAsStream(name), extracted, StandardCopyOption.REPLACE_EXISTING);
        return extracted;
    }

    public TestHelper setup() {
        this.initSystemAdmin();
        Config config = (Config)this.client.getConfig().readEntity();
        config.getTeamSettings().setMaxUsersPerTeam(50);
        config.getRateLimitSettings().setEnable(false);
        config.getServiceSettings().setEnableCustomEmoji(true);
        config.getServiceSettings().setEnableOnlyAdminIntegrations(false);
        config.getServiceSettings().setEnableIncomingWebhooks(true);
        config.getServiceSettings().setEnableOutgoingWebhooks(true);
        config.getServiceSettings().setEnableCommands(true);
        config.getServiceSettings().setEnableEmailInvitations(true);
        config.getServiceSettings().setEnableUserAccessTokens(true);
        config.getServiceSettings().setEnableLinkPreviews(true);
        config.getServiceSettings().setEnablePostIconOverride(true);
        config.getFileSettings().setEnablePublicLink(true);
        config.getTeamSettings().setEnableOpenServer(true);
        config = (Config)Assertions.checkNoError(this.client.updateConfig(config)).readEntity();
        this.client.logout();
        return this;
    }

    public TestHelper initBasic() {
        this.teamAdminUser = this.createUser();
        this.loginTeamAdmin();
        this.basicTeam = this.createTeam();
        this.basicChannel = this.createPublicChannel();
        this.basicPrivateChannel = this.createPrivateChannel();
        this.basicChannel2 = this.createPublicChannel();
        this.basicPost = this.createPost(this.basicChannel);
        this.basicUser = this.createUser();
        this.linkUserToTeam(this.basicUser, this.basicTeam);
        this.basicUser2 = this.createUser();
        this.linkUserToTeam(this.basicUser2, this.basicTeam);
        Assertions.checkNoError(this.client.addChannelMember(this.basicChannel.getId(), this.basicUser.getId()));
        Assertions.checkNoError(this.client.addChannelMember(this.basicChannel.getId(), this.basicUser2.getId()));
        Assertions.checkNoError(this.client.addChannelMember(this.basicChannel2.getId(), this.basicUser.getId()));
        Assertions.checkNoError(this.client.addChannelMember(this.basicChannel2.getId(), this.basicUser2.getId()));
        Assertions.checkNoError(this.client.addChannelMember(this.basicPrivateChannel.getId(), this.basicUser.getId()));
        Assertions.checkNoError(this.client.addChannelMember(this.basicPrivateChannel.getId(), this.basicUser2.getId()));
        this.loginBasic();
        return this;
    }

    public TestHelper initSystemAdmin() {
        if (this.systemAdminUser != null) {
            this.loginAs(this.systemAdminUser);
            return this;
        }
        this.systemAdminUser = this.createSystemAdminUser();
        this.loginAs(this.systemAdminUser);
        return this;
    }

    public String newId() {
        return this.newRandomString(26);
    }

    public User createSystemAdminUser() {
        String id = this.newId();
        User user = new User();
        user.setEmail(this.generateTestEmail());
        user.setUsername(this.generateTestUsername());
        user.setNickname("nn_" + id);
        user.setFirstName("f_" + id);
        user.setLastName("l_" + id);
        user.setPassword(DEFAULT_PASSWORD);
        user.setRoles(Arrays.asList(Role.SYSTEM_ADMIN, Role.SYSTEM_USER).stream().map(Role::getRoleName).collect(Collectors.joining(" ")));
        user = (User)Assertions.checkNoError(this.client.createUser(user)).readEntity();
        user.setPassword(DEFAULT_PASSWORD);
        return user;
    }

    public User createUser(String username) {
        String id = this.newId();
        User user = new User();
        user.setEmail(this.generateTestEmail());
        user.setUsername(username);
        user.setNickname("nn_" + id);
        user.setFirstName("f_" + id);
        user.setLastName("l_" + id);
        user.setPassword(DEFAULT_PASSWORD);
        user = (User)Assertions.checkNoError(this.client.createUser(user)).readEntity();
        user.setPassword(DEFAULT_PASSWORD);
        return user;
    }

    public User createUser() {
        return this.createUser(this.generateTestUsername());
    }

    public Team createTeam() {
        String id = this.newId();
        Team team = new Team();
        team.setDisplayName("dn_" + id);
        team.setName(this.generateTestTeamName());
        team.setDescription("desc_" + id);
        team.setType(TeamType.OPEN);
        team.setAllowOpenInvite(true);
        team = (Team)Assertions.checkNoError(this.client.createTeam(team)).readEntity();
        return team;
    }

    public Channel createPublicChannel() {
        return this.createChannel(ChannelType.Open);
    }

    public Channel createPrivateChannel() {
        return this.createChannel(ChannelType.Private);
    }

    protected Channel createChannel(ChannelType type) {
        String id = this.newId();
        Channel channel = new Channel();
        channel.setDisplayName("dn_" + id);
        channel.setName(this.generateTestChannelName());
        channel.setType(type);
        channel.setTeamId(this.basicTeam.getId());
        channel = (Channel)Assertions.checkNoError(this.client.createChannel(channel)).readEntity();
        return channel;
    }

    public Post createPost(Channel channel) {
        String id = this.newId();
        Post post = new Post();
        post.setChannelId(channel.getId());
        post.setMessage("message_" + id);
        post = (Post)Assertions.checkNoError(this.client.createPost(post)).readEntity();
        return post;
    }

    public Post createPinnedPost(String channelId) {
        String id = this.newId();
        Post post = new Post();
        post.setChannelId(channelId);
        post.setMessage("message_" + id);
        post.setPinned(true);
        post = (Post)Assertions.checkNoError(this.client.createPost(post)).readEntity();
        return post;
    }

    public String generateTestEmail() {
        return "success+" + this.newId() + "@inbucket.local".toLowerCase();
    }

    public String generateTestUsername() {
        return "fakeuser" + this.newRandomString(10);
    }

    public String generateTestTeamName() {
        return "faketeam" + this.newRandomString(10);
    }

    public String generateTestChannelName() {
        return "fakechannel" + this.newRandomString(10);
    }

    public String newRandomString(int length) {
        return RandomStringUtils.randomAlphanumeric((int)length).toLowerCase();
    }

    public TestHelper loginTeamAdmin() {
        this.loginAs(this.teamAdminUser);
        return this;
    }

    public TestHelper loginBasic() {
        this.loginAs(this.basicUser);
        return this;
    }

    public TestHelper loginBasic2() {
        this.loginAs(this.basicUser2);
        return this;
    }

    public TestHelper loginSystemAdmin() {
        this.loginAs(this.systemAdminUser);
        return this;
    }

    public TestHelper logout() {
        this.client.logout();
        return this;
    }

    public TestHelper loginAs(User user) {
        this.client.login(user.getEmail(), user.getPassword());
        return this;
    }

    public TestHelper linkUserToTeam(User user, Team team) {
        Assertions.checkNoError(this.client.addTeamMembers(team.getId(), new String[]{user.getId()}));
        return this;
    }

    public TestHelper updateUserRoles(String userId, Role ... roles) {
        Assertions.checkNoError(this.client.updateUserRoles(userId, roles));
        return this;
    }

    public TestHelper updateUserToNonTeamAdmin(User user, Team team) {
        Assertions.checkNoError(this.client.updateTeamMemberRoles(team.getId(), user.getId(), new Role[]{Role.TEAM_USER}));
        return this;
    }

    public MattermostClient client() {
        return this.client;
    }

    public Path tmpDir() {
        return this.tmpDir;
    }

    public User systemAdminUser() {
        return this.systemAdminUser;
    }

    public User teamAdminUser() {
        return this.teamAdminUser;
    }

    public Team basicTeam() {
        return this.basicTeam;
    }

    public Channel basicChannel() {
        return this.basicChannel;
    }

    public Channel basicPrivateChannel() {
        return this.basicPrivateChannel;
    }

    public Channel basicChannel2() {
        return this.basicChannel2;
    }

    public Post basicPost() {
        return this.basicPost;
    }

    public User basicUser() {
        return this.basicUser;
    }

    public User basicUser2() {
        return this.basicUser2;
    }
}

