/*
 * Decompiled with CFR 0.152.
 */
package net.bis5.mattermost.client4.integrationtest;

import com.vdurmont.semver4j.Semver;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.EnumSet;
import net.bis5.mattermost.client4.ApiResponse;
import net.bis5.mattermost.client4.model.ApiError;
import org.apache.commons.codec.digest.DigestUtils;
import org.hamcrest.BaseMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;

public class Assertions {
    public static void assertSameFile(Path expected, Path actual) throws IOException {
        String expectedHash = DigestUtils.sha1Hex((byte[])Files.readAllBytes(expected));
        String actualHash = DigestUtils.sha1Hex((byte[])Files.readAllBytes(actual));
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedHash, (Object)actualHash);
    }

    public static <T> ApiResponse<T> assertNoError(ApiResponse<T> response) {
        return Assertions.checkNoError(response);
    }

    public static <T> ApiResponse<T> assertStatus(ApiResponse<T> response, Response.Status status) {
        Response rawResponse = response.getRawResponse();
        MatcherAssert.assertThat((Object)rawResponse.getStatus(), (Matcher)CoreMatchers.is((Object)status.getStatusCode()));
        return response;
    }

    public static boolean isNotSupportVersion(String minimumRequirement, ApiResponse<?> response) {
        Semver requirement;
        Semver serverVersion = new Semver(response.getRawResponse().getHeaderString("X-Version-Id")).withClearedSuffix();
        return serverVersion.compareTo(requirement = new Semver(minimumRequirement)) < 0;
    }

    public static boolean isSupportVersion(String minimumRequirement, ApiResponse<?> response) {
        return !Assertions.isNotSupportVersion(minimumRequirement, response);
    }

    public static boolean isRemovedVersion(String removedVersion, ApiResponse<?> response) {
        Semver removed;
        Semver serverVersion = new Semver(response.getRawResponse().getHeaderString("X-Version-Id")).withClearedSuffix();
        return serverVersion.compareTo(removed = new Semver(removedVersion)) >= 0;
    }

    public static boolean isMajorMinorVersionMatches(String majorMinorVersion, ApiResponse<?> response) {
        Semver serverVersion = new Semver(response.getRawResponse().getHeaderString("X-Version-Id"));
        Semver majorMinorSemver = new Semver(majorMinorVersion, Semver.SemverType.LOOSE);
        return !EnumSet.of(Semver.VersionDiff.MAJOR, Semver.VersionDiff.MINOR).contains(majorMinorSemver.diff(serverVersion));
    }

    public static <T> ApiResponse<T> checkNoError(ApiResponse<T> response) {
        response.getRawResponse().bufferEntity();
        try {
            ApiError error = response.readError();
            Response.Status.Family responseStatus = Response.Status.Family.familyOf((int)error.getStatusCode());
            if (responseStatus == Response.Status.Family.CLIENT_ERROR || responseStatus == Response.Status.Family.SERVER_ERROR) {
                throw new AssertionError((Object)("Expected no error, got " + error));
            }
        }
        catch (ProcessingException processingException) {
            // empty catch block
        }
        return response;
    }

    public static class HasError<T extends ApiResponse<U>, U>
    extends BaseMatcher<T> {
        private ApiResponse<U> actual;

        public boolean matches(Object actual) {
            if (actual instanceof ApiResponse) {
                this.actual = (ApiResponse)actual;
                return this.actual.hasError();
            }
            return false;
        }

        public void describeTo(Description description) {
            description.appendText("Should have failed");
        }

        public static <U> Matcher<? extends ApiResponse<U>> hasError() {
            return new HasError();
        }
    }
}

