/*
 * Decompiled with CFR 0.152.
 */
package net.bis5.mattermost.client4.integrationtest;

import fi.iki.elonen.NanoHTTPD;
import java.io.IOException;
import java.net.ServerSocket;
import net.bis5.mattermost.client4.MattermostClient;
import net.bis5.mattermost.client4.hook.IncomingWebhookClient;
import net.bis5.mattermost.model.IncomingWebhookRequest;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ApiResponseTest {
    private MattermostClient client;
    private NanoHTTPD dummyServer;
    private int listenPort;

    ApiResponseTest() {
    }

    private String getApplicationUrl() {
        return "http://localhost:" + this.listenPort;
    }

    @BeforeEach
    void setup() throws IOException {
        try (ServerSocket socket = new ServerSocket(0);){
            this.listenPort = socket.getLocalPort();
        }
        this.client = new MattermostClient(this.getApplicationUrl());
    }

    private NanoHTTPD createFixedResponseHttpd(int listenPort, final String contentType, final String body) {
        return new NanoHTTPD("0.0.0.0", listenPort){

            public NanoHTTPD.Response serve(NanoHTTPD.IHTTPSession session) {
                return 1.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)contentType, (String)body);
            }
        };
    }

    @AfterEach
    void tearDown() {
        this.client.close();
        if (this.dummyServer != null) {
            this.dummyServer.closeAllConnections();
            this.dummyServer = null;
        }
    }

    @Test
    void testCheckStatusOkForTextPlainFormatWithCharset() throws IOException {
        this.dummyServer = this.createFixedResponseHttpd(this.listenPort, "text/plain; charset=UTF-8", "ok");
        this.dummyServer.start();
        IncomingWebhookClient client = new IncomingWebhookClient("http://localhost:" + this.listenPort + "/hook/foobar");
        IncomingWebhookRequest payload = new IncomingWebhookRequest();
        payload.setText("Hello World");
        Assertions.assertDoesNotThrow(() -> client.postByIncomingWebhook(payload));
    }

    @Test
    void testCheckStatusOkForTextPlainFormat() throws IOException {
        this.dummyServer = this.createFixedResponseHttpd(this.listenPort, "text/plain", "ok");
        this.dummyServer.start();
        IncomingWebhookClient client = new IncomingWebhookClient("http://localhost:" + this.listenPort + "/hook/foobar");
        IncomingWebhookRequest payload = new IncomingWebhookRequest();
        payload.setText("Hello World");
        Assertions.assertDoesNotThrow(() -> client.postByIncomingWebhook(payload));
    }

    @Test
    void testCheckStatusOkForJsonFormatWithCharset() throws IOException {
        this.dummyServer = this.createFixedResponseHttpd(this.listenPort, "application/json; charset=UTF-8", "{\"status\":\"ok\"}");
        this.dummyServer.start();
        Assertions.assertDoesNotThrow(() -> this.client.logout());
    }

    @Test
    void testCheckStatusOkForJsonFormat() throws IOException {
        this.dummyServer = this.createFixedResponseHttpd(this.listenPort, "application/json", "{\"status\":\"ok\"}");
        this.dummyServer.start();
        Assertions.assertDoesNotThrow(() -> this.client.logout());
    }
}

