/*
 * Decompiled with CFR 0.152.
 */
package net.bis5.mattermost.client4.api;

import java.sql.Date;
import java.time.OffsetDateTime;
import net.bis5.mattermost.client4.ApiResponse;
import net.bis5.mattermost.client4.Pager;
import net.bis5.mattermost.model.Post;
import net.bis5.mattermost.model.PostList;
import net.bis5.mattermost.model.PostPatch;
import net.bis5.mattermost.model.PostSearchResults;

public interface PostApi {
    public ApiResponse<Post> createPost(Post var1);

    default public ApiResponse<Post> updatePost(Post post) {
        return this.updatePost(post.getId(), post);
    }

    public ApiResponse<Post> updatePost(String var1, Post var2);

    public ApiResponse<Post> patchPost(String var1, PostPatch var2);

    public ApiResponse<Boolean> pinPost(String var1);

    public ApiResponse<Boolean> unpinPost(String var1);

    default public ApiResponse<Post> getPost(String postId) {
        return this.getPost(postId, null);
    }

    public ApiResponse<Post> getPost(String var1, String var2);

    public ApiResponse<Boolean> deletePost(String var1);

    default public ApiResponse<PostList> getPostThread(String postId) {
        return this.getPostThread(postId, null);
    }

    public ApiResponse<PostList> getPostThread(String var1, String var2);

    default public ApiResponse<PostList> getPostsForChannel(String channelId) {
        return this.getPostsForChannel(channelId, Pager.defaultPager());
    }

    default public ApiResponse<PostList> getPostsForChannel(String channelId, Pager pager) {
        return this.getPostsForChannel(channelId, pager, null);
    }

    public ApiResponse<PostList> getPostsForChannel(String var1, Pager var2, String var3);

    default public ApiResponse<PostList> getFlaggedPostsForUser(String userId) {
        return this.getFlaggedPostsForUser(userId, Pager.defaultPager());
    }

    public ApiResponse<PostList> getFlaggedPostsForUser(String var1, Pager var2);

    default public ApiResponse<PostList> getFlaggedPostsForUserInTeam(String userId, String teamId) {
        return this.getFlaggedPostsForUserInTeam(userId, teamId, Pager.defaultPager());
    }

    public ApiResponse<PostList> getFlaggedPostsForUserInTeam(String var1, String var2, Pager var3);

    default public ApiResponse<PostList> getFlaggedPostsForUserInChannel(String userId, String channelId) {
        return this.getFlaggedPostsForUserInChannel(userId, channelId, Pager.defaultPager());
    }

    public ApiResponse<PostList> getFlaggedPostsForUserInChannel(String var1, String var2, Pager var3);

    default public ApiResponse<PostList> getPostsSince(String channelId, Date since) {
        return this.getPostsSince(channelId, since.getTime());
    }

    default public ApiResponse<PostList> getPostsSince(String channelId, OffsetDateTime since) {
        return this.getPostsSince(channelId, since.toEpochSecond());
    }

    public ApiResponse<PostList> getPostsSince(String var1, long var2);

    default public ApiResponse<PostList> getPostsAfter(String channelId, String postId) {
        return this.getPostsAfter(channelId, postId, Pager.defaultPager());
    }

    default public ApiResponse<PostList> getPostsAfter(String channelId, String postId, Pager pager) {
        return this.getPostsAfter(channelId, postId, pager, null);
    }

    public ApiResponse<PostList> getPostsAfter(String var1, String var2, Pager var3, String var4);

    default public ApiResponse<PostList> getPostsBefore(String channelId, String postId) {
        return this.getPostsBefore(channelId, postId, Pager.defaultPager());
    }

    default public ApiResponse<PostList> getPostsBefore(String channelId, String postId, Pager pager) {
        return this.getPostsBefore(channelId, postId, pager, null);
    }

    public ApiResponse<PostList> getPostsBefore(String var1, String var2, Pager var3, String var4);

    default public ApiResponse<PostSearchResults> searchPosts(String teamId, String terms) {
        return this.searchPosts(teamId, terms, false);
    }

    public ApiResponse<PostSearchResults> searchPosts(String var1, String var2, boolean var3);
}

