/*
 * Decompiled with CFR 0.152.
 */
package net.bis5.mattermost.client4;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class QueryBuilder {
    private static final String PREFIX = "?";
    private static final String DELIMITER = "&";
    private static final String EQUALS = "=";
    private final Map<String, String> parameters = new HashMap<String, String>();

    public QueryBuilder set(String key, String value) {
        if (StringUtils.isEmpty((CharSequence)key)) {
            throw new IllegalArgumentException("key");
        }
        this.parameters.put(key, StringUtils.stripToEmpty((String)value));
        return this;
    }

    public QueryBuilder set(String key, int value) {
        return this.set(key, String.valueOf(value));
    }

    public QueryBuilder set(String key, boolean value) {
        return this.set(key, Boolean.toString(value));
    }

    @Deprecated
    public QueryBuilder append(String key, String value) {
        return this.set(key, value);
    }

    @Deprecated
    public QueryBuilder append(String key, int value) {
        return this.append(key, String.valueOf(value));
    }

    @Deprecated
    public QueryBuilder append(String key, boolean value) {
        return this.append(key, Boolean.toString(value));
    }

    public String toString() {
        return this.parameters.entrySet().stream().map(e -> (String)e.getKey() + EQUALS + (String)e.getValue()).collect(Collectors.joining(DELIMITER, PREFIX, ""));
    }
}

