/*
 * Decompiled with CFR 0.152.
 */
package net.bis5.mattermost.client4;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import net.bis5.mattermost.client4.ApiResponse;
import net.bis5.mattermost.client4.AuthType;
import net.bis5.mattermost.client4.Pager;
import net.bis5.mattermost.client4.QueryBuilder;
import net.bis5.mattermost.client4.api.AuditsApi;
import net.bis5.mattermost.client4.api.AuthenticationApi;
import net.bis5.mattermost.client4.api.BrandApi;
import net.bis5.mattermost.client4.api.ChannelApi;
import net.bis5.mattermost.client4.api.ClusterApi;
import net.bis5.mattermost.client4.api.CommandsApi;
import net.bis5.mattermost.client4.api.ComplianceApi;
import net.bis5.mattermost.client4.api.EmojiApi;
import net.bis5.mattermost.client4.api.GeneralApi;
import net.bis5.mattermost.client4.api.LdapApi;
import net.bis5.mattermost.client4.api.LogsApi;
import net.bis5.mattermost.client4.api.OAuthApi;
import net.bis5.mattermost.client4.api.PostApi;
import net.bis5.mattermost.client4.api.PreferencesApi;
import net.bis5.mattermost.client4.api.ReactionApi;
import net.bis5.mattermost.client4.api.SamlApi;
import net.bis5.mattermost.client4.api.StatusApi;
import net.bis5.mattermost.client4.api.TeamApi;
import net.bis5.mattermost.client4.api.UserApi;
import net.bis5.mattermost.client4.api.WebhookApi;
import net.bis5.mattermost.client4.api.WebrtcApi;
import net.bis5.mattermost.client4.model.AddChannelMemberRequest;
import net.bis5.mattermost.client4.model.AnalyticsCategory;
import net.bis5.mattermost.client4.model.AttachDeviceIdRequest;
import net.bis5.mattermost.client4.model.CheckUserMfaRequest;
import net.bis5.mattermost.client4.model.DeauthorizeOAuthAppRequest;
import net.bis5.mattermost.client4.model.LoginRequest;
import net.bis5.mattermost.client4.model.ResetPasswordRequest;
import net.bis5.mattermost.client4.model.RevokeSessionRequest;
import net.bis5.mattermost.client4.model.SearchPostsRequest;
import net.bis5.mattermost.client4.model.SendPasswordResetEmailRequest;
import net.bis5.mattermost.client4.model.SendVerificationEmailRequest;
import net.bis5.mattermost.client4.model.SwitchAccountTypeResult;
import net.bis5.mattermost.client4.model.UpdateRolesRequest;
import net.bis5.mattermost.client4.model.UpdateUserActiveRequest;
import net.bis5.mattermost.client4.model.UpdateUserMfaRequest;
import net.bis5.mattermost.client4.model.UpdateUserPasswordRequest;
import net.bis5.mattermost.client4.model.VerifyUserEmailRequest;
import net.bis5.mattermost.jersey.provider.MattermostModelMapperProvider;
import net.bis5.mattermost.model.AnalyticsRows;
import net.bis5.mattermost.model.Audits;
import net.bis5.mattermost.model.AuthorizeRequest;
import net.bis5.mattermost.model.Channel;
import net.bis5.mattermost.model.ChannelList;
import net.bis5.mattermost.model.ChannelMember;
import net.bis5.mattermost.model.ChannelMembers;
import net.bis5.mattermost.model.ChannelPatch;
import net.bis5.mattermost.model.ChannelSearch;
import net.bis5.mattermost.model.ChannelStats;
import net.bis5.mattermost.model.ChannelUnread;
import net.bis5.mattermost.model.ChannelView;
import net.bis5.mattermost.model.ChannelViewResponse;
import net.bis5.mattermost.model.ClusterInfo;
import net.bis5.mattermost.model.Command;
import net.bis5.mattermost.model.CommandArgs;
import net.bis5.mattermost.model.CommandList;
import net.bis5.mattermost.model.CommandResponse;
import net.bis5.mattermost.model.Compliance;
import net.bis5.mattermost.model.Compliances;
import net.bis5.mattermost.model.Config;
import net.bis5.mattermost.model.Emoji;
import net.bis5.mattermost.model.EmojiList;
import net.bis5.mattermost.model.IncomingWebhook;
import net.bis5.mattermost.model.IncomingWebhookList;
import net.bis5.mattermost.model.OAuthApp;
import net.bis5.mattermost.model.OutgoingWebhook;
import net.bis5.mattermost.model.OutgoingWebhookList;
import net.bis5.mattermost.model.Post;
import net.bis5.mattermost.model.PostList;
import net.bis5.mattermost.model.PostPatch;
import net.bis5.mattermost.model.Preference;
import net.bis5.mattermost.model.PreferenceCategory;
import net.bis5.mattermost.model.Preferences;
import net.bis5.mattermost.model.Reaction;
import net.bis5.mattermost.model.Role;
import net.bis5.mattermost.model.SamlCertificateStatus;
import net.bis5.mattermost.model.SessionList;
import net.bis5.mattermost.model.Status;
import net.bis5.mattermost.model.SwitchRequest;
import net.bis5.mattermost.model.Team;
import net.bis5.mattermost.model.TeamExists;
import net.bis5.mattermost.model.TeamList;
import net.bis5.mattermost.model.TeamMember;
import net.bis5.mattermost.model.TeamMemberList;
import net.bis5.mattermost.model.TeamPatch;
import net.bis5.mattermost.model.TeamSearch;
import net.bis5.mattermost.model.TeamStats;
import net.bis5.mattermost.model.TeamUnread;
import net.bis5.mattermost.model.TeamUnreadList;
import net.bis5.mattermost.model.User;
import net.bis5.mattermost.model.UserAutocomplete;
import net.bis5.mattermost.model.UserList;
import net.bis5.mattermost.model.UserPatch;
import net.bis5.mattermost.model.UserSearch;
import net.bis5.mattermost.model.WebrtcInfoResponse;
import net.bis5.mattermost.model.license.MfaSecret;
import org.apache.commons.lang3.StringUtils;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.logging.LoggingFeature;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.MultiPart;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.media.multipart.file.FileDataBodyPart;

public class MattermostClient
implements AutoCloseable,
AuditsApi,
AuthenticationApi,
BrandApi,
ChannelApi,
ClusterApi,
CommandsApi,
ComplianceApi,
EmojiApi,
GeneralApi,
LdapApi,
LogsApi,
OAuthApi,
PostApi,
PreferencesApi,
ReactionApi,
SamlApi,
StatusApi,
TeamApi,
UserApi,
WebhookApi,
WebrtcApi {
    protected static final String API_URL_SUFFIX = "/api/v4";
    private final String url;
    private final String apiUrl;
    private String authToken;
    private AuthType authType;
    private final Level clientLogLevel;
    private final Client httpClient;
    protected static final String HEADER_ETAG_CLIENT = "If-None-Match";
    protected static final String HEADER_AUTH = "Authorization";
    private static final String HEADER_TOKEN = "token";
    private static final String ME = "me";

    protected Client buildClient() {
        ClientBuilder builder = (ClientBuilder)((ClientBuilder)((ClientBuilder)((ClientBuilder)ClientBuilder.newBuilder().register(MattermostModelMapperProvider.class)).register(JacksonFeature.class)).register(MultiPartFeature.class)).property("jersey.config.client.suppressHttpComplianceValidation", (Object)true);
        if (this.clientLogLevel != null) {
            builder.register((Object)new LoggingFeature(Logger.getLogger(this.getClass().getName()), this.clientLogLevel, LoggingFeature.Verbosity.PAYLOAD_ANY, Integer.valueOf(1000)));
        }
        return builder.build();
    }

    @Override
    public void close() {
        this.httpClient.close();
    }

    public MattermostClient(String url) {
        this(url, null);
    }

    public MattermostClient(String url, Level logLevel) {
        this.url = url;
        this.apiUrl = url + API_URL_SUFFIX;
        this.clientLogLevel = logLevel;
        this.httpClient = this.buildClient();
    }

    public void setOAuthToken(String token) {
        this.authToken = token;
        this.authType = AuthType.TOKEN;
    }

    public void clearOAuthToken() {
        this.authToken = null;
        this.authType = AuthType.BEARER;
    }

    public void setAccessToken(String token) {
        this.authToken = token;
        this.authType = AuthType.BEARER;
    }

    public String getUsersRoute() {
        return "/users";
    }

    public String getUserRoute(String userId) {
        return this.getUsersRoute() + String.format("/%s", StringUtils.stripToEmpty((String)userId));
    }

    public String getUserByUsernameRoute(String userName) {
        return this.getUsersRoute() + String.format("/username/%s", StringUtils.stripToEmpty((String)userName));
    }

    public String getUserByEmailRoute(String email) {
        return this.getUsersRoute() + String.format("/email/%s", StringUtils.stripToEmpty((String)email));
    }

    public String getTeamsRoute() {
        return "/teams";
    }

    public String getTeamRoute(String teamId) {
        return this.getTeamsRoute() + String.format("/%s", StringUtils.stripToEmpty((String)teamId));
    }

    public String getTeamAutoCompleteCommandsRoute(String teamId) {
        return this.getTeamsRoute() + String.format("/%s/commands/autocomplete", StringUtils.stripToEmpty((String)teamId));
    }

    public String getTeamByNameRoute(String teamName) {
        return this.getTeamsRoute() + String.format("/name/%s", StringUtils.stripToEmpty((String)teamName));
    }

    public String getTeamMemberRoute(String teamId, String userId) {
        return this.getTeamRoute(teamId) + String.format("/members/%s", StringUtils.stripToEmpty((String)userId));
    }

    public String getTeamMembersRoute(String teamId) {
        return this.getTeamRoute(teamId) + "/members";
    }

    public String getTeamStatsRoute(String teamId) {
        return this.getTeamRoute(teamId) + "/stats";
    }

    public String getTeamImportRoute(String teamId) {
        return this.getTeamRoute(teamId) + "/import";
    }

    public String getChannelsRoute() {
        return "/channels";
    }

    public String getChannelsForTeamRoute(String teamId) {
        return this.getTeamRoute(teamId) + "/channels";
    }

    public String getChannelRoute(String channelId) {
        return this.getChannelsRoute() + String.format("/%s", StringUtils.stripToEmpty((String)channelId));
    }

    public String getChannelByNameRoute(String channelName, String teamId) {
        return this.getTeamRoute(teamId) + String.format("/channels/name/%s", StringUtils.stripToEmpty((String)channelName));
    }

    public String getChannelByNameForTeamNameRoute(String channelName, String teamName) {
        return this.getTeamByNameRoute(teamName) + String.format("/channels/name/%s", StringUtils.stripToEmpty((String)channelName));
    }

    public String getChannelMembersRoute(String channelId) {
        return this.getChannelRoute(channelId) + "/members";
    }

    public String getChannelMemberRoute(String channelId, String userId) {
        return this.getChannelMembersRoute(channelId) + String.format("/%s", StringUtils.stripToEmpty((String)userId));
    }

    public String getPostsRoute() {
        return "/posts";
    }

    public String getConfigRoute() {
        return "/config";
    }

    public String getLicenseRoute() {
        return "/license";
    }

    public String getPostRoute(String postId) {
        return this.getPostsRoute() + String.format("/%s", StringUtils.stripToEmpty((String)postId));
    }

    public String getFilesRoute() {
        return "/files";
    }

    public String getFileRoute(String fileId) {
        return this.getFilesRoute() + String.format("/%s", StringUtils.stripToEmpty((String)fileId));
    }

    public String getSystemRoute() {
        return "/system";
    }

    public String getTestEmailRoute() {
        return "/email/test";
    }

    public String getDatabaseRoute() {
        return "/database";
    }

    public String getCacheRoute() {
        return "/caches";
    }

    public String getClusterRoute() {
        return "/cluster";
    }

    public String getIncomingWebhooksRoute() {
        return "/hooks/incoming";
    }

    public String getIncomingWebhookRoute(String hookId) {
        return this.getIncomingWebhooksRoute() + String.format("/%s", StringUtils.stripToEmpty((String)hookId));
    }

    public String getComplianceReportsRoute() {
        return "?compliance/reports";
    }

    public String getComplianceReportRoute(String reportId) {
        return String.format("/compliance/reports/%s", StringUtils.stripToEmpty((String)reportId));
    }

    public String getOutgoingWebhooksRoute() {
        return "/hooks/outgoing";
    }

    public String getOutgoingWebhookRoute(String hookId) {
        return this.getOutgoingWebhooksRoute() + String.format("/%s", StringUtils.stripToEmpty((String)hookId));
    }

    public String getPreferencesRoute(String userId) {
        return this.getUserRoute(userId) + "/preferences";
    }

    public String getUserStatusRoute(String userId) {
        return this.getUserRoute(userId) + "/status";
    }

    public String getUserStatusesRoute() {
        return this.getUsersRoute() + "/status";
    }

    public String getSamlRoute() {
        return "/saml";
    }

    public String getLdapRoute() {
        return "/ldap";
    }

    public String getBrandRoute() {
        return "/brand";
    }

    public String getCommandsRoute() {
        return "/commands";
    }

    public String getCommandRoute(String commandId) {
        return this.getCommandsRoute() + String.format("/%s", StringUtils.stripToEmpty((String)commandId));
    }

    public String getEmojisRoute() {
        return "/emoji";
    }

    public String getEmojiRoute(String emojiId) {
        return this.getEmojisRoute() + String.format("/%s", StringUtils.stripToEmpty((String)emojiId));
    }

    public String getReactionsRoute() {
        return "/reactions";
    }

    public String getOAuthAppsRoute() {
        return "/oauth/apps";
    }

    public String getOAuthAppRoute(String appId) {
        return String.format("/oauth/apps/%s", StringUtils.stripToEmpty((String)appId));
    }

    protected <T> ApiResponse<T> doApiGet(String url, String etag, Class<T> responseType) {
        return this.doApiRequest("GET", this.apiUrl + url, null, etag, responseType);
    }

    protected <T> ApiResponse<T> doApiGet(String url, String etag, GenericType<T> responseType) {
        return this.doApiRequest("GET", this.apiUrl + url, null, etag, responseType);
    }

    protected ApiResponse<Void> doApiGet(String url, String etag) {
        return this.doApiRequest("GET", this.apiUrl + url, null, etag);
    }

    protected <T, U> ApiResponse<T> doApiPost(String url, U data, Class<T> responseType) {
        return this.doApiRequest("POST", this.apiUrl + url, data, null, responseType);
    }

    protected <T, U> ApiResponse<T> doApiPost(String url, U data, GenericType<T> responseType) {
        return this.doApiRequest("POST", this.apiUrl + url, data, null, responseType);
    }

    protected <U> ApiResponse<Void> doApiPost(String url, U data) {
        return this.doApiRequest("POST", this.apiUrl + url, data, null);
    }

    protected ApiResponse<Void> doApiPostMultiPart(String url, MultiPart multiPart) {
        return this.doApiPostMultiPart(url, multiPart, Void.class);
    }

    protected <T> ApiResponse<T> doApiPostMultiPart(String url, MultiPart multiPart, Class<T> responseType) {
        return ApiResponse.of(this.httpClient.target(this.apiUrl + url).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header(HEADER_AUTH, (Object)this.getAuthority()).method("POST", Entity.entity((Object)multiPart, (MediaType)multiPart.getMediaType())), responseType);
    }

    protected <T, U> ApiResponse<T> doApiPut(String url, U data, Class<T> responseType) {
        return this.doApiRequest("PUT", this.apiUrl + url, data, null, responseType);
    }

    protected <U> ApiResponse<Void> doApiPut(String url, U data) {
        return this.doApiRequest("PUT", this.apiUrl + url, data, null);
    }

    protected <T> ApiResponse<T> doApiDelete(String url, Class<T> responseType) {
        return this.doApiRequest("DELETE", this.apiUrl + url, null, null, responseType);
    }

    protected ApiResponse<Void> doApiDelete(String url) {
        return this.doApiRequest("DELETE", this.apiUrl + url, null, null);
    }

    protected <T, U> ApiResponse<T> doApiRequest(String method, String url, U data, String etag, Class<T> responseType) {
        return ApiResponse.of(this.httpClient.target(url).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header(HEADER_ETAG_CLIENT, (Object)etag).header(HEADER_AUTH, (Object)this.getAuthority()).method(method, Entity.json(data)), responseType);
    }

    protected <T, U> ApiResponse<T> doApiRequest(String method, String url, U data, String etag, GenericType<T> responseType) {
        return ApiResponse.of(this.httpClient.target(url).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header(HEADER_ETAG_CLIENT, (Object)etag).header(HEADER_AUTH, (Object)this.getAuthority()).method(method, Entity.json(data)), responseType);
    }

    protected <U> ApiResponse<Void> doApiRequest(String method, String url, U data, String etag) {
        return ApiResponse.of(this.httpClient.target(url).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header(HEADER_ETAG_CLIENT, (Object)etag).header(HEADER_AUTH, (Object)this.getAuthority()).method(method, Entity.json(data)), Void.class);
    }

    private String getAuthority() {
        return this.authToken != null ? this.authType.getCode() + " " + this.authToken : null;
    }

    @Override
    public User loginById(String id, String password) {
        return this.login(LoginRequest.builder().id(id).password(password).build());
    }

    protected ApiResponse<User> onLogin(ApiResponse<Void> loginResponse) {
        this.authToken = loginResponse.getRawResponse().getHeaderString(HEADER_TOKEN);
        this.authType = AuthType.BEARER;
        return ApiResponse.of(loginResponse.getRawResponse(), User.class);
    }

    protected User login(LoginRequest param) {
        return this.onLogin(this.doApiPost("/users/login", param)).readEntity();
    }

    @Override
    public User login(String loginId, String password) {
        return this.login(LoginRequest.builder().loginId(loginId).password(password).build());
    }

    @Override
    public User loginByLdap(String loginId, String password) {
        return this.login(LoginRequest.builder().loginId(loginId).password(password).ldapOnly(true).build());
    }

    @Override
    public User loginWithDevice(String loginId, String password, String deviceId) {
        return this.login(LoginRequest.builder().loginId(loginId).password(password).deviceId(deviceId).build());
    }

    @Override
    public ApiResponse<Boolean> logout() {
        return this.onLogout(this.doApiPost("/users/logout", ""));
    }

    protected ApiResponse<Boolean> onLogout(ApiResponse<Void> logoutResponse) {
        this.authToken = null;
        this.authType = AuthType.BEARER;
        return logoutResponse.checkStatusOk();
    }

    @Override
    public ApiResponse<SwitchAccountTypeResult> switchAccountType(SwitchRequest switchRequest) {
        return this.doApiPost(this.getUsersRoute() + "/login/switch", switchRequest, SwitchAccountTypeResult.class);
    }

    @Override
    public ApiResponse<User> createUser(User user) {
        return this.doApiPost(this.getUsersRoute(), user, User.class);
    }

    @Override
    public ApiResponse<User> getMe(String etag) {
        return this.doApiGet(this.getUserRoute(ME), etag, User.class);
    }

    @Override
    public ApiResponse<User> getUser(String userId, String etag) {
        return this.doApiGet(this.getUserRoute(userId), etag, User.class);
    }

    @Override
    public ApiResponse<User> getUserByUsername(String userName, String etag) {
        return this.doApiGet(this.getUserByUsernameRoute(userName), etag, User.class);
    }

    @Override
    public ApiResponse<User> getUserByEmail(String email, String etag) {
        return this.doApiGet(this.getUserByEmailRoute(email), etag, User.class);
    }

    @Override
    public ApiResponse<UserAutocomplete> autocompleteUsersInTeam(String teamId, String username, String etag) {
        String query = new QueryBuilder().set("in_team", teamId).set("name", username).toString();
        return this.doApiGet(this.getUsersRoute() + "/autocomplete" + query, etag, UserAutocomplete.class);
    }

    @Override
    public ApiResponse<UserAutocomplete> autocompleteUsersInChannel(String teamId, String channelId, String username, String etag) {
        String query = new QueryBuilder().set("in_team", teamId).set("in_channel", channelId).set("name", username).toString();
        return this.doApiGet(this.getUsersRoute() + "/autocomplete" + query, etag, UserAutocomplete.class);
    }

    @Override
    public ApiResponse<UserAutocomplete> autocompleteUsers(String username, String etag) {
        String query = new QueryBuilder().set("name", username).toString();
        return this.doApiGet(this.getUsersRoute() + "/autocomplete" + query, etag, UserAutocomplete.class);
    }

    @Override
    public ApiResponse<byte[]> getProfileImage(String userId, String etag) {
        return this.doApiGet(this.getUserRoute(userId) + "/image", etag, byte[].class);
    }

    private GenericType<Map<String, String>> stringMapType() {
        return new GenericType<Map<String, String>>(){};
    }

    private <T> GenericType<List<T>> listType() {
        return new GenericType<List<T>>(){};
    }

    @Override
    public ApiResponse<UserList> getUsers(Pager pager, String etag) {
        return this.doApiGet(this.getUsersRoute() + pager.toQuery(), etag, UserList.class);
    }

    @Override
    public ApiResponse<UserList> getUsersInTeam(String teamId, Pager pager, String etag) {
        String query = new QueryBuilder().set("in_team", teamId).toString();
        return this.doApiGet(this.getUsersRoute() + query + pager.toQuery(false), etag, UserList.class);
    }

    @Override
    public ApiResponse<UserList> getUsersNotInTeam(String teamId, Pager pager, String etag) {
        String query = new QueryBuilder().set("not_in_team", teamId).toString();
        return this.doApiGet(this.getUsersRoute() + query + pager.toQuery(false), etag, UserList.class);
    }

    @Override
    public ApiResponse<UserList> getUsersInChannel(String channelId, Pager pager, String etag) {
        String query = new QueryBuilder().set("in_channel", channelId).toString();
        return this.doApiGet(this.getUsersRoute() + query + pager.toQuery(false), etag, UserList.class);
    }

    @Override
    public ApiResponse<UserList> getUsersNotInChannel(String teamId, String channelId, Pager pager, String etag) {
        String query = new QueryBuilder().set("in_team", teamId).set("not_in_channel", channelId).toString();
        return this.doApiGet(this.getUsersRoute() + query + pager.toQuery(false), etag, UserList.class);
    }

    @Override
    public ApiResponse<UserList> getUsersWithoutTeam(Pager pager, String etag) {
        String query = new QueryBuilder().set("without_team", 1).toString();
        return this.doApiGet(this.getUsersRoute() + query + pager.toQuery(false), etag, UserList.class);
    }

    @Override
    public ApiResponse<UserList> getUsersByIds(String ... userIds) {
        return this.doApiPost(this.getUsersRoute() + "/ids", userIds, UserList.class);
    }

    @Override
    public ApiResponse<UserList> getUsersByUsernames(String ... usernames) {
        return this.doApiPost(this.getUsersRoute() + "/usernames", usernames, UserList.class);
    }

    @Override
    public ApiResponse<UserList> searchUsers(UserSearch search) {
        return this.doApiPost(this.getUsersRoute() + "/search", search, UserList.class);
    }

    @Override
    public ApiResponse<User> updateUser(User user) {
        return this.doApiPut(this.getUserRoute(user.getId()), user, User.class);
    }

    @Override
    public ApiResponse<User> patchUser(String userId, UserPatch patch) {
        return this.doApiPut(this.getUserRoute(userId) + "/patch", patch, User.class);
    }

    @Override
    public ApiResponse<Boolean> updateUserMfa(String userId, String code, boolean activate) {
        UpdateUserMfaRequest request = UpdateUserMfaRequest.builder().activate(activate).code(code).build();
        return this.doApiPut(this.getUserRoute(userId) + "/mfa", request).checkStatusOk();
    }

    @Override
    public boolean checkUserMfa(String loginId) {
        CheckUserMfaRequest request = CheckUserMfaRequest.builder().loginId(loginId).build();
        return Boolean.valueOf(this.doApiPost(this.getUsersRoute() + "/mfa", request, this.stringMapType()).readEntity().getOrDefault("mfa_required", "false"));
    }

    @Override
    public ApiResponse<MfaSecret> generateMfaSecret(String userId) {
        return this.doApiPost(this.getUserRoute(userId) + "/mfa/generate", null, MfaSecret.class);
    }

    @Override
    public ApiResponse<Boolean> updateUserPassword(String userId, String currentPassword, String newPassword) {
        UpdateUserPasswordRequest request = UpdateUserPasswordRequest.builder().currentPassword(currentPassword).newPassword(newPassword).build();
        return this.doApiPut(this.getUserRoute(userId) + "/password", request).checkStatusOk();
    }

    @Override
    public ApiResponse<Boolean> updateUserRoles(String userId, Role ... roles) {
        UpdateRolesRequest request = new UpdateRolesRequest(roles);
        return this.doApiPut(this.getUserRoute(userId) + "/roles", request).checkStatusOk();
    }

    @Override
    public ApiResponse<Boolean> updateUserActive(String userId, boolean active) {
        UpdateUserActiveRequest request = UpdateUserActiveRequest.builder().active(active).build();
        return this.doApiPut(this.getUserRoute(userId) + "/active", request).checkStatusOk();
    }

    @Override
    public ApiResponse<Boolean> deleteUser(String userId) {
        return this.doApiDelete(this.getUserRoute(userId)).checkStatusOk();
    }

    @Override
    public ApiResponse<Boolean> sendPasswordResetEmail(String email) {
        SendPasswordResetEmailRequest request = SendPasswordResetEmailRequest.builder().email(email).build();
        return this.doApiPost(this.getUsersRoute() + "/password/reset/send", request).checkStatusOk();
    }

    @Override
    public ApiResponse<Boolean> resetPassword(String token, String newPassword) {
        ResetPasswordRequest request = ResetPasswordRequest.builder().token(token).newPassword(newPassword).build();
        return this.doApiPost(this.getUsersRoute() + "/password/reset", request).checkStatusOk();
    }

    @Override
    public ApiResponse<SessionList> getSessions(String userId, String etag) {
        return this.doApiGet(this.getUserRoute(userId) + "/sessions", etag, SessionList.class);
    }

    @Override
    public ApiResponse<Boolean> revokeSession(String userId, String sessionId) {
        RevokeSessionRequest request = RevokeSessionRequest.builder().sessionId(sessionId).build();
        return this.doApiPost(this.getUserRoute(userId) + "/sessions/revoke", request).checkStatusOk();
    }

    @Override
    public ApiResponse<Boolean> attachDeviceId(String deviceId) {
        AttachDeviceIdRequest request = AttachDeviceIdRequest.builder().deviceId(deviceId).build();
        return this.doApiPut(this.getUsersRoute() + "/sessions/device", request).checkStatusOk();
    }

    @Override
    public ApiResponse<TeamUnreadList> getTeamUnreadForUser(String userId, String teamIdToExclude) {
        String optional = "";
        if (teamIdToExclude != null) {
            try {
                optional = String.format("?exclude_team=%s", URLEncoder.encode(teamIdToExclude, StandardCharsets.UTF_8.displayName()));
            }
            catch (UnsupportedEncodingException e) {
                throw new AssertionError((Object)e);
            }
        }
        return this.doApiGet(this.getUserRoute(userId) + "/teams/unread" + optional, null, TeamUnreadList.class);
    }

    @Override
    public ApiResponse<Audits> getUserAudits(String userId, Pager pager, String etag) {
        return this.doApiGet(this.getUserRoute(userId) + "/audits" + pager.toQuery(), etag, Audits.class);
    }

    @Override
    public ApiResponse<Boolean> verifyUserEmail(String token) {
        VerifyUserEmailRequest request = VerifyUserEmailRequest.builder().token(token).build();
        return this.doApiPost(this.getUsersRoute() + "/email/verify", request).checkStatusOk();
    }

    @Override
    public ApiResponse<Boolean> sendVerificationEmail(String email) {
        SendVerificationEmailRequest request = SendVerificationEmailRequest.builder().email(email).build();
        return this.doApiPost(this.getUsersRoute() + "/email/verify/send", request).checkStatusOk();
    }

    @Override
    public ApiResponse<Boolean> setProfileImage(String userId, Path imageFilePath) {
        MultiPart multiPart = new MultiPart();
        multiPart.setMediaType(MediaType.MULTIPART_FORM_DATA_TYPE);
        FileDataBodyPart body = new FileDataBodyPart("image", imageFilePath.toFile());
        multiPart.bodyPart((BodyPart)body);
        return this.doApiPostMultiPart(this.getUserRoute(userId) + "/image", multiPart).checkStatusOk();
    }

    @Override
    public ApiResponse<Team> createTeam(Team team) {
        return this.doApiPost(this.getTeamsRoute(), team, Team.class);
    }

    @Override
    public ApiResponse<Team> getTeam(String teamId, String etag) {
        return this.doApiGet(this.getTeamRoute(teamId), etag, Team.class);
    }

    @Override
    public ApiResponse<TeamList> getAllTeams(Pager pager, String etag) {
        return this.doApiGet(this.getTeamsRoute() + pager.toQuery(), etag, TeamList.class);
    }

    @Override
    public ApiResponse<Team> getTeamByName(String name, String etag) {
        return this.doApiGet(this.getTeamByNameRoute(name), etag, Team.class);
    }

    @Override
    public ApiResponse<TeamList> searchTeams(TeamSearch search) {
        return this.doApiPost(this.getTeamsRoute() + "/search", search, TeamList.class);
    }

    @Override
    public ApiResponse<TeamExists> teamExists(String name, String etag) {
        return this.doApiGet(this.getTeamByNameRoute(name) + "/exists", etag, TeamExists.class);
    }

    @Override
    public ApiResponse<TeamList> getTeamsForUser(String userId, String etag) {
        return this.doApiGet(this.getUserRoute(userId) + "/teams", etag, TeamList.class);
    }

    @Override
    public ApiResponse<TeamMember> getTeamMember(String teamId, String userId, String etag) {
        return this.doApiGet(this.getTeamMemberRoute(teamId, userId), etag, TeamMember.class);
    }

    @Override
    public ApiResponse<Boolean> updateTeamMemberRoles(String teamId, String userId, Role ... newRoles) {
        UpdateRolesRequest request = new UpdateRolesRequest(newRoles);
        return this.doApiPut(this.getTeamMemberRoute(teamId, userId) + "/roles", request).checkStatusOk();
    }

    @Override
    public ApiResponse<Team> updateTeam(Team team) {
        return this.doApiPut(this.getTeamRoute(team.getId()), team, Team.class);
    }

    @Override
    public ApiResponse<Team> patchTeam(String teamId, TeamPatch patch) {
        return this.doApiPut(this.getTeamRoute(teamId) + "/patch", patch, Team.class);
    }

    @Override
    public ApiResponse<Boolean> deleteTeam(String teamId) {
        return this.doApiDelete(this.getTeamRoute(teamId)).checkStatusOk();
    }

    @Override
    public ApiResponse<Boolean> deleteTeam(String teamId, boolean permanent) {
        String query = new QueryBuilder().set("permanent", Boolean.toString(permanent)).toString();
        return this.doApiDelete(this.getTeamRoute(teamId) + query).checkStatusOk();
    }

    @Override
    public ApiResponse<TeamMemberList> getTeamMembers(String teamId, Pager pager, String etag) {
        return this.doApiGet(this.getTeamMembersRoute(teamId) + pager.toQuery(), etag, TeamMemberList.class);
    }

    @Override
    public ApiResponse<TeamMemberList> getTeamMembersForUser(String userId, String etag) {
        return this.doApiGet(this.getUserRoute(userId) + "/teams/members", etag, TeamMemberList.class);
    }

    @Override
    public ApiResponse<TeamMemberList> getTeamMembersByIds(String teamId, String ... userIds) {
        String url = String.format("/teams/%s/members/ids", teamId);
        return this.doApiPost(url, userIds, TeamMemberList.class);
    }

    @Override
    public ApiResponse<TeamMember> addTeamMember(TeamMember teamMemberToAdd) {
        return this.doApiPost(this.getTeamMembersRoute(teamMemberToAdd.getTeamId()), teamMemberToAdd, TeamMember.class);
    }

    @Override
    @Deprecated
    public ApiResponse<TeamMember> addTeamMember(String teamId, String userId, String hash, String dataToHash, String inviteId) {
        QueryBuilder query = new QueryBuilder();
        if (StringUtils.isNotEmpty((CharSequence)inviteId)) {
            query.set("invite_id", inviteId);
        }
        if (StringUtils.isNotEmpty((CharSequence)hash) && StringUtils.isNotEmpty((CharSequence)dataToHash)) {
            query.set("hash", hash).set("data", dataToHash);
        }
        TeamMember teamMember = new TeamMember(teamId, userId);
        return this.doApiPost(this.getTeamMembersRoute(teamId) + query, teamMember, TeamMember.class);
    }

    @Override
    public ApiResponse<TeamMember> addTeamMember(String hash, String dataToHash, String inviteId) {
        QueryBuilder query = new QueryBuilder();
        if (StringUtils.isNotEmpty((CharSequence)inviteId)) {
            query.set("invite_id", inviteId);
        }
        if (StringUtils.isNotEmpty((CharSequence)hash) && StringUtils.isNotEmpty((CharSequence)dataToHash)) {
            query.set("hash", hash).set("data", dataToHash);
        }
        return this.doApiPost(this.getTeamsRoute() + "/members/invite" + query.toString(), null, TeamMember.class);
    }

    @Override
    public ApiResponse<TeamMemberList> addTeamMembers(String teamId, String ... userIds) {
        List members = Arrays.stream(userIds).map(u -> new TeamMember(teamId, u)).collect(Collectors.toList());
        return this.doApiPost(this.getTeamMembersRoute(teamId) + "/batch", members, TeamMemberList.class);
    }

    @Override
    public ApiResponse<Boolean> removeTeamMember(String teamId, String userId) {
        return this.doApiDelete(this.getTeamMemberRoute(teamId, userId)).checkStatusOk();
    }

    @Override
    public ApiResponse<TeamStats> getTeamStats(String teamId, String etag) {
        return this.doApiGet(this.getTeamStatsRoute(teamId), etag, TeamStats.class);
    }

    @Override
    public ApiResponse<TeamUnread> getTeamUnread(String teamId, String userId) {
        return this.doApiGet(this.getUserRoute(userId) + this.getTeamRoute(teamId) + "/unread", null, TeamUnread.class);
    }

    @Override
    public ApiResponse<byte[]> importTeam(byte[] data, int filesize, String importFrom, String fileName, String teamId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ApiResponse<Boolean> inviteUsersToTeam(String teamId, Collection<String> userEmails) {
        return this.doApiPost(this.getTeamRoute(teamId) + "/invite/email", userEmails).checkStatusOk();
    }

    @Override
    public ApiResponse<Channel> createChannel(Channel channel) {
        return this.doApiPost(this.getChannelsRoute(), channel, Channel.class);
    }

    @Override
    public ApiResponse<Channel> updateChannel(Channel channel) {
        return this.doApiPut(this.getChannelRoute(channel.getId()), channel, Channel.class);
    }

    @Override
    public ApiResponse<Channel> patchChannel(String channelId, ChannelPatch patch) {
        return this.doApiPut(this.getChannelRoute(channelId) + "/patch", patch, Channel.class);
    }

    @Override
    public ApiResponse<Channel> createDirectChannel(String userId1, String userId2) {
        return this.doApiPost(this.getChannelsRoute() + "/direct", Arrays.asList(userId1, userId2), Channel.class);
    }

    @Override
    public ApiResponse<Channel> createGroupChannel(String ... userIds) {
        return this.doApiPost(this.getChannelsRoute() + "/group", userIds, Channel.class);
    }

    @Override
    public ApiResponse<Channel> getChannel(String channelId, String etag) {
        return this.doApiGet(this.getChannelRoute(channelId), etag, Channel.class);
    }

    @Override
    public ApiResponse<ChannelStats> getChannelStats(String channelId, String etag) {
        return this.doApiGet(this.getChannelRoute(channelId) + "/stats", etag, ChannelStats.class);
    }

    @Override
    public ApiResponse<PostList> getPinnedPosts(String channelId, String etag) {
        return this.doApiGet(this.getChannelRoute(channelId) + "/pinned", etag, PostList.class);
    }

    @Override
    public ApiResponse<ChannelList> getPublicChannelsForTeam(String teamId, Pager pager, String etag) {
        return this.doApiGet(this.getChannelsForTeamRoute(teamId) + pager.toQuery(), etag, ChannelList.class);
    }

    @Override
    public ApiResponse<ChannelList> getPublicChannelsByIdsForTeam(String teamId, String ... channelIds) {
        return this.doApiPost(this.getChannelsForTeamRoute(teamId) + "/ids", channelIds, ChannelList.class);
    }

    @Override
    public ApiResponse<ChannelList> getChannelsForTeamForUser(String teamId, String userId, String etag) {
        return this.doApiGet(this.getUserRoute(userId) + this.getTeamRoute(teamId) + "/channels", etag, ChannelList.class);
    }

    @Override
    public ApiResponse<ChannelList> searchChannels(String teamId, ChannelSearch search) {
        return this.doApiPost(this.getChannelsForTeamRoute(teamId) + "/search", search, ChannelList.class);
    }

    @Override
    public ApiResponse<Boolean> deleteChannel(String channelId) {
        return this.doApiDelete(this.getChannelRoute(channelId)).checkStatusOk();
    }

    @Override
    public ApiResponse<Channel> getChannelByName(String channelName, String teamId, String etag) {
        return this.doApiGet(this.getChannelByNameRoute(channelName, teamId), etag, Channel.class);
    }

    @Override
    public ApiResponse<Channel> getChannelByNameForTeamName(String channelName, String teamName, String etag) {
        return this.doApiGet(this.getChannelByNameForTeamNameRoute(channelName, teamName), etag, Channel.class);
    }

    @Override
    public ApiResponse<ChannelMembers> getChannelMembers(String channelId, Pager pager, String etag) {
        return this.doApiGet(this.getChannelMembersRoute(channelId) + pager.toQuery(), etag, ChannelMembers.class);
    }

    @Override
    public ApiResponse<ChannelMembers> getChannelMembersByIds(String channelId, String ... userIds) {
        return this.doApiPost(this.getChannelMembersRoute(channelId) + "/ids", userIds, ChannelMembers.class);
    }

    @Override
    public ApiResponse<ChannelMember> getChannelMember(String channelId, String userId, String etag) {
        return this.doApiGet(this.getChannelMemberRoute(channelId, userId), etag, ChannelMember.class);
    }

    @Override
    public ApiResponse<ChannelMembers> getChannelMembersForUser(String userId, String teamId, String etag) {
        return this.doApiGet(this.getUserRoute(userId) + String.format("/teams/%s/channels/members", teamId), etag, ChannelMembers.class);
    }

    @Override
    public ApiResponse<ChannelViewResponse> viewChannel(String userId, ChannelView view) {
        String url = String.format(this.getChannelsRoute() + "/members/%s/view", userId);
        return this.doApiPost(url, view, ChannelViewResponse.class);
    }

    @Override
    public ApiResponse<ChannelUnread> getChannelUnread(String channelId, String userId) {
        return this.doApiGet(this.getUserRoute(userId) + this.getChannelRoute(channelId) + "/unread", null, ChannelUnread.class);
    }

    @Override
    public ApiResponse<Boolean> updateChannelRoles(String channelId, String userId, Role ... roles) {
        UpdateRolesRequest request = new UpdateRolesRequest(roles);
        return this.doApiPut(this.getChannelMemberRoute(channelId, userId) + "/roles", request).checkStatusOk();
    }

    @Override
    public ApiResponse<Boolean> updateChannelNotifyProps(String channelId, String userId, Map<String, String> props) {
        return this.doApiPut(this.getChannelMemberRoute(channelId, userId) + "/notify_props", props).checkStatusOk();
    }

    @Override
    public ApiResponse<ChannelMember> addChannelMember(String channelId, String userId) {
        AddChannelMemberRequest request = AddChannelMemberRequest.builder().userId(userId).build();
        return this.doApiPost(this.getChannelMembersRoute(channelId), request, ChannelMember.class);
    }

    @Override
    public ApiResponse<Boolean> removeUserFromChannel(String channelId, String userId) {
        return this.doApiDelete(this.getChannelMemberRoute(channelId, userId)).checkStatusOk();
    }

    @Override
    public ApiResponse<Channel> restoreChannel(String channelId) {
        return this.doApiPost(this.getChannelRoute(channelId) + "/restore", null, Channel.class);
    }

    @Override
    public ApiResponse<ChannelList> getDeletedChannels(String teamId, Pager pager) {
        return this.doApiGet(this.getChannelsForTeamRoute(teamId) + "/deleted" + pager.toQuery(), null, ChannelList.class);
    }

    @Override
    public ApiResponse<Post> createPost(Post post) {
        return this.doApiPost(this.getPostsRoute(), post, Post.class);
    }

    @Override
    public ApiResponse<Post> updatePost(String postId, Post post) {
        return this.doApiPut(this.getPostRoute(postId), post, Post.class);
    }

    @Override
    public ApiResponse<Post> patchPost(String postId, PostPatch patch) {
        return this.doApiPut(this.getPostRoute(postId) + "/patch", patch, Post.class);
    }

    @Override
    public ApiResponse<Boolean> pinPost(String postId) {
        return this.doApiPost(this.getPostRoute(postId) + "/pin", null).checkStatusOk();
    }

    @Override
    public ApiResponse<Boolean> unpinPost(String postId) {
        return this.doApiPost(this.getPostRoute(postId) + "/unpin", null).checkStatusOk();
    }

    @Override
    public ApiResponse<Post> getPost(String postId, String etag) {
        return this.doApiGet(this.getPostRoute(postId), etag, Post.class);
    }

    @Override
    public ApiResponse<Boolean> deletePost(String postId) {
        return this.doApiDelete(this.getPostRoute(postId)).checkStatusOk();
    }

    @Override
    public ApiResponse<PostList> getPostThread(String postId, String etag) {
        return this.doApiGet(this.getPostRoute(postId) + "/thread", etag, PostList.class);
    }

    @Override
    public ApiResponse<PostList> getPostsForChannel(String channelId, Pager pager, String etag) {
        return this.doApiGet(this.getChannelRoute(channelId) + "/posts" + pager.toQuery(), etag, PostList.class);
    }

    @Override
    public ApiResponse<PostList> getFlaggedPostsForUser(String userId, Pager pager) {
        return this.doApiGet(this.getUserRoute(userId) + "/posts/flagged" + pager.toQuery(), null, PostList.class);
    }

    @Override
    public ApiResponse<PostList> getFlaggedPostsForUserInTeam(String userId, String teamId, Pager pager) {
        String query = new QueryBuilder().set("in_team", teamId).toString();
        return this.doApiGet(this.getUserRoute(userId) + "/posts/flagged" + query + pager.toQuery(false), null, PostList.class);
    }

    @Override
    public ApiResponse<PostList> getFlaggedPostsForUserInChannel(String userId, String channelId, Pager pager) {
        String query = new QueryBuilder().set("in_channel", channelId).toString();
        return this.doApiGet(this.getUserRoute(userId) + "/posts/flagged" + query + pager.toQuery(false), null, PostList.class);
    }

    @Override
    public ApiResponse<PostList> getPostsSince(String channelId, long time) {
        String query = String.format("?since=%d", time);
        return this.doApiGet(this.getChannelRoute(channelId) + "/posts" + query, null, PostList.class);
    }

    @Override
    public ApiResponse<PostList> getPostsAfter(String channelId, String postId, Pager pager, String etag) {
        String query = new QueryBuilder().set("after", postId).toString();
        return this.doApiGet(this.getChannelRoute(channelId) + "/posts" + query + pager.toQuery(false), etag, PostList.class);
    }

    @Override
    public ApiResponse<PostList> getPostsBefore(String channelId, String postId, Pager pager, String etag) {
        String query = new QueryBuilder().set("before", postId).toString();
        return this.doApiGet(this.getChannelRoute(channelId) + "/posts" + query + pager.toQuery(false), etag, PostList.class);
    }

    @Override
    public ApiResponse<PostList> searchPosts(String teamId, String terms, boolean isOrSearch) {
        SearchPostsRequest request = SearchPostsRequest.builder().terms(terms).isOrSearch(isOrSearch).build();
        return this.doApiPost(this.getTeamRoute(teamId) + "/posts/search", request, PostList.class);
    }

    @Override
    public ApiResponse<Boolean> getPing() {
        return this.doApiGet(this.getSystemRoute() + "/ping", null).checkStatusOk();
    }

    @Override
    public ApiResponse<Boolean> testEmail() {
        return this.doApiPost(this.getTestEmailRoute(), null).checkStatusOk();
    }

    @Override
    public ApiResponse<Config> getConfig() {
        return this.doApiGet(this.getConfigRoute(), null, Config.class);
    }

    @Override
    public ApiResponse<Boolean> reloadConfig() {
        return this.doApiPost(this.getConfigRoute() + "/reload", null).checkStatusOk();
    }

    @Override
    public ApiResponse<Map<String, String>> getOldClientConfig(String etag) {
        return this.doApiGet(this.getConfigRoute() + "/client?format=old", etag, this.stringMapType());
    }

    @Override
    public ApiResponse<Map<String, String>> getOldClientLicense(String etag) {
        return this.doApiGet(this.getLicenseRoute() + "/client?format=old", etag, this.stringMapType());
    }

    @Override
    public ApiResponse<Boolean> databaseRecycle() {
        return this.doApiPost(this.getDatabaseRoute() + "/recycle", null).checkStatusOk();
    }

    @Override
    public ApiResponse<Boolean> invalidateCaches() {
        return this.doApiPost(this.getCacheRoute() + "/invalidate", null).checkStatusOk();
    }

    @Override
    public ApiResponse<Config> updateConfig(Config config) {
        return this.doApiPut(this.getConfigRoute(), config, Config.class);
    }

    @Override
    public ApiResponse<AnalyticsRows> getAnalytics(AnalyticsCategory category, String teamId) {
        QueryBuilder queryBuilder = new QueryBuilder();
        queryBuilder.set("name", category.getCode());
        if (StringUtils.isNotEmpty((CharSequence)teamId)) {
            queryBuilder.set("team_id", teamId);
        }
        return this.doApiGet("/analytics/old" + queryBuilder.toString(), null, AnalyticsRows.class);
    }

    @Override
    public ApiResponse<Boolean> uploadLicenseFile(Path licenseFile) {
        FormDataMultiPart multiPart = new FormDataMultiPart();
        multiPart.setMediaType(MediaType.MULTIPART_FORM_DATA_TYPE);
        FileDataBodyPart body = new FileDataBodyPart("license", licenseFile.toFile());
        multiPart.bodyPart((BodyPart)body);
        return this.doApiPostMultiPart("/license", (MultiPart)multiPart).checkStatusOk();
    }

    @Override
    public ApiResponse<Boolean> removeLicense() {
        return this.doApiDelete("/license").checkStatusOk();
    }

    @Override
    public ApiResponse<IncomingWebhook> createIncomingWebhook(IncomingWebhook hook) {
        return this.doApiPost(this.getIncomingWebhooksRoute(), hook, IncomingWebhook.class);
    }

    @Override
    public ApiResponse<IncomingWebhook> updateIncomingWebhook(IncomingWebhook hook) {
        return this.doApiPut(this.getIncomingWebhookRoute(hook.getId()), hook, IncomingWebhook.class);
    }

    @Override
    public ApiResponse<IncomingWebhookList> getIncomingWebhooks(Pager pager, String etag) {
        return this.doApiGet(this.getIncomingWebhooksRoute() + pager.toQuery(), etag, IncomingWebhookList.class);
    }

    @Override
    public ApiResponse<IncomingWebhookList> getIncomingWebhooksForTeam(String teamId, Pager pager, String etag) {
        String query = new QueryBuilder().set("team_id", teamId).toString();
        return this.doApiGet(this.getIncomingWebhooksRoute() + query + pager.toQuery(false), etag, IncomingWebhookList.class);
    }

    @Override
    public ApiResponse<IncomingWebhook> getIncomingWebhook(String hookId, String etag) {
        return this.doApiGet(this.getIncomingWebhookRoute(hookId), etag, IncomingWebhook.class);
    }

    @Override
    public ApiResponse<Boolean> deleteIncomingWebhook(String hookId) {
        return this.doApiDelete(this.getIncomingWebhookRoute(hookId)).checkStatusOk();
    }

    @Override
    public ApiResponse<OutgoingWebhook> createOutgoingWebhook(OutgoingWebhook hook) {
        return this.doApiPost(this.getOutgoingWebhooksRoute(), hook, OutgoingWebhook.class);
    }

    @Override
    public ApiResponse<OutgoingWebhook> updateOutgoingWebhook(OutgoingWebhook hook) {
        return this.doApiPut(this.getOutgoingWebhookRoute(hook.getId()), hook, OutgoingWebhook.class);
    }

    @Override
    public ApiResponse<OutgoingWebhookList> getOutgoingWebhooks(Pager pager, String etag) {
        return this.doApiGet(this.getOutgoingWebhooksRoute() + pager.toQuery(), etag, OutgoingWebhookList.class);
    }

    @Override
    public ApiResponse<OutgoingWebhook> getOutgoingWebhook(String hookId) {
        return this.doApiGet(this.getOutgoingWebhookRoute(hookId), null, OutgoingWebhook.class);
    }

    @Override
    public ApiResponse<OutgoingWebhookList> getOutgoingWebhooksForChannel(String channelId, Pager pager, String etag) {
        String query = new QueryBuilder().set("channel_id", channelId).toString();
        return this.doApiGet(this.getOutgoingWebhooksRoute() + query + pager.toQuery(false), etag, OutgoingWebhookList.class);
    }

    @Override
    public ApiResponse<OutgoingWebhookList> getOutgoingWebhooksForTeam(String teamId, Pager pager, String etag) {
        String query = new QueryBuilder().set("team_id", teamId).toString();
        return this.doApiGet(this.getOutgoingWebhooksRoute() + query + pager.toQuery(false), etag, OutgoingWebhookList.class);
    }

    @Override
    public ApiResponse<OutgoingWebhook> regenOutgoingHookToken(String hookId) {
        return this.doApiPost(this.getOutgoingWebhookRoute(hookId) + "/regen_token", null, OutgoingWebhook.class);
    }

    @Override
    public ApiResponse<Boolean> deleteOutgoingWebhook(String hookId) {
        return this.doApiDelete(this.getOutgoingWebhookRoute(hookId)).checkStatusOk();
    }

    @Override
    public ApiResponse<Preferences> getPreferences(String userId) {
        return this.doApiGet(this.getPreferencesRoute(userId), null, Preferences.class);
    }

    @Override
    public ApiResponse<Boolean> updatePreferences(String userId, Preferences preferences) {
        return this.doApiPut(this.getPreferencesRoute(userId), preferences).checkStatusOk();
    }

    @Override
    public ApiResponse<Boolean> deletePreferences(String userId, Preferences preferences) {
        return this.doApiPost(this.getPreferencesRoute(userId) + "/delete", preferences).checkStatusOk();
    }

    @Override
    public ApiResponse<Preferences> getPreferencesByCategory(String userId, PreferenceCategory category) {
        String url = String.format(this.getPreferencesRoute(userId) + "/%s", category.getCode());
        return this.doApiGet(url, null, Preferences.class);
    }

    @Override
    public ApiResponse<Preference> getPreferenceByCategoryAndName(String userId, PreferenceCategory category, String preferenceName) {
        String url = String.format(this.getPreferencesRoute(userId) + "/%s/name/%s", category.getCode(), preferenceName);
        return this.doApiGet(url, null, Preference.class);
    }

    @Override
    public ApiResponse<String> getSamlMetadata() {
        return this.doApiGet(this.getSamlRoute() + "/metadata", null, String.class);
    }

    protected Object samlFileToMultipart(Path dataFile, String dataFileName) {
        throw new UnsupportedOperationException("not impl");
    }

    @Override
    public boolean uploadSamlIdpCertificate(Path dataFile, String fileName) {
        throw new UnsupportedOperationException("not impl");
    }

    @Override
    public boolean uploadSamlPublicCertificate(Path dataFile, String fileName) {
        throw new UnsupportedOperationException("not impl");
    }

    @Override
    public boolean uploadSamlPrivateCertificate(Path dataFile, String fileName) {
        throw new UnsupportedOperationException("not impl");
    }

    @Override
    public ApiResponse<Boolean> deleteSamlIdpCertificate() {
        return this.doApiDelete(this.getSamlRoute() + "/certificate/idp").checkStatusOk();
    }

    @Override
    public ApiResponse<Boolean> deleteSamlPublicCertificate() {
        return this.doApiDelete(this.getSamlRoute() + "/certificate/public").checkStatusOk();
    }

    @Override
    public ApiResponse<Boolean> deleteSamlPrivateCertificate() {
        return this.doApiDelete(this.getSamlRoute() + "/certificate/private").checkStatusOk();
    }

    @Override
    public ApiResponse<SamlCertificateStatus> getSamlCertificateStatus() {
        return this.doApiGet(this.getSamlRoute() + "/certificate/status", null, SamlCertificateStatus.class);
    }

    @Override
    public ApiResponse<Compliance> createComplianceReport(Compliance report) {
        return this.doApiPost(this.getComplianceReportsRoute(), report, Compliance.class);
    }

    @Override
    public ApiResponse<Compliances> getComplianceReports(Pager pager) {
        return this.doApiGet(this.getComplianceReportsRoute() + pager.toQuery(), null, Compliances.class);
    }

    @Override
    public ApiResponse<Compliance> getComplianceReport(String reportId) {
        return this.doApiGet(this.getComplianceReportRoute(reportId), null, Compliance.class);
    }

    @Override
    public ApiResponse<Object> downloadComplianceReport(String reportId) {
        throw new UnsupportedOperationException("not impl");
    }

    @Override
    public ApiResponse<List<ClusterInfo>> getClusterStatus() {
        return this.doApiGet(this.getClusterRoute() + "/status", null, this.listType());
    }

    @Override
    public ApiResponse<Boolean> syncLdap() {
        return this.doApiPost(this.getLdapRoute() + "/sync", null).checkStatusOk();
    }

    @Override
    public ApiResponse<Boolean> testLdap() {
        return this.doApiPost(this.getLdapRoute() + "/test", null).checkStatusOk();
    }

    @Override
    public ApiResponse<Audits> getAudits(Pager pager, String etag) {
        return this.doApiGet("/audits" + pager.toQuery(), etag, Audits.class);
    }

    @Override
    public ApiResponse<Object> getBrandImage() {
        throw new UnsupportedOperationException("not impl");
    }

    @Override
    public boolean uploadBrandImage(Path dataFile) {
        throw new UnsupportedOperationException("not impl");
    }

    @Override
    public ApiResponse<List<String>> getLogs(Pager pager) {
        return this.doApiGet("/logs" + pager.toQuery(), null, this.listType());
    }

    @Override
    public ApiResponse<Map<String, String>> postLog(Map<String, String> message) {
        return this.doApiPost("/logs", message, this.stringMapType());
    }

    @Override
    public ApiResponse<OAuthApp> createOAuthApp(OAuthApp app) {
        return this.doApiPost(this.getOAuthAppsRoute(), app, OAuthApp.class);
    }

    @Override
    public ApiResponse<List<OAuthApp>> getOAuthApps(Pager pager) {
        return this.doApiGet(this.getOAuthAppsRoute() + pager.toQuery(), null, this.listType());
    }

    @Override
    public ApiResponse<OAuthApp> getOAuthApp(String appId) {
        return this.doApiGet(this.getOAuthAppRoute(appId), null, OAuthApp.class);
    }

    @Override
    public ApiResponse<OAuthApp> getOAuthAppInfo(String appId) {
        return this.doApiGet(this.getOAuthAppRoute(appId) + "/info", null, OAuthApp.class);
    }

    @Override
    public ApiResponse<Boolean> deleteOAuthApp(String appId) {
        return this.doApiDelete(this.getOAuthAppRoute(appId)).checkStatusOk();
    }

    @Override
    public ApiResponse<OAuthApp> regenerateOAuthAppSecret(String appId) {
        return this.doApiPost(this.getOAuthAppRoute(appId) + "/regen_secret", null, OAuthApp.class);
    }

    @Override
    public ApiResponse<List<OAuthApp>> getAuthorizedOAuthAppsForUser(String userId, Pager pager) {
        return this.doApiGet(this.getUserRoute(userId) + "/oauth/apps/authorized" + pager.toQuery(), null, this.listType());
    }

    @Override
    public String authorizeOAuthApp(AuthorizeRequest authRequest) {
        return this.doApiRequest("POST", this.url + "/oauth/authorize", authRequest, null, this.stringMapType()).readEntity().get("redirect");
    }

    @Override
    public ApiResponse<Boolean> deauthorizeOAuthApp(String appId) {
        DeauthorizeOAuthAppRequest request = DeauthorizeOAuthAppRequest.builder().clientId(appId).build();
        return this.doApiRequest("POST", this.url + "/oauth/deauthorize", request, null).checkStatusOk();
    }

    @Override
    public ApiResponse<Command> createCommand(Command cmd) {
        return this.doApiPost(this.getCommandsRoute(), cmd, Command.class);
    }

    @Override
    public ApiResponse<Command> updateCommand(Command cmd) {
        return this.doApiPut(this.getCommandRoute(cmd.getId()), cmd, Command.class);
    }

    @Override
    public ApiResponse<Boolean> deleteCommand(String commandId) {
        return this.doApiDelete(this.getCommandRoute(commandId)).checkStatusOk();
    }

    @Override
    public ApiResponse<CommandList> listCommands(String teamId, boolean customOnly) {
        String query = new QueryBuilder().set("team_id", teamId).set("custom_only", customOnly).toString();
        return this.doApiGet(this.getCommandsRoute() + query, null, CommandList.class);
    }

    @Override
    public ApiResponse<CommandResponse> executeCommand(String channelId, String command) {
        CommandArgs args = new CommandArgs();
        args.setChannelId(channelId);
        args.setCommand(command);
        return this.doApiPost(this.getCommandsRoute() + "/execute", args, CommandResponse.class);
    }

    @Override
    public ApiResponse<CommandList> listAutocompleteCommands(String teamId) {
        return this.doApiGet(this.getTeamAutoCompleteCommandsRoute(teamId), null, CommandList.class);
    }

    @Override
    public ApiResponse<String> regenCommandToken(String commandId) {
        return this.doApiPut(this.getCommandRoute(commandId) + "/regen_token", null, String.class);
    }

    @Override
    public ApiResponse<Status> getUserStatus(String userId, String etag) {
        return this.doApiGet(this.getUserStatusRoute(userId), etag, Status.class);
    }

    @Override
    public ApiResponse<List<Status>> getUsersStatusesByIds(String ... userIds) {
        return this.doApiPost(this.getUserStatusesRoute() + "/ids", userIds, this.listType());
    }

    @Override
    public ApiResponse<Status> updateUserStatus(String userId, Status userStatus) {
        return this.doApiPut(this.getUserStatusRoute(userId), userStatus, Status.class);
    }

    @Override
    public ApiResponse<WebrtcInfoResponse> getWebrtcToken() {
        return this.doApiGet("/webrtc/token", null, WebrtcInfoResponse.class);
    }

    @Override
    public ApiResponse<Emoji> createEmoji(Emoji emoji, Path imageFile) {
        FormDataMultiPart multiPart = new FormDataMultiPart();
        multiPart.setMediaType(MediaType.MULTIPART_FORM_DATA_TYPE);
        FileDataBodyPart body = new FileDataBodyPart("image", imageFile.toFile());
        multiPart.bodyPart((BodyPart)body);
        multiPart.field("emoji", (Object)emoji, MediaType.APPLICATION_JSON_TYPE);
        return this.doApiPostMultiPart(this.getEmojisRoute(), (MultiPart)multiPart, Emoji.class);
    }

    @Override
    public ApiResponse<EmojiList> getEmojiList(Pager pager) {
        return this.doApiGet(this.getEmojisRoute() + pager.toQuery(), null, EmojiList.class);
    }

    @Override
    public ApiResponse<Boolean> deleteEmoji(String emojiId) {
        return this.doApiDelete(this.getEmojiRoute(emojiId)).checkStatusOk();
    }

    @Override
    public ApiResponse<Emoji> getEmoji(String emojiId) {
        return this.doApiGet(this.getEmojiRoute(emojiId), null, Emoji.class);
    }

    @Override
    public ApiResponse<Path> getEmojiImage(String emojiId) throws IOException {
        ApiResponse<InputStream> emojiResponse = this.doApiGet(this.getEmojiRoute(emojiId) + "/image", null, InputStream.class);
        if (emojiResponse.hasError()) {
            ApiResponse<Class<Path>> errorResponse = ApiResponse.of(emojiResponse.getRawResponse(), Path.class);
            return errorResponse;
        }
        String suffix = this.detectImageSuffix(emojiResponse.getRawResponse());
        Path imageFile = Files.createTempFile(null, suffix, new FileAttribute[0]);
        Files.copy(emojiResponse.readEntity(), imageFile, StandardCopyOption.REPLACE_EXISTING);
        ApiResponse<Path> response = ApiResponse.of(emojiResponse.getRawResponse(), imageFile);
        return response;
    }

    private String detectImageSuffix(Response response) {
        MediaType mediaType = response.getMediaType();
        if (mediaType.isCompatible(MediaType.valueOf((String)"image/png"))) {
            return ".png";
        }
        if (mediaType.isCompatible(MediaType.valueOf((String)"image/jpeg"))) {
            return ".jpg";
        }
        if (mediaType.isCompatible(MediaType.valueOf((String)"image/gif"))) {
            return ".gif";
        }
        if (mediaType.isCompatible(MediaType.valueOf((String)"image/bmp"))) {
            return ".bmp";
        }
        throw new IllegalArgumentException("Unsupported Content-Type: " + mediaType.toString());
    }

    @Override
    public ApiResponse<Reaction> saveReaction(Reaction reaction) {
        return this.doApiPost(this.getReactionsRoute(), reaction, Reaction.class);
    }

    @Override
    public ApiResponse<List<Reaction>> getReactions(String postId) {
        return this.doApiGet(this.getPostRoute(postId) + "/reactions", null, this.listType());
    }

    @Override
    public ApiResponse<Boolean> deleteReaction(Reaction reaction) {
        return this.doApiDelete(this.getUserRoute(reaction.getUserId()) + this.getPostRoute(reaction.getPostId()) + String.format("/reactions/%s", reaction.getEmojiName())).checkStatusOk();
    }
}

