/*
 * Decompiled with CFR 0.152.
 */
package net.bis5.mattermost.client4;

public final class Pager {
    private final int page;
    private final int perPage;
    private static final Pager DEFAULT = Pager.of(0, 60);

    public static Pager defaultPager() {
        return DEFAULT;
    }

    public Pager nextPage() {
        return Pager.of(this.page + 1, this.perPage);
    }

    public String toQuery() {
        return this.toQuery(true);
    }

    public String toQuery(boolean isHead) {
        return (isHead ? "?" : "&") + String.format("page=%d&per_page=%d", this.page, this.perPage);
    }

    private Pager(int page, int perPage) {
        this.page = page;
        this.perPage = perPage;
    }

    public static Pager of(int page, int perPage) {
        return new Pager(page, perPage);
    }

    public int getPage() {
        return this.page;
    }

    public int getPerPage() {
        return this.perPage;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Pager)) {
            return false;
        }
        Pager other = (Pager)o;
        if (this.getPage() != other.getPage()) {
            return false;
        }
        return this.getPerPage() == other.getPerPage();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPage();
        result = result * 59 + this.getPerPage();
        return result;
    }

    public String toString() {
        return "Pager(page=" + this.getPage() + ", perPage=" + this.getPerPage() + ")";
    }
}

