/*
 * Decompiled with CFR 0.152.
 */
package net.bis5.mattermost.client4.hook;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import net.bis5.mattermost.client4.ApiResponse;
import net.bis5.mattermost.client4.api.hook.IncomingWebhook;
import net.bis5.mattermost.jersey.provider.MattermostModelMapperProvider;
import net.bis5.mattermost.model.IncomingWebhookRequest;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.logging.LoggingFeature;

public class IncomingWebhookClient
implements IncomingWebhook {
    private final Client hookClient;
    private final WebTarget hookTarget;

    public IncomingWebhookClient(String hookUrl) {
        this(hookUrl, null);
    }

    public IncomingWebhookClient(String hookUrl, Level clientLogLevel) {
        this.hookClient = this.createClient(clientLogLevel);
        this.hookTarget = this.hookClient.target(hookUrl);
    }

    protected Client createClient(Level clientLogLevel) {
        ClientBuilder builder = (ClientBuilder)((ClientBuilder)ClientBuilder.newBuilder().register(MattermostModelMapperProvider.class)).register(JacksonFeature.class);
        if (clientLogLevel != null) {
            builder.register((Object)new LoggingFeature(Logger.getLogger(this.getClass().getName()), clientLogLevel, LoggingFeature.Verbosity.PAYLOAD_ANY, Integer.valueOf(1000)));
        }
        return builder.build();
    }

    @Override
    public ApiResponse<Boolean> postByIncomingWebhook(IncomingWebhookRequest payload) {
        return ApiResponse.of(this.hookTarget.request(new MediaType[]{MediaType.TEXT_PLAIN_TYPE, MediaType.APPLICATION_JSON_TYPE}).method("POST", Entity.json((Object)payload)), Void.class).checkStatusOK();
    }
}

