/*
 * Decompiled with CFR 0.152.
 */
package net.bis5.mattermost.client4.api;

import java.nio.file.Path;
import java.util.Collection;
import net.bis5.mattermost.client4.ApiResponse;
import net.bis5.mattermost.client4.Pager;
import net.bis5.mattermost.model.Audits;
import net.bis5.mattermost.model.Role;
import net.bis5.mattermost.model.Session;
import net.bis5.mattermost.model.SessionList;
import net.bis5.mattermost.model.TeamUnreadList;
import net.bis5.mattermost.model.User;
import net.bis5.mattermost.model.UserAutocomplete;
import net.bis5.mattermost.model.UserList;
import net.bis5.mattermost.model.UserPatch;
import net.bis5.mattermost.model.UserSearch;
import net.bis5.mattermost.model.license.MfaSecret;

public interface UserApi {
    public ApiResponse<User> createUser(User var1);

    default public ApiResponse<User> getMe() {
        return this.getMe(null);
    }

    public ApiResponse<User> getMe(String var1);

    default public ApiResponse<User> getUser(String userId) {
        return this.getUser(userId, null);
    }

    public ApiResponse<User> getUser(String var1, String var2);

    default public ApiResponse<User> getUserByUsername(String username) {
        return this.getUserByUsername(username, null);
    }

    public ApiResponse<User> getUserByUsername(String var1, String var2);

    default public ApiResponse<User> getUserByEmail(String email) {
        return this.getUserByEmail(email, null);
    }

    public ApiResponse<User> getUserByEmail(String var1, String var2);

    default public ApiResponse<UserAutocomplete> autocompleteUsersInTeam(String teamId, String username) {
        return this.autocompleteUsersInTeam(teamId, username, null);
    }

    public ApiResponse<UserAutocomplete> autocompleteUsersInTeam(String var1, String var2, String var3);

    default public ApiResponse<UserAutocomplete> autocompleteUsersInChannel(String teamId, String channelId, String username) {
        return this.autocompleteUsersInChannel(teamId, channelId, username, null);
    }

    public ApiResponse<UserAutocomplete> autocompleteUsersInChannel(String var1, String var2, String var3, String var4);

    default public ApiResponse<UserAutocomplete> autocompleteUsers(String username) {
        return this.autocompleteUsers(username, null);
    }

    public ApiResponse<UserAutocomplete> autocompleteUsers(String var1, String var2);

    default public ApiResponse<byte[]> getProfileImage(String userId) {
        return this.getProfileImage(userId, null);
    }

    public ApiResponse<byte[]> getProfileImage(String var1, String var2);

    default public ApiResponse<UserList> getUsers() {
        return this.getUsers(Pager.defaultPager());
    }

    default public ApiResponse<UserList> getUsers(Pager pager) {
        return this.getUsers(pager, null);
    }

    public ApiResponse<UserList> getUsers(Pager var1, String var2);

    default public ApiResponse<UserList> getUsersInTeam(String teamId) {
        return this.getUsersInTeam(teamId, Pager.defaultPager());
    }

    default public ApiResponse<UserList> getUsersInTeam(String teamId, Pager pager) {
        return this.getUsersInTeam(teamId, pager, null);
    }

    public ApiResponse<UserList> getUsersInTeam(String var1, Pager var2, String var3);

    default public ApiResponse<UserList> getUsersNotInTeam(String teamId) {
        return this.getUsersNotInTeam(teamId, Pager.defaultPager());
    }

    default public ApiResponse<UserList> getUsersNotInTeam(String teamId, Pager pager) {
        return this.getUsersNotInTeam(teamId, pager, null);
    }

    public ApiResponse<UserList> getUsersNotInTeam(String var1, Pager var2, String var3);

    default public ApiResponse<UserList> getUsersInChannel(String channelId) {
        return this.getUsersInChannel(channelId, Pager.defaultPager());
    }

    default public ApiResponse<UserList> getUsersInChannel(String channelId, Pager pager) {
        return this.getUsersInChannel(channelId, pager, null);
    }

    public ApiResponse<UserList> getUsersInChannel(String var1, Pager var2, String var3);

    default public ApiResponse<UserList> getUsersNotInChannel(String teamId, String channelId) {
        return this.getUsersNotInChannel(teamId, channelId, Pager.defaultPager());
    }

    default public ApiResponse<UserList> getUsersNotInChannel(String teamId, String channelId, Pager pager) {
        return this.getUsersNotInChannel(teamId, channelId, pager, null);
    }

    public ApiResponse<UserList> getUsersNotInChannel(String var1, String var2, Pager var3, String var4);

    default public ApiResponse<UserList> getUsersWithoutTeam() {
        return this.getUsersWithoutTeam(Pager.defaultPager());
    }

    default public ApiResponse<UserList> getUsersWithoutTeam(Pager pager) {
        return this.getUsersWithoutTeam(pager, null);
    }

    public ApiResponse<UserList> getUsersWithoutTeam(Pager var1, String var2);

    default public ApiResponse<UserList> getUsersByIds(Collection<String> userIds) {
        return this.getUsersByIds(userIds.toArray(new String[0]));
    }

    public ApiResponse<UserList> getUsersByIds(String ... var1);

    default public ApiResponse<UserList> getUsersByUsernames(Collection<String> usernames) {
        return this.getUsersByUsernames(usernames.toArray(new String[0]));
    }

    public ApiResponse<UserList> getUsersByUsernames(String ... var1);

    public ApiResponse<UserList> searchUsers(UserSearch var1);

    public ApiResponse<User> updateUser(User var1);

    public ApiResponse<User> patchUser(String var1, UserPatch var2);

    public ApiResponse<Boolean> updateUserMfa(String var1, String var2, boolean var3);

    public boolean checkUserMfa(String var1);

    public ApiResponse<MfaSecret> generateMfaSecret(String var1);

    public ApiResponse<Boolean> updateUserPassword(String var1, String var2, String var3);

    default public ApiResponse<Boolean> updateUserRoles(String userId, Collection<Role> roles) {
        return this.updateUserRoles(userId, roles.toArray(new Role[0]));
    }

    public ApiResponse<Boolean> updateUserRoles(String var1, Role ... var2);

    public ApiResponse<Boolean> updateUserActive(String var1, boolean var2);

    public ApiResponse<Boolean> deleteUser(String var1);

    public ApiResponse<Boolean> sendPasswordResetEmail(String var1);

    public ApiResponse<Boolean> resetPassword(String var1, String var2);

    default public ApiResponse<SessionList> getSessions(String userId) {
        return this.getSessions(userId, null);
    }

    public ApiResponse<SessionList> getSessions(String var1, String var2);

    default public ApiResponse<Boolean> revokeSession(Session session) {
        return this.revokeSession(session.getUserId(), session.getId());
    }

    public ApiResponse<Boolean> revokeSession(String var1, String var2);

    public ApiResponse<Boolean> attachDeviceId(String var1);

    default public ApiResponse<TeamUnreadList> getTeamUnreadForUser(String userId) {
        return this.getTeamUnreadForUser(userId, null);
    }

    public ApiResponse<TeamUnreadList> getTeamUnreadForUser(String var1, String var2);

    default public ApiResponse<Audits> getUserAudits(String userId) {
        return this.getUserAudits(userId, Pager.defaultPager());
    }

    default public ApiResponse<Audits> getUserAudits(String userId, Pager pager) {
        return this.getUserAudits(userId, pager, null);
    }

    public ApiResponse<Audits> getUserAudits(String var1, Pager var2, String var3);

    public ApiResponse<Boolean> verifyUserEmail(String var1);

    public ApiResponse<Boolean> sendVerificationEmail(String var1);

    public ApiResponse<Boolean> setProfileImage(String var1, Path var2);
}

