/*
 * Decompiled with CFR 0.152.
 */
package net.bis5.mattermost.client4.api;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import net.bis5.mattermost.client4.ApiResponse;
import net.bis5.mattermost.client4.Pager;
import net.bis5.mattermost.model.Role;
import net.bis5.mattermost.model.Team;
import net.bis5.mattermost.model.TeamExists;
import net.bis5.mattermost.model.TeamInviteInfo;
import net.bis5.mattermost.model.TeamList;
import net.bis5.mattermost.model.TeamMember;
import net.bis5.mattermost.model.TeamMemberList;
import net.bis5.mattermost.model.TeamPatch;
import net.bis5.mattermost.model.TeamSearch;
import net.bis5.mattermost.model.TeamStats;
import net.bis5.mattermost.model.TeamUnread;

public interface TeamApi {
    public ApiResponse<Team> createTeam(Team var1);

    default public ApiResponse<Team> getTeam(String teamId) {
        return this.getTeam(teamId, null);
    }

    public ApiResponse<Team> getTeam(String var1, String var2);

    default public ApiResponse<TeamList> getAllTeams() {
        return this.getAllTeams(Pager.defaultPager());
    }

    default public ApiResponse<TeamList> getAllTeams(Pager pager) {
        return this.getAllTeams(pager, null);
    }

    public ApiResponse<TeamList> getAllTeams(Pager var1, String var2);

    default public ApiResponse<Team> getTeamByName(String name) {
        return this.getTeamByName(name, null);
    }

    public ApiResponse<Team> getTeamByName(String var1, String var2);

    public ApiResponse<TeamList> searchTeams(TeamSearch var1);

    default public ApiResponse<TeamExists> teamExists(String name) {
        return this.teamExists(name, null);
    }

    public ApiResponse<TeamExists> teamExists(String var1, String var2);

    default public ApiResponse<TeamList> getTeamsForUser(String userId) {
        return this.getTeamsForUser(userId, null);
    }

    public ApiResponse<TeamList> getTeamsForUser(String var1, String var2);

    default public ApiResponse<TeamMember> getTeamMember(String teamId, String userId) {
        return this.getTeamMember(teamId, userId, null);
    }

    public ApiResponse<TeamMember> getTeamMember(String var1, String var2, String var3);

    default public ApiResponse<Boolean> updateTeamMemberRoles(String teamId, String userId, Collection<Role> newRoles) {
        return this.updateTeamMemberRoles(teamId, userId, newRoles.toArray(new Role[0]));
    }

    public ApiResponse<Boolean> updateTeamMemberRoles(String var1, String var2, Role ... var3);

    public ApiResponse<Team> updateTeam(Team var1);

    public ApiResponse<Team> patchTeam(String var1, TeamPatch var2);

    default public ApiResponse<Boolean> deleteTeam(String teamId) {
        return this.deleteTeam(teamId, false);
    }

    public ApiResponse<Boolean> deleteTeam(String var1, boolean var2);

    default public ApiResponse<TeamMemberList> getTeamMembers(String teamId) {
        return this.getTeamMembers(teamId, Pager.defaultPager());
    }

    default public ApiResponse<TeamMemberList> getTeamMembers(String teamId, Pager pager) {
        return this.getTeamMembers(teamId, pager, null);
    }

    public ApiResponse<TeamMemberList> getTeamMembers(String var1, Pager var2, String var3);

    default public ApiResponse<TeamMemberList> getTeamMembersForUser(String userId) {
        return this.getTeamMembersForUser(userId, null);
    }

    public ApiResponse<TeamMemberList> getTeamMembersForUser(String var1, String var2);

    default public ApiResponse<TeamMemberList> getTeamMembersByIds(String teamId, Collection<String> userIds) {
        return this.getTeamMembersByIds(teamId, userIds.toArray(new String[0]));
    }

    public ApiResponse<TeamMemberList> getTeamMembersByIds(String var1, String ... var2);

    public ApiResponse<TeamMember> addTeamMember(TeamMember var1);

    @Deprecated
    public ApiResponse<TeamMember> addTeamMember(String var1, String var2, String var3, String var4, String var5);

    public ApiResponse<TeamMember> addTeamMember(String var1, String var2, String var3);

    default public ApiResponse<TeamMemberList> addTeamMembers(String teamId, Collection<String> userIds) {
        return this.addTeamMembers(teamId, userIds.toArray(new String[0]));
    }

    public ApiResponse<TeamMemberList> addTeamMembers(String var1, String ... var2);

    default public ApiResponse<Boolean> removeTeamMember(TeamMember teamMember) {
        return this.removeTeamMember(teamMember.getTeamId(), teamMember.getUserId());
    }

    public ApiResponse<Boolean> removeTeamMember(String var1, String var2);

    default public ApiResponse<TeamStats> getTeamStats(String teamId) {
        return this.getTeamStats(teamId, null);
    }

    public ApiResponse<TeamStats> getTeamStats(String var1, String var2);

    public ApiResponse<Path> getTeamIcon(String var1) throws IOException;

    public ApiResponse<Boolean> setTeamIcon(String var1, Path var2);

    public ApiResponse<Boolean> removeTeamIcon(String var1);

    public ApiResponse<TeamUnread> getTeamUnread(String var1, String var2);

    public ApiResponse<byte[]> importTeam(byte[] var1, int var2, String var3, String var4, String var5);

    public ApiResponse<Boolean> inviteUsersToTeam(String var1, Collection<String> var2);

    public ApiResponse<TeamInviteInfo> getInviteInfo(String var1);
}

