/*
 * Decompiled with CFR 0.152.
 */
package net.bis5.mattermost.jersey.provider;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import net.bis5.mattermost.model.Config;
import net.bis5.mattermost.model.serialize.MattermostPropertyNamingStrategy;

@Provider
public class MattermostModelMapperProvider
implements ContextResolver<ObjectMapper> {
    final ObjectMapper defaultObjectMapper;
    final ObjectMapper configObjectMapper;
    private final boolean ignoreUnknownProperties;

    public MattermostModelMapperProvider() {
        this(false);
    }

    public MattermostModelMapperProvider(boolean ignoreUnknownProperties) {
        this.ignoreUnknownProperties = ignoreUnknownProperties;
        this.defaultObjectMapper = this.createDefaultObjectMapper();
        this.configObjectMapper = this.createConfigObjectMapper();
    }

    protected ObjectMapper createDefaultObjectMapper() {
        return new ObjectMapper().configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, !this.ignoreUnknownProperties).setSerializationInclusion(JsonInclude.Include.NON_EMPTY).setPropertyNamingStrategy((PropertyNamingStrategy)new MattermostPropertyNamingStrategy());
    }

    protected ObjectMapper createConfigObjectMapper() {
        return new ObjectMapper().configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, !this.ignoreUnknownProperties).setSerializationInclusion(JsonInclude.Include.ALWAYS).setPropertyNamingStrategy((PropertyNamingStrategy)new MattermostPropertyNamingStrategy());
    }

    public ObjectMapper getContext(Class<?> type) {
        if (type == Config.class || type.getName().startsWith("net.bis5.mattermost.model.config")) {
            return this.configObjectMapper;
        }
        return this.defaultObjectMapper;
    }
}

