/*
 * Decompiled with CFR 0.152.
 */
package net.bis5.mattermost.client4;

import java.beans.ConstructorProperties;
import java.util.Map;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import net.bis5.mattermost.client4.model.ApiError;
import org.apache.commons.lang3.StringUtils;

public abstract class ApiResponse<T> {
    protected final Response response;
    protected static final String STATUS = "status";
    protected static final String STATUS_OK = "ok";

    public abstract T readEntity();

    public ApiError readError() {
        return (ApiError)this.response.readEntity(ApiError.class);
    }

    public boolean hasError() {
        this.response.bufferEntity();
        try {
            this.readError();
            return true;
        }
        catch (ProcessingException ex) {
            return false;
        }
    }

    public Response getRawResponse() {
        return this.response;
    }

    public String getEtag() {
        return this.response.getHeaderString("Etag");
    }

    public ApiResponse<Boolean> checkStatusOk() {
        Response response = this.getRawResponse();
        response.bufferEntity();
        if (response.getMediaType().equals((Object)MediaType.TEXT_PLAIN_TYPE)) {
            return this.checkPlainStatusOk(response);
        }
        return this.checkJsonStatusOk(response);
    }

    protected ApiResponse<Boolean> checkPlainStatusOk(Response response) {
        String statusCode = (String)response.readEntity(String.class);
        boolean success = StringUtils.equalsIgnoreCase((CharSequence)statusCode, (CharSequence)STATUS_OK);
        return ApiResponse.of(response, success);
    }

    protected ApiResponse<Boolean> checkJsonStatusOk(Response response) {
        Map m = (Map)response.readEntity((GenericType)new GenericType<Map<String, String>>(){});
        boolean success = m != null && m.getOrDefault(STATUS, "").equalsIgnoreCase(STATUS_OK);
        return ApiResponse.of(response, success);
    }

    public static <T> ApiResponse<T> of(Response response, Class<T> entityClass) {
        return new EntityResponse<T>(response, entityClass);
    }

    public static <T> ApiResponse<T> of(Response response, GenericType<T> genericType) {
        return new GenericResponse<T>(response, genericType);
    }

    public static <T> ApiResponse<T> of(Response response, T data) {
        return new SimpleResponse<T>(response, data);
    }

    @ConstructorProperties(value={"response"})
    public ApiResponse(Response response) {
        this.response = response;
    }

    private static class SimpleResponse<T>
    extends ApiResponse<T> {
        private final T data;

        public SimpleResponse(Response response, T data) {
            super(response);
            this.data = data;
        }

        @Override
        public T readEntity() {
            return this.data;
        }
    }

    private static class GenericResponse<T>
    extends ApiResponse<T> {
        private final GenericType<T> genericType;

        public GenericResponse(Response response, GenericType<T> genericType) {
            super(response);
            this.genericType = genericType;
        }

        @Override
        public T readEntity() {
            return (T)this.response.readEntity(this.genericType);
        }
    }

    private static class EntityResponse<T>
    extends ApiResponse<T> {
        private final Class<T> entityClass;

        public EntityResponse(Response response, Class<T> entityClass) {
            super(response);
            this.entityClass = entityClass;
        }

        @Override
        public T readEntity() {
            return (T)this.response.readEntity(this.entityClass);
        }
    }
}

