/*
 * Decompiled with CFR 0.152.
 */
package net.bis5.mattermost.client4.api;

import java.util.Collection;
import java.util.Map;
import net.bis5.mattermost.client4.ApiResponse;
import net.bis5.mattermost.client4.Pager;
import net.bis5.mattermost.model.Channel;
import net.bis5.mattermost.model.ChannelList;
import net.bis5.mattermost.model.ChannelMember;
import net.bis5.mattermost.model.ChannelMembers;
import net.bis5.mattermost.model.ChannelPatch;
import net.bis5.mattermost.model.ChannelSearch;
import net.bis5.mattermost.model.ChannelStats;
import net.bis5.mattermost.model.ChannelUnread;
import net.bis5.mattermost.model.ChannelView;
import net.bis5.mattermost.model.ChannelViewResponse;
import net.bis5.mattermost.model.PostList;
import net.bis5.mattermost.model.Role;

public interface ChannelApi {
    public ApiResponse<Channel> createChannel(Channel var1);

    public ApiResponse<Channel> updateChannel(Channel var1);

    public ApiResponse<Channel> patchChannel(String var1, ChannelPatch var2);

    public ApiResponse<Channel> createDirectChannel(String var1, String var2);

    default public ApiResponse<Channel> createGroupChannel(Collection<String> userIds) {
        return this.createGroupChannel(userIds.toArray(new String[0]));
    }

    public ApiResponse<Channel> createGroupChannel(String ... var1);

    default public ApiResponse<Channel> getChannel(String channelId) {
        return this.getChannel(channelId, null);
    }

    public ApiResponse<Channel> getChannel(String var1, String var2);

    default public ApiResponse<ChannelStats> getChannelStats(String channelId) {
        return this.getChannelStats(channelId, null);
    }

    public ApiResponse<ChannelStats> getChannelStats(String var1, String var2);

    default public ApiResponse<PostList> getPinnedPosts(String channelId) {
        return this.getPinnedPosts(channelId, null);
    }

    public ApiResponse<PostList> getPinnedPosts(String var1, String var2);

    default public ApiResponse<ChannelList> getPublicChannelsForTeam(String teamId) {
        return this.getPublicChannelsForTeam(teamId, Pager.defaultPager());
    }

    default public ApiResponse<ChannelList> getPublicChannelsForTeam(String teamId, Pager pager) {
        return this.getPublicChannelsForTeam(teamId, pager, null);
    }

    public ApiResponse<ChannelList> getPublicChannelsForTeam(String var1, Pager var2, String var3);

    default public ApiResponse<ChannelList> getPublicChannelsByIdsForTeam(String teamId, Collection<String> channelIds) {
        return this.getPublicChannelsByIdsForTeam(teamId, channelIds.toArray(new String[0]));
    }

    public ApiResponse<ChannelList> getPublicChannelsByIdsForTeam(String var1, String ... var2);

    default public ApiResponse<ChannelList> getChannelsForTeamForUser(String teamId, String userId) {
        return this.getChannelsForTeamForUser(teamId, userId, null);
    }

    public ApiResponse<ChannelList> getChannelsForTeamForUser(String var1, String var2, String var3);

    public ApiResponse<ChannelList> searchChannels(String var1, ChannelSearch var2);

    public ApiResponse<Boolean> deleteChannel(String var1);

    default public ApiResponse<Channel> getChannelByName(String channelName, String teamId) {
        return this.getChannelByName(channelName, teamId, null);
    }

    public ApiResponse<Channel> getChannelByName(String var1, String var2, String var3);

    default public ApiResponse<Channel> getChannelByNameForTeamName(String channelName, String teamName) {
        return this.getChannelByNameForTeamName(channelName, teamName, null);
    }

    public ApiResponse<Channel> getChannelByNameForTeamName(String var1, String var2, String var3);

    default public ApiResponse<ChannelMembers> getChannelMembers(String channelId) {
        return this.getChannelMembers(channelId, Pager.defaultPager());
    }

    default public ApiResponse<ChannelMembers> getChannelMembers(String channelId, Pager pager) {
        return this.getChannelMembers(channelId, pager, null);
    }

    public ApiResponse<ChannelMembers> getChannelMembers(String var1, Pager var2, String var3);

    default public ApiResponse<ChannelMembers> getChannelMembersByIds(String channelId, Collection<String> userIds) {
        return this.getChannelMembersByIds(channelId, userIds.toArray(new String[0]));
    }

    public ApiResponse<ChannelMembers> getChannelMembersByIds(String var1, String ... var2);

    default public ApiResponse<ChannelMember> getChannelMember(String channelId, String userId) {
        return this.getChannelMember(channelId, userId, null);
    }

    public ApiResponse<ChannelMember> getChannelMember(String var1, String var2, String var3);

    default public ApiResponse<ChannelMembers> getChannelMembersForUser(String userId, String teamId) {
        return this.getChannelMembersForUser(userId, teamId, null);
    }

    public ApiResponse<ChannelMembers> getChannelMembersForUser(String var1, String var2, String var3);

    public ApiResponse<ChannelViewResponse> viewChannel(String var1, ChannelView var2);

    public ApiResponse<ChannelUnread> getChannelUnread(String var1, String var2);

    default public ApiResponse<Boolean> updateChannelRoles(String channelId, String userId, Collection<Role> roles) {
        return this.updateChannelRoles(channelId, userId, roles.toArray(new Role[0]));
    }

    public ApiResponse<Boolean> updateChannelRoles(String var1, String var2, Role ... var3);

    public ApiResponse<Boolean> updateChannelNotifyProps(String var1, String var2, Map<String, String> var3);

    public ApiResponse<ChannelMember> addChannelMember(String var1, String var2);

    public ApiResponse<Boolean> removeUserFromChannel(String var1, String var2);

    public ApiResponse<Channel> restoreChannel(String var1);

    default public ApiResponse<ChannelList> getDeletedChannels(String teamId) {
        return this.getDeletedChannels(teamId, Pager.defaultPager());
    }

    public ApiResponse<ChannelList> getDeletedChannels(String var1, Pager var2);

    public ApiResponse<Channel> convertChannelToPrivate(String var1);
}

