/*
 * Decompiled with CFR 0.152.
 */
package net.bis5.mattermost.model;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;

@JsonSerialize(using=TriggerWhenSerializer.class)
@JsonDeserialize(using=TriggerWhenDeserializer.class)
public enum TriggerWhen {
    CONTAINS(1),
    STARTS_WITH(0);

    private final int code;

    public static TriggerWhen of(int code) {
        return Arrays.stream(TriggerWhen.values()).filter(e -> e.getCode() == code).findFirst().orElse(null);
    }

    public int getCode() {
        return this.code;
    }

    private TriggerWhen(int code) {
        this.code = code;
    }

    static class TriggerWhenDeserializer
    extends JsonDeserializer<TriggerWhen> {
        TriggerWhenDeserializer() {
        }

        public TriggerWhen deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            int jsonValue = p.getValueAsInt();
            return TriggerWhen.of(jsonValue);
        }
    }

    static class TriggerWhenSerializer
    extends JsonSerializer<TriggerWhen> {
        TriggerWhenSerializer() {
        }

        public void serialize(TriggerWhen value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
            if (value != null) {
                gen.writeNumber(value.getCode());
            }
        }
    }
}

