/*
 * Decompiled with CFR 0.152.
 */
package net.bis5.mattermost.model.config.consts;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import net.bis5.mattermost.model.HasCode;
import net.bis5.mattermost.model.serialize.HasCodeSerializer;

@JsonSerialize(using=HasCodeSerializer.class)
@JsonDeserialize(using=ConnectionSecuritySerializer.class)
public enum ConnectionSecurity implements HasCode<ConnectionSecurity>
{
    NONE(""),
    PLAIN("PLAIN"),
    TLS("TLS"),
    STARTTLS("STARTTLS");

    private final String code;

    private ConnectionSecurity(String code) {
        this.code = code;
    }

    public static ConnectionSecurity of(String code) {
        return Arrays.stream(ConnectionSecurity.values()).filter(e -> e.getCode().equals(code)).findFirst().orElse(NONE);
    }

    @Override
    public String getCode() {
        return this.code;
    }

    public static class ConnectionSecuritySerializer
    extends JsonDeserializer<ConnectionSecurity> {
        public ConnectionSecurity deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            String jsonValue = p.getText();
            return ConnectionSecurity.of(jsonValue);
        }
    }
}

