/*
 * Decompiled with CFR 0.152.
 */
package net.bis5.mattermost.model.config.consts;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import net.bis5.mattermost.model.HasCode;
import net.bis5.mattermost.model.serialize.HasCodeSerializer;

@JsonSerialize(using=HasCodeSerializer.class)
@JsonDeserialize(using=GroupUnreadChannelsDeserializer.class)
public enum GroupUnreadChannels implements HasCode<GroupUnreadChannels>
{
    DISABLED("disabled"),
    DEFAULT_OFF("default_off"),
    DEFAULT_ON("default_on");

    private final String code;

    public static GroupUnreadChannels of(String code) {
        return Arrays.stream(GroupUnreadChannels.values()).filter(e -> e.getCode().equals(code)).findFirst().orElse(null);
    }

    @Override
    public String getCode() {
        return this.code;
    }

    private GroupUnreadChannels(String code) {
        this.code = code;
    }

    public static class GroupUnreadChannelsDeserializer
    extends JsonDeserializer<GroupUnreadChannels> {
        public GroupUnreadChannels deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            String jsonValue = p.getText();
            return GroupUnreadChannels.of(jsonValue);
        }
    }
}

