/*
 * Decompiled with CFR 0.152.
 */
package net.bis5.mattermost.model.config;

import java.util.List;
import net.bis5.mattermost.model.config.consts.AllowEditPost;
import net.bis5.mattermost.model.config.consts.ConnectionSecurity;
import net.bis5.mattermost.model.config.consts.GroupUnreadChannels;
import net.bis5.mattermost.model.config.consts.ImageProxyType;
import net.bis5.mattermost.model.config.consts.PermissionsDeletePost;
import net.bis5.mattermost.model.config.consts.RestrictEmojiCreation;
import net.bis5.mattermost.model.config.consts.WebServerMode;

public class ServiceSettings {
    private String siteUrl;
    private String licenseFileLocation;
    private String listenAddress;
    private ConnectionSecurity connectionSecurity;
    private String tlsCertFile;
    private String tlsKeyFile;
    private boolean useLetsEncrypt;
    private String letsEncryptCertificateCacheFile;
    private boolean forward80To443;
    private int readTimeout;
    private int writeTimeout;
    private int maximumLoginAttempts;
    private String googleDeveloperKey;
    private boolean enableOAuthServiceProvider;
    private boolean enableIncomingWebhooks;
    private boolean enableOutgoingWebhooks;
    private boolean enableCommands;
    private boolean enableOnlyAdminIntegrations;
    private boolean enablePostUsernameOverride;
    private boolean enablePostIconOverride;
    private boolean enableLinkPreviews;
    private boolean enableTesting;
    private boolean enableDeveloper;
    private boolean enableSecurityFixAlert;
    private boolean enableInsecureOutgoingConnections;
    private boolean enableMultifactorAuthentication;
    private boolean enforceMultifactorAuthentication;
    private String allowCorsFrom;
    private int sessionLengthWebInDays;
    private int sessionLengthMobileInDays;
    private int sessionLengthSsoInDays;
    private int sessionCacheInMinutes;
    private int websocketSecurePort;
    private int websocketPort;
    private WebServerMode webServerMode;
    private boolean enableCustomEmoji;
    private RestrictEmojiCreation restrictCustomEmojiCreation;
    private PermissionsDeletePost restrictPostDelete;
    private AllowEditPost allowEditPost;
    private int postEditTimeLimit;
    private long timeBetweenUserTypingUpdatesMilliseconds;
    private boolean enablePostSearch;
    private boolean enableUserTypingMessages;
    private boolean enableUserStatuses;
    private int clusterLogTimeoutMilliseconds;
    private int goroutineHealthThreshold;
    private boolean enableEmojiPicker;
    private boolean enableChannelViewedMessages;
    private boolean enableApiv3 = false;
    private boolean enableUserAccessTokens;
    private String allowedUntrustedInternalConnections;
    private int sessionIdleTimeoutInMinutes;
    private boolean closeUnusedDirectMessages;
    private boolean enablePreviewFeatures = true;
    private boolean experimentalEnableAuthenticationTransfer = true;
    private boolean enableTutorial = true;
    private ImageProxyType imageProxyType;
    private String imageProxyOptions;
    private String imageProxyUrl;
    private GroupUnreadChannels experimentalGroupUnreadChannels = GroupUnreadChannels.DISABLED;
    private boolean experimentalEnableDefaultChannelLeaveJoinMessages = true;
    private boolean allowCookiesForSubdomains;
    private String websocketUrl;
    private boolean enableEmailInvitations;
    private boolean enableApiTeamDeletion;
    private boolean experimentalEnableHardenedMode;
    private boolean enableGifPicker;
    private String gfycatApiKey;
    private String gfycatApiSecret;
    private boolean experimentalLimitClientConfig;
    private String corsExposedHeaders;
    private boolean corsAllowCredentials;
    private boolean corsDebug;
    private boolean experimentalChannelOrganization;
    private String tlsMinVer;
    private boolean tlsStrictTransport;
    private long tlsStrictTransportMaxAge;
    private List<String> tlsOverwriteCiphers;

    @Deprecated
    public int getGoroutineHealthThreshould() {
        return this.getGoroutineHealthThreshold();
    }

    @Deprecated
    public void setGoroutineHealthThreshould(int goroutineHealthThresould) {
        this.setGoroutineHealthThreshold(goroutineHealthThresould);
    }

    @Deprecated
    public boolean isEnableUserAccessToken() {
        return this.isEnableUserAccessTokens();
    }

    @Deprecated
    public void setEnableUserAccessToken(boolean enableUserAccessToken) {
        this.setEnableUserAccessTokens(enableUserAccessToken);
    }

    public String getSiteUrl() {
        return this.siteUrl;
    }

    public String getLicenseFileLocation() {
        return this.licenseFileLocation;
    }

    public String getListenAddress() {
        return this.listenAddress;
    }

    public ConnectionSecurity getConnectionSecurity() {
        return this.connectionSecurity;
    }

    public String getTlsCertFile() {
        return this.tlsCertFile;
    }

    public String getTlsKeyFile() {
        return this.tlsKeyFile;
    }

    public boolean isUseLetsEncrypt() {
        return this.useLetsEncrypt;
    }

    public String getLetsEncryptCertificateCacheFile() {
        return this.letsEncryptCertificateCacheFile;
    }

    public boolean isForward80To443() {
        return this.forward80To443;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public int getWriteTimeout() {
        return this.writeTimeout;
    }

    public int getMaximumLoginAttempts() {
        return this.maximumLoginAttempts;
    }

    public String getGoogleDeveloperKey() {
        return this.googleDeveloperKey;
    }

    public boolean isEnableOAuthServiceProvider() {
        return this.enableOAuthServiceProvider;
    }

    public boolean isEnableIncomingWebhooks() {
        return this.enableIncomingWebhooks;
    }

    public boolean isEnableOutgoingWebhooks() {
        return this.enableOutgoingWebhooks;
    }

    public boolean isEnableCommands() {
        return this.enableCommands;
    }

    public boolean isEnableOnlyAdminIntegrations() {
        return this.enableOnlyAdminIntegrations;
    }

    public boolean isEnablePostUsernameOverride() {
        return this.enablePostUsernameOverride;
    }

    public boolean isEnablePostIconOverride() {
        return this.enablePostIconOverride;
    }

    public boolean isEnableLinkPreviews() {
        return this.enableLinkPreviews;
    }

    public boolean isEnableTesting() {
        return this.enableTesting;
    }

    public boolean isEnableDeveloper() {
        return this.enableDeveloper;
    }

    public boolean isEnableSecurityFixAlert() {
        return this.enableSecurityFixAlert;
    }

    public boolean isEnableInsecureOutgoingConnections() {
        return this.enableInsecureOutgoingConnections;
    }

    public boolean isEnableMultifactorAuthentication() {
        return this.enableMultifactorAuthentication;
    }

    public boolean isEnforceMultifactorAuthentication() {
        return this.enforceMultifactorAuthentication;
    }

    public String getAllowCorsFrom() {
        return this.allowCorsFrom;
    }

    public int getSessionLengthWebInDays() {
        return this.sessionLengthWebInDays;
    }

    public int getSessionLengthMobileInDays() {
        return this.sessionLengthMobileInDays;
    }

    public int getSessionLengthSsoInDays() {
        return this.sessionLengthSsoInDays;
    }

    public int getSessionCacheInMinutes() {
        return this.sessionCacheInMinutes;
    }

    public int getWebsocketSecurePort() {
        return this.websocketSecurePort;
    }

    public int getWebsocketPort() {
        return this.websocketPort;
    }

    public WebServerMode getWebServerMode() {
        return this.webServerMode;
    }

    public boolean isEnableCustomEmoji() {
        return this.enableCustomEmoji;
    }

    public RestrictEmojiCreation getRestrictCustomEmojiCreation() {
        return this.restrictCustomEmojiCreation;
    }

    public PermissionsDeletePost getRestrictPostDelete() {
        return this.restrictPostDelete;
    }

    public AllowEditPost getAllowEditPost() {
        return this.allowEditPost;
    }

    public int getPostEditTimeLimit() {
        return this.postEditTimeLimit;
    }

    public long getTimeBetweenUserTypingUpdatesMilliseconds() {
        return this.timeBetweenUserTypingUpdatesMilliseconds;
    }

    public boolean isEnablePostSearch() {
        return this.enablePostSearch;
    }

    public boolean isEnableUserTypingMessages() {
        return this.enableUserTypingMessages;
    }

    public boolean isEnableUserStatuses() {
        return this.enableUserStatuses;
    }

    public int getClusterLogTimeoutMilliseconds() {
        return this.clusterLogTimeoutMilliseconds;
    }

    public int getGoroutineHealthThreshold() {
        return this.goroutineHealthThreshold;
    }

    public boolean isEnableEmojiPicker() {
        return this.enableEmojiPicker;
    }

    public boolean isEnableChannelViewedMessages() {
        return this.enableChannelViewedMessages;
    }

    public boolean isEnableApiv3() {
        return this.enableApiv3;
    }

    public boolean isEnableUserAccessTokens() {
        return this.enableUserAccessTokens;
    }

    public String getAllowedUntrustedInternalConnections() {
        return this.allowedUntrustedInternalConnections;
    }

    public int getSessionIdleTimeoutInMinutes() {
        return this.sessionIdleTimeoutInMinutes;
    }

    public boolean isCloseUnusedDirectMessages() {
        return this.closeUnusedDirectMessages;
    }

    public boolean isEnablePreviewFeatures() {
        return this.enablePreviewFeatures;
    }

    public boolean isExperimentalEnableAuthenticationTransfer() {
        return this.experimentalEnableAuthenticationTransfer;
    }

    public boolean isEnableTutorial() {
        return this.enableTutorial;
    }

    public ImageProxyType getImageProxyType() {
        return this.imageProxyType;
    }

    public String getImageProxyOptions() {
        return this.imageProxyOptions;
    }

    public String getImageProxyUrl() {
        return this.imageProxyUrl;
    }

    public GroupUnreadChannels getExperimentalGroupUnreadChannels() {
        return this.experimentalGroupUnreadChannels;
    }

    public boolean isExperimentalEnableDefaultChannelLeaveJoinMessages() {
        return this.experimentalEnableDefaultChannelLeaveJoinMessages;
    }

    public boolean isAllowCookiesForSubdomains() {
        return this.allowCookiesForSubdomains;
    }

    public String getWebsocketUrl() {
        return this.websocketUrl;
    }

    public boolean isEnableEmailInvitations() {
        return this.enableEmailInvitations;
    }

    public boolean isEnableApiTeamDeletion() {
        return this.enableApiTeamDeletion;
    }

    public boolean isExperimentalEnableHardenedMode() {
        return this.experimentalEnableHardenedMode;
    }

    public boolean isEnableGifPicker() {
        return this.enableGifPicker;
    }

    public String getGfycatApiKey() {
        return this.gfycatApiKey;
    }

    public String getGfycatApiSecret() {
        return this.gfycatApiSecret;
    }

    public boolean isExperimentalLimitClientConfig() {
        return this.experimentalLimitClientConfig;
    }

    public String getCorsExposedHeaders() {
        return this.corsExposedHeaders;
    }

    public boolean isCorsAllowCredentials() {
        return this.corsAllowCredentials;
    }

    public boolean isCorsDebug() {
        return this.corsDebug;
    }

    public boolean isExperimentalChannelOrganization() {
        return this.experimentalChannelOrganization;
    }

    public String getTlsMinVer() {
        return this.tlsMinVer;
    }

    public boolean isTlsStrictTransport() {
        return this.tlsStrictTransport;
    }

    public long getTlsStrictTransportMaxAge() {
        return this.tlsStrictTransportMaxAge;
    }

    public List<String> getTlsOverwriteCiphers() {
        return this.tlsOverwriteCiphers;
    }

    public void setSiteUrl(String siteUrl) {
        this.siteUrl = siteUrl;
    }

    public void setLicenseFileLocation(String licenseFileLocation) {
        this.licenseFileLocation = licenseFileLocation;
    }

    public void setListenAddress(String listenAddress) {
        this.listenAddress = listenAddress;
    }

    public void setConnectionSecurity(ConnectionSecurity connectionSecurity) {
        this.connectionSecurity = connectionSecurity;
    }

    public void setTlsCertFile(String tlsCertFile) {
        this.tlsCertFile = tlsCertFile;
    }

    public void setTlsKeyFile(String tlsKeyFile) {
        this.tlsKeyFile = tlsKeyFile;
    }

    public void setUseLetsEncrypt(boolean useLetsEncrypt) {
        this.useLetsEncrypt = useLetsEncrypt;
    }

    public void setLetsEncryptCertificateCacheFile(String letsEncryptCertificateCacheFile) {
        this.letsEncryptCertificateCacheFile = letsEncryptCertificateCacheFile;
    }

    public void setForward80To443(boolean forward80To443) {
        this.forward80To443 = forward80To443;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setWriteTimeout(int writeTimeout) {
        this.writeTimeout = writeTimeout;
    }

    public void setMaximumLoginAttempts(int maximumLoginAttempts) {
        this.maximumLoginAttempts = maximumLoginAttempts;
    }

    public void setGoogleDeveloperKey(String googleDeveloperKey) {
        this.googleDeveloperKey = googleDeveloperKey;
    }

    public void setEnableOAuthServiceProvider(boolean enableOAuthServiceProvider) {
        this.enableOAuthServiceProvider = enableOAuthServiceProvider;
    }

    public void setEnableIncomingWebhooks(boolean enableIncomingWebhooks) {
        this.enableIncomingWebhooks = enableIncomingWebhooks;
    }

    public void setEnableOutgoingWebhooks(boolean enableOutgoingWebhooks) {
        this.enableOutgoingWebhooks = enableOutgoingWebhooks;
    }

    public void setEnableCommands(boolean enableCommands) {
        this.enableCommands = enableCommands;
    }

    public void setEnableOnlyAdminIntegrations(boolean enableOnlyAdminIntegrations) {
        this.enableOnlyAdminIntegrations = enableOnlyAdminIntegrations;
    }

    public void setEnablePostUsernameOverride(boolean enablePostUsernameOverride) {
        this.enablePostUsernameOverride = enablePostUsernameOverride;
    }

    public void setEnablePostIconOverride(boolean enablePostIconOverride) {
        this.enablePostIconOverride = enablePostIconOverride;
    }

    public void setEnableLinkPreviews(boolean enableLinkPreviews) {
        this.enableLinkPreviews = enableLinkPreviews;
    }

    public void setEnableTesting(boolean enableTesting) {
        this.enableTesting = enableTesting;
    }

    public void setEnableDeveloper(boolean enableDeveloper) {
        this.enableDeveloper = enableDeveloper;
    }

    public void setEnableSecurityFixAlert(boolean enableSecurityFixAlert) {
        this.enableSecurityFixAlert = enableSecurityFixAlert;
    }

    public void setEnableInsecureOutgoingConnections(boolean enableInsecureOutgoingConnections) {
        this.enableInsecureOutgoingConnections = enableInsecureOutgoingConnections;
    }

    public void setEnableMultifactorAuthentication(boolean enableMultifactorAuthentication) {
        this.enableMultifactorAuthentication = enableMultifactorAuthentication;
    }

    public void setEnforceMultifactorAuthentication(boolean enforceMultifactorAuthentication) {
        this.enforceMultifactorAuthentication = enforceMultifactorAuthentication;
    }

    public void setAllowCorsFrom(String allowCorsFrom) {
        this.allowCorsFrom = allowCorsFrom;
    }

    public void setSessionLengthWebInDays(int sessionLengthWebInDays) {
        this.sessionLengthWebInDays = sessionLengthWebInDays;
    }

    public void setSessionLengthMobileInDays(int sessionLengthMobileInDays) {
        this.sessionLengthMobileInDays = sessionLengthMobileInDays;
    }

    public void setSessionLengthSsoInDays(int sessionLengthSsoInDays) {
        this.sessionLengthSsoInDays = sessionLengthSsoInDays;
    }

    public void setSessionCacheInMinutes(int sessionCacheInMinutes) {
        this.sessionCacheInMinutes = sessionCacheInMinutes;
    }

    public void setWebsocketSecurePort(int websocketSecurePort) {
        this.websocketSecurePort = websocketSecurePort;
    }

    public void setWebsocketPort(int websocketPort) {
        this.websocketPort = websocketPort;
    }

    public void setWebServerMode(WebServerMode webServerMode) {
        this.webServerMode = webServerMode;
    }

    public void setEnableCustomEmoji(boolean enableCustomEmoji) {
        this.enableCustomEmoji = enableCustomEmoji;
    }

    public void setRestrictCustomEmojiCreation(RestrictEmojiCreation restrictCustomEmojiCreation) {
        this.restrictCustomEmojiCreation = restrictCustomEmojiCreation;
    }

    public void setRestrictPostDelete(PermissionsDeletePost restrictPostDelete) {
        this.restrictPostDelete = restrictPostDelete;
    }

    public void setAllowEditPost(AllowEditPost allowEditPost) {
        this.allowEditPost = allowEditPost;
    }

    public void setPostEditTimeLimit(int postEditTimeLimit) {
        this.postEditTimeLimit = postEditTimeLimit;
    }

    public void setTimeBetweenUserTypingUpdatesMilliseconds(long timeBetweenUserTypingUpdatesMilliseconds) {
        this.timeBetweenUserTypingUpdatesMilliseconds = timeBetweenUserTypingUpdatesMilliseconds;
    }

    public void setEnablePostSearch(boolean enablePostSearch) {
        this.enablePostSearch = enablePostSearch;
    }

    public void setEnableUserTypingMessages(boolean enableUserTypingMessages) {
        this.enableUserTypingMessages = enableUserTypingMessages;
    }

    public void setEnableUserStatuses(boolean enableUserStatuses) {
        this.enableUserStatuses = enableUserStatuses;
    }

    public void setClusterLogTimeoutMilliseconds(int clusterLogTimeoutMilliseconds) {
        this.clusterLogTimeoutMilliseconds = clusterLogTimeoutMilliseconds;
    }

    public void setGoroutineHealthThreshold(int goroutineHealthThreshold) {
        this.goroutineHealthThreshold = goroutineHealthThreshold;
    }

    public void setEnableEmojiPicker(boolean enableEmojiPicker) {
        this.enableEmojiPicker = enableEmojiPicker;
    }

    public void setEnableChannelViewedMessages(boolean enableChannelViewedMessages) {
        this.enableChannelViewedMessages = enableChannelViewedMessages;
    }

    public void setEnableApiv3(boolean enableApiv3) {
        this.enableApiv3 = enableApiv3;
    }

    public void setEnableUserAccessTokens(boolean enableUserAccessTokens) {
        this.enableUserAccessTokens = enableUserAccessTokens;
    }

    public void setAllowedUntrustedInternalConnections(String allowedUntrustedInternalConnections) {
        this.allowedUntrustedInternalConnections = allowedUntrustedInternalConnections;
    }

    public void setSessionIdleTimeoutInMinutes(int sessionIdleTimeoutInMinutes) {
        this.sessionIdleTimeoutInMinutes = sessionIdleTimeoutInMinutes;
    }

    public void setCloseUnusedDirectMessages(boolean closeUnusedDirectMessages) {
        this.closeUnusedDirectMessages = closeUnusedDirectMessages;
    }

    public void setEnablePreviewFeatures(boolean enablePreviewFeatures) {
        this.enablePreviewFeatures = enablePreviewFeatures;
    }

    public void setExperimentalEnableAuthenticationTransfer(boolean experimentalEnableAuthenticationTransfer) {
        this.experimentalEnableAuthenticationTransfer = experimentalEnableAuthenticationTransfer;
    }

    public void setEnableTutorial(boolean enableTutorial) {
        this.enableTutorial = enableTutorial;
    }

    public void setImageProxyType(ImageProxyType imageProxyType) {
        this.imageProxyType = imageProxyType;
    }

    public void setImageProxyOptions(String imageProxyOptions) {
        this.imageProxyOptions = imageProxyOptions;
    }

    public void setImageProxyUrl(String imageProxyUrl) {
        this.imageProxyUrl = imageProxyUrl;
    }

    public void setExperimentalGroupUnreadChannels(GroupUnreadChannels experimentalGroupUnreadChannels) {
        this.experimentalGroupUnreadChannels = experimentalGroupUnreadChannels;
    }

    public void setExperimentalEnableDefaultChannelLeaveJoinMessages(boolean experimentalEnableDefaultChannelLeaveJoinMessages) {
        this.experimentalEnableDefaultChannelLeaveJoinMessages = experimentalEnableDefaultChannelLeaveJoinMessages;
    }

    public void setAllowCookiesForSubdomains(boolean allowCookiesForSubdomains) {
        this.allowCookiesForSubdomains = allowCookiesForSubdomains;
    }

    public void setWebsocketUrl(String websocketUrl) {
        this.websocketUrl = websocketUrl;
    }

    public void setEnableEmailInvitations(boolean enableEmailInvitations) {
        this.enableEmailInvitations = enableEmailInvitations;
    }

    public void setEnableApiTeamDeletion(boolean enableApiTeamDeletion) {
        this.enableApiTeamDeletion = enableApiTeamDeletion;
    }

    public void setExperimentalEnableHardenedMode(boolean experimentalEnableHardenedMode) {
        this.experimentalEnableHardenedMode = experimentalEnableHardenedMode;
    }

    public void setEnableGifPicker(boolean enableGifPicker) {
        this.enableGifPicker = enableGifPicker;
    }

    public void setGfycatApiKey(String gfycatApiKey) {
        this.gfycatApiKey = gfycatApiKey;
    }

    public void setGfycatApiSecret(String gfycatApiSecret) {
        this.gfycatApiSecret = gfycatApiSecret;
    }

    public void setExperimentalLimitClientConfig(boolean experimentalLimitClientConfig) {
        this.experimentalLimitClientConfig = experimentalLimitClientConfig;
    }

    public void setCorsExposedHeaders(String corsExposedHeaders) {
        this.corsExposedHeaders = corsExposedHeaders;
    }

    public void setCorsAllowCredentials(boolean corsAllowCredentials) {
        this.corsAllowCredentials = corsAllowCredentials;
    }

    public void setCorsDebug(boolean corsDebug) {
        this.corsDebug = corsDebug;
    }

    public void setExperimentalChannelOrganization(boolean experimentalChannelOrganization) {
        this.experimentalChannelOrganization = experimentalChannelOrganization;
    }

    public void setTlsMinVer(String tlsMinVer) {
        this.tlsMinVer = tlsMinVer;
    }

    public void setTlsStrictTransport(boolean tlsStrictTransport) {
        this.tlsStrictTransport = tlsStrictTransport;
    }

    public void setTlsStrictTransportMaxAge(long tlsStrictTransportMaxAge) {
        this.tlsStrictTransportMaxAge = tlsStrictTransportMaxAge;
    }

    public void setTlsOverwriteCiphers(List<String> tlsOverwriteCiphers) {
        this.tlsOverwriteCiphers = tlsOverwriteCiphers;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServiceSettings)) {
            return false;
        }
        ServiceSettings other = (ServiceSettings)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$siteUrl = this.getSiteUrl();
        String other$siteUrl = other.getSiteUrl();
        if (this$siteUrl == null ? other$siteUrl != null : !this$siteUrl.equals(other$siteUrl)) {
            return false;
        }
        String this$licenseFileLocation = this.getLicenseFileLocation();
        String other$licenseFileLocation = other.getLicenseFileLocation();
        if (this$licenseFileLocation == null ? other$licenseFileLocation != null : !this$licenseFileLocation.equals(other$licenseFileLocation)) {
            return false;
        }
        String this$listenAddress = this.getListenAddress();
        String other$listenAddress = other.getListenAddress();
        if (this$listenAddress == null ? other$listenAddress != null : !this$listenAddress.equals(other$listenAddress)) {
            return false;
        }
        ConnectionSecurity this$connectionSecurity = this.getConnectionSecurity();
        ConnectionSecurity other$connectionSecurity = other.getConnectionSecurity();
        if (this$connectionSecurity == null ? other$connectionSecurity != null : !this$connectionSecurity.equals(other$connectionSecurity)) {
            return false;
        }
        String this$tlsCertFile = this.getTlsCertFile();
        String other$tlsCertFile = other.getTlsCertFile();
        if (this$tlsCertFile == null ? other$tlsCertFile != null : !this$tlsCertFile.equals(other$tlsCertFile)) {
            return false;
        }
        String this$tlsKeyFile = this.getTlsKeyFile();
        String other$tlsKeyFile = other.getTlsKeyFile();
        if (this$tlsKeyFile == null ? other$tlsKeyFile != null : !this$tlsKeyFile.equals(other$tlsKeyFile)) {
            return false;
        }
        if (this.isUseLetsEncrypt() != other.isUseLetsEncrypt()) {
            return false;
        }
        String this$letsEncryptCertificateCacheFile = this.getLetsEncryptCertificateCacheFile();
        String other$letsEncryptCertificateCacheFile = other.getLetsEncryptCertificateCacheFile();
        if (this$letsEncryptCertificateCacheFile == null ? other$letsEncryptCertificateCacheFile != null : !this$letsEncryptCertificateCacheFile.equals(other$letsEncryptCertificateCacheFile)) {
            return false;
        }
        if (this.isForward80To443() != other.isForward80To443()) {
            return false;
        }
        if (this.getReadTimeout() != other.getReadTimeout()) {
            return false;
        }
        if (this.getWriteTimeout() != other.getWriteTimeout()) {
            return false;
        }
        if (this.getMaximumLoginAttempts() != other.getMaximumLoginAttempts()) {
            return false;
        }
        String this$googleDeveloperKey = this.getGoogleDeveloperKey();
        String other$googleDeveloperKey = other.getGoogleDeveloperKey();
        if (this$googleDeveloperKey == null ? other$googleDeveloperKey != null : !this$googleDeveloperKey.equals(other$googleDeveloperKey)) {
            return false;
        }
        if (this.isEnableOAuthServiceProvider() != other.isEnableOAuthServiceProvider()) {
            return false;
        }
        if (this.isEnableIncomingWebhooks() != other.isEnableIncomingWebhooks()) {
            return false;
        }
        if (this.isEnableOutgoingWebhooks() != other.isEnableOutgoingWebhooks()) {
            return false;
        }
        if (this.isEnableCommands() != other.isEnableCommands()) {
            return false;
        }
        if (this.isEnableOnlyAdminIntegrations() != other.isEnableOnlyAdminIntegrations()) {
            return false;
        }
        if (this.isEnablePostUsernameOverride() != other.isEnablePostUsernameOverride()) {
            return false;
        }
        if (this.isEnablePostIconOverride() != other.isEnablePostIconOverride()) {
            return false;
        }
        if (this.isEnableLinkPreviews() != other.isEnableLinkPreviews()) {
            return false;
        }
        if (this.isEnableTesting() != other.isEnableTesting()) {
            return false;
        }
        if (this.isEnableDeveloper() != other.isEnableDeveloper()) {
            return false;
        }
        if (this.isEnableSecurityFixAlert() != other.isEnableSecurityFixAlert()) {
            return false;
        }
        if (this.isEnableInsecureOutgoingConnections() != other.isEnableInsecureOutgoingConnections()) {
            return false;
        }
        if (this.isEnableMultifactorAuthentication() != other.isEnableMultifactorAuthentication()) {
            return false;
        }
        if (this.isEnforceMultifactorAuthentication() != other.isEnforceMultifactorAuthentication()) {
            return false;
        }
        String this$allowCorsFrom = this.getAllowCorsFrom();
        String other$allowCorsFrom = other.getAllowCorsFrom();
        if (this$allowCorsFrom == null ? other$allowCorsFrom != null : !this$allowCorsFrom.equals(other$allowCorsFrom)) {
            return false;
        }
        if (this.getSessionLengthWebInDays() != other.getSessionLengthWebInDays()) {
            return false;
        }
        if (this.getSessionLengthMobileInDays() != other.getSessionLengthMobileInDays()) {
            return false;
        }
        if (this.getSessionLengthSsoInDays() != other.getSessionLengthSsoInDays()) {
            return false;
        }
        if (this.getSessionCacheInMinutes() != other.getSessionCacheInMinutes()) {
            return false;
        }
        if (this.getWebsocketSecurePort() != other.getWebsocketSecurePort()) {
            return false;
        }
        if (this.getWebsocketPort() != other.getWebsocketPort()) {
            return false;
        }
        WebServerMode this$webServerMode = this.getWebServerMode();
        WebServerMode other$webServerMode = other.getWebServerMode();
        if (this$webServerMode == null ? other$webServerMode != null : !this$webServerMode.equals(other$webServerMode)) {
            return false;
        }
        if (this.isEnableCustomEmoji() != other.isEnableCustomEmoji()) {
            return false;
        }
        RestrictEmojiCreation this$restrictCustomEmojiCreation = this.getRestrictCustomEmojiCreation();
        RestrictEmojiCreation other$restrictCustomEmojiCreation = other.getRestrictCustomEmojiCreation();
        if (this$restrictCustomEmojiCreation == null ? other$restrictCustomEmojiCreation != null : !this$restrictCustomEmojiCreation.equals(other$restrictCustomEmojiCreation)) {
            return false;
        }
        PermissionsDeletePost this$restrictPostDelete = this.getRestrictPostDelete();
        PermissionsDeletePost other$restrictPostDelete = other.getRestrictPostDelete();
        if (this$restrictPostDelete == null ? other$restrictPostDelete != null : !this$restrictPostDelete.equals(other$restrictPostDelete)) {
            return false;
        }
        AllowEditPost this$allowEditPost = this.getAllowEditPost();
        AllowEditPost other$allowEditPost = other.getAllowEditPost();
        if (this$allowEditPost == null ? other$allowEditPost != null : !this$allowEditPost.equals(other$allowEditPost)) {
            return false;
        }
        if (this.getPostEditTimeLimit() != other.getPostEditTimeLimit()) {
            return false;
        }
        if (this.getTimeBetweenUserTypingUpdatesMilliseconds() != other.getTimeBetweenUserTypingUpdatesMilliseconds()) {
            return false;
        }
        if (this.isEnablePostSearch() != other.isEnablePostSearch()) {
            return false;
        }
        if (this.isEnableUserTypingMessages() != other.isEnableUserTypingMessages()) {
            return false;
        }
        if (this.isEnableUserStatuses() != other.isEnableUserStatuses()) {
            return false;
        }
        if (this.getClusterLogTimeoutMilliseconds() != other.getClusterLogTimeoutMilliseconds()) {
            return false;
        }
        if (this.getGoroutineHealthThreshold() != other.getGoroutineHealthThreshold()) {
            return false;
        }
        if (this.isEnableEmojiPicker() != other.isEnableEmojiPicker()) {
            return false;
        }
        if (this.isEnableChannelViewedMessages() != other.isEnableChannelViewedMessages()) {
            return false;
        }
        if (this.isEnableApiv3() != other.isEnableApiv3()) {
            return false;
        }
        if (this.isEnableUserAccessTokens() != other.isEnableUserAccessTokens()) {
            return false;
        }
        String this$allowedUntrustedInternalConnections = this.getAllowedUntrustedInternalConnections();
        String other$allowedUntrustedInternalConnections = other.getAllowedUntrustedInternalConnections();
        if (this$allowedUntrustedInternalConnections == null ? other$allowedUntrustedInternalConnections != null : !this$allowedUntrustedInternalConnections.equals(other$allowedUntrustedInternalConnections)) {
            return false;
        }
        if (this.getSessionIdleTimeoutInMinutes() != other.getSessionIdleTimeoutInMinutes()) {
            return false;
        }
        if (this.isCloseUnusedDirectMessages() != other.isCloseUnusedDirectMessages()) {
            return false;
        }
        if (this.isEnablePreviewFeatures() != other.isEnablePreviewFeatures()) {
            return false;
        }
        if (this.isExperimentalEnableAuthenticationTransfer() != other.isExperimentalEnableAuthenticationTransfer()) {
            return false;
        }
        if (this.isEnableTutorial() != other.isEnableTutorial()) {
            return false;
        }
        ImageProxyType this$imageProxyType = this.getImageProxyType();
        ImageProxyType other$imageProxyType = other.getImageProxyType();
        if (this$imageProxyType == null ? other$imageProxyType != null : !this$imageProxyType.equals(other$imageProxyType)) {
            return false;
        }
        String this$imageProxyOptions = this.getImageProxyOptions();
        String other$imageProxyOptions = other.getImageProxyOptions();
        if (this$imageProxyOptions == null ? other$imageProxyOptions != null : !this$imageProxyOptions.equals(other$imageProxyOptions)) {
            return false;
        }
        String this$imageProxyUrl = this.getImageProxyUrl();
        String other$imageProxyUrl = other.getImageProxyUrl();
        if (this$imageProxyUrl == null ? other$imageProxyUrl != null : !this$imageProxyUrl.equals(other$imageProxyUrl)) {
            return false;
        }
        GroupUnreadChannels this$experimentalGroupUnreadChannels = this.getExperimentalGroupUnreadChannels();
        GroupUnreadChannels other$experimentalGroupUnreadChannels = other.getExperimentalGroupUnreadChannels();
        if (this$experimentalGroupUnreadChannels == null ? other$experimentalGroupUnreadChannels != null : !this$experimentalGroupUnreadChannels.equals(other$experimentalGroupUnreadChannels)) {
            return false;
        }
        if (this.isExperimentalEnableDefaultChannelLeaveJoinMessages() != other.isExperimentalEnableDefaultChannelLeaveJoinMessages()) {
            return false;
        }
        if (this.isAllowCookiesForSubdomains() != other.isAllowCookiesForSubdomains()) {
            return false;
        }
        String this$websocketUrl = this.getWebsocketUrl();
        String other$websocketUrl = other.getWebsocketUrl();
        if (this$websocketUrl == null ? other$websocketUrl != null : !this$websocketUrl.equals(other$websocketUrl)) {
            return false;
        }
        if (this.isEnableEmailInvitations() != other.isEnableEmailInvitations()) {
            return false;
        }
        if (this.isEnableApiTeamDeletion() != other.isEnableApiTeamDeletion()) {
            return false;
        }
        if (this.isExperimentalEnableHardenedMode() != other.isExperimentalEnableHardenedMode()) {
            return false;
        }
        if (this.isEnableGifPicker() != other.isEnableGifPicker()) {
            return false;
        }
        String this$gfycatApiKey = this.getGfycatApiKey();
        String other$gfycatApiKey = other.getGfycatApiKey();
        if (this$gfycatApiKey == null ? other$gfycatApiKey != null : !this$gfycatApiKey.equals(other$gfycatApiKey)) {
            return false;
        }
        String this$gfycatApiSecret = this.getGfycatApiSecret();
        String other$gfycatApiSecret = other.getGfycatApiSecret();
        if (this$gfycatApiSecret == null ? other$gfycatApiSecret != null : !this$gfycatApiSecret.equals(other$gfycatApiSecret)) {
            return false;
        }
        if (this.isExperimentalLimitClientConfig() != other.isExperimentalLimitClientConfig()) {
            return false;
        }
        String this$corsExposedHeaders = this.getCorsExposedHeaders();
        String other$corsExposedHeaders = other.getCorsExposedHeaders();
        if (this$corsExposedHeaders == null ? other$corsExposedHeaders != null : !this$corsExposedHeaders.equals(other$corsExposedHeaders)) {
            return false;
        }
        if (this.isCorsAllowCredentials() != other.isCorsAllowCredentials()) {
            return false;
        }
        if (this.isCorsDebug() != other.isCorsDebug()) {
            return false;
        }
        if (this.isExperimentalChannelOrganization() != other.isExperimentalChannelOrganization()) {
            return false;
        }
        String this$tlsMinVer = this.getTlsMinVer();
        String other$tlsMinVer = other.getTlsMinVer();
        if (this$tlsMinVer == null ? other$tlsMinVer != null : !this$tlsMinVer.equals(other$tlsMinVer)) {
            return false;
        }
        if (this.isTlsStrictTransport() != other.isTlsStrictTransport()) {
            return false;
        }
        if (this.getTlsStrictTransportMaxAge() != other.getTlsStrictTransportMaxAge()) {
            return false;
        }
        List<String> this$tlsOverwriteCiphers = this.getTlsOverwriteCiphers();
        List<String> other$tlsOverwriteCiphers = other.getTlsOverwriteCiphers();
        return !(this$tlsOverwriteCiphers == null ? other$tlsOverwriteCiphers != null : !((Object)this$tlsOverwriteCiphers).equals(other$tlsOverwriteCiphers));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServiceSettings;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $siteUrl = this.getSiteUrl();
        result = result * 59 + ($siteUrl == null ? 43 : $siteUrl.hashCode());
        String $licenseFileLocation = this.getLicenseFileLocation();
        result = result * 59 + ($licenseFileLocation == null ? 43 : $licenseFileLocation.hashCode());
        String $listenAddress = this.getListenAddress();
        result = result * 59 + ($listenAddress == null ? 43 : $listenAddress.hashCode());
        ConnectionSecurity $connectionSecurity = this.getConnectionSecurity();
        result = result * 59 + ($connectionSecurity == null ? 43 : $connectionSecurity.hashCode());
        String $tlsCertFile = this.getTlsCertFile();
        result = result * 59 + ($tlsCertFile == null ? 43 : $tlsCertFile.hashCode());
        String $tlsKeyFile = this.getTlsKeyFile();
        result = result * 59 + ($tlsKeyFile == null ? 43 : $tlsKeyFile.hashCode());
        result = result * 59 + (this.isUseLetsEncrypt() ? 79 : 97);
        String $letsEncryptCertificateCacheFile = this.getLetsEncryptCertificateCacheFile();
        result = result * 59 + ($letsEncryptCertificateCacheFile == null ? 43 : $letsEncryptCertificateCacheFile.hashCode());
        result = result * 59 + (this.isForward80To443() ? 79 : 97);
        result = result * 59 + this.getReadTimeout();
        result = result * 59 + this.getWriteTimeout();
        result = result * 59 + this.getMaximumLoginAttempts();
        String $googleDeveloperKey = this.getGoogleDeveloperKey();
        result = result * 59 + ($googleDeveloperKey == null ? 43 : $googleDeveloperKey.hashCode());
        result = result * 59 + (this.isEnableOAuthServiceProvider() ? 79 : 97);
        result = result * 59 + (this.isEnableIncomingWebhooks() ? 79 : 97);
        result = result * 59 + (this.isEnableOutgoingWebhooks() ? 79 : 97);
        result = result * 59 + (this.isEnableCommands() ? 79 : 97);
        result = result * 59 + (this.isEnableOnlyAdminIntegrations() ? 79 : 97);
        result = result * 59 + (this.isEnablePostUsernameOverride() ? 79 : 97);
        result = result * 59 + (this.isEnablePostIconOverride() ? 79 : 97);
        result = result * 59 + (this.isEnableLinkPreviews() ? 79 : 97);
        result = result * 59 + (this.isEnableTesting() ? 79 : 97);
        result = result * 59 + (this.isEnableDeveloper() ? 79 : 97);
        result = result * 59 + (this.isEnableSecurityFixAlert() ? 79 : 97);
        result = result * 59 + (this.isEnableInsecureOutgoingConnections() ? 79 : 97);
        result = result * 59 + (this.isEnableMultifactorAuthentication() ? 79 : 97);
        result = result * 59 + (this.isEnforceMultifactorAuthentication() ? 79 : 97);
        String $allowCorsFrom = this.getAllowCorsFrom();
        result = result * 59 + ($allowCorsFrom == null ? 43 : $allowCorsFrom.hashCode());
        result = result * 59 + this.getSessionLengthWebInDays();
        result = result * 59 + this.getSessionLengthMobileInDays();
        result = result * 59 + this.getSessionLengthSsoInDays();
        result = result * 59 + this.getSessionCacheInMinutes();
        result = result * 59 + this.getWebsocketSecurePort();
        result = result * 59 + this.getWebsocketPort();
        WebServerMode $webServerMode = this.getWebServerMode();
        result = result * 59 + ($webServerMode == null ? 43 : $webServerMode.hashCode());
        result = result * 59 + (this.isEnableCustomEmoji() ? 79 : 97);
        RestrictEmojiCreation $restrictCustomEmojiCreation = this.getRestrictCustomEmojiCreation();
        result = result * 59 + ($restrictCustomEmojiCreation == null ? 43 : $restrictCustomEmojiCreation.hashCode());
        PermissionsDeletePost $restrictPostDelete = this.getRestrictPostDelete();
        result = result * 59 + ($restrictPostDelete == null ? 43 : $restrictPostDelete.hashCode());
        AllowEditPost $allowEditPost = this.getAllowEditPost();
        result = result * 59 + ($allowEditPost == null ? 43 : $allowEditPost.hashCode());
        result = result * 59 + this.getPostEditTimeLimit();
        long $timeBetweenUserTypingUpdatesMilliseconds = this.getTimeBetweenUserTypingUpdatesMilliseconds();
        result = result * 59 + (int)($timeBetweenUserTypingUpdatesMilliseconds >>> 32 ^ $timeBetweenUserTypingUpdatesMilliseconds);
        result = result * 59 + (this.isEnablePostSearch() ? 79 : 97);
        result = result * 59 + (this.isEnableUserTypingMessages() ? 79 : 97);
        result = result * 59 + (this.isEnableUserStatuses() ? 79 : 97);
        result = result * 59 + this.getClusterLogTimeoutMilliseconds();
        result = result * 59 + this.getGoroutineHealthThreshold();
        result = result * 59 + (this.isEnableEmojiPicker() ? 79 : 97);
        result = result * 59 + (this.isEnableChannelViewedMessages() ? 79 : 97);
        result = result * 59 + (this.isEnableApiv3() ? 79 : 97);
        result = result * 59 + (this.isEnableUserAccessTokens() ? 79 : 97);
        String $allowedUntrustedInternalConnections = this.getAllowedUntrustedInternalConnections();
        result = result * 59 + ($allowedUntrustedInternalConnections == null ? 43 : $allowedUntrustedInternalConnections.hashCode());
        result = result * 59 + this.getSessionIdleTimeoutInMinutes();
        result = result * 59 + (this.isCloseUnusedDirectMessages() ? 79 : 97);
        result = result * 59 + (this.isEnablePreviewFeatures() ? 79 : 97);
        result = result * 59 + (this.isExperimentalEnableAuthenticationTransfer() ? 79 : 97);
        result = result * 59 + (this.isEnableTutorial() ? 79 : 97);
        ImageProxyType $imageProxyType = this.getImageProxyType();
        result = result * 59 + ($imageProxyType == null ? 43 : $imageProxyType.hashCode());
        String $imageProxyOptions = this.getImageProxyOptions();
        result = result * 59 + ($imageProxyOptions == null ? 43 : $imageProxyOptions.hashCode());
        String $imageProxyUrl = this.getImageProxyUrl();
        result = result * 59 + ($imageProxyUrl == null ? 43 : $imageProxyUrl.hashCode());
        GroupUnreadChannels $experimentalGroupUnreadChannels = this.getExperimentalGroupUnreadChannels();
        result = result * 59 + ($experimentalGroupUnreadChannels == null ? 43 : $experimentalGroupUnreadChannels.hashCode());
        result = result * 59 + (this.isExperimentalEnableDefaultChannelLeaveJoinMessages() ? 79 : 97);
        result = result * 59 + (this.isAllowCookiesForSubdomains() ? 79 : 97);
        String $websocketUrl = this.getWebsocketUrl();
        result = result * 59 + ($websocketUrl == null ? 43 : $websocketUrl.hashCode());
        result = result * 59 + (this.isEnableEmailInvitations() ? 79 : 97);
        result = result * 59 + (this.isEnableApiTeamDeletion() ? 79 : 97);
        result = result * 59 + (this.isExperimentalEnableHardenedMode() ? 79 : 97);
        result = result * 59 + (this.isEnableGifPicker() ? 79 : 97);
        String $gfycatApiKey = this.getGfycatApiKey();
        result = result * 59 + ($gfycatApiKey == null ? 43 : $gfycatApiKey.hashCode());
        String $gfycatApiSecret = this.getGfycatApiSecret();
        result = result * 59 + ($gfycatApiSecret == null ? 43 : $gfycatApiSecret.hashCode());
        result = result * 59 + (this.isExperimentalLimitClientConfig() ? 79 : 97);
        String $corsExposedHeaders = this.getCorsExposedHeaders();
        result = result * 59 + ($corsExposedHeaders == null ? 43 : $corsExposedHeaders.hashCode());
        result = result * 59 + (this.isCorsAllowCredentials() ? 79 : 97);
        result = result * 59 + (this.isCorsDebug() ? 79 : 97);
        result = result * 59 + (this.isExperimentalChannelOrganization() ? 79 : 97);
        String $tlsMinVer = this.getTlsMinVer();
        result = result * 59 + ($tlsMinVer == null ? 43 : $tlsMinVer.hashCode());
        result = result * 59 + (this.isTlsStrictTransport() ? 79 : 97);
        long $tlsStrictTransportMaxAge = this.getTlsStrictTransportMaxAge();
        result = result * 59 + (int)($tlsStrictTransportMaxAge >>> 32 ^ $tlsStrictTransportMaxAge);
        List<String> $tlsOverwriteCiphers = this.getTlsOverwriteCiphers();
        result = result * 59 + ($tlsOverwriteCiphers == null ? 43 : ((Object)$tlsOverwriteCiphers).hashCode());
        return result;
    }

    public String toString() {
        return "ServiceSettings(siteUrl=" + this.getSiteUrl() + ", licenseFileLocation=" + this.getLicenseFileLocation() + ", listenAddress=" + this.getListenAddress() + ", connectionSecurity=" + this.getConnectionSecurity() + ", tlsCertFile=" + this.getTlsCertFile() + ", tlsKeyFile=" + this.getTlsKeyFile() + ", useLetsEncrypt=" + this.isUseLetsEncrypt() + ", letsEncryptCertificateCacheFile=" + this.getLetsEncryptCertificateCacheFile() + ", forward80To443=" + this.isForward80To443() + ", readTimeout=" + this.getReadTimeout() + ", writeTimeout=" + this.getWriteTimeout() + ", maximumLoginAttempts=" + this.getMaximumLoginAttempts() + ", googleDeveloperKey=" + this.getGoogleDeveloperKey() + ", enableOAuthServiceProvider=" + this.isEnableOAuthServiceProvider() + ", enableIncomingWebhooks=" + this.isEnableIncomingWebhooks() + ", enableOutgoingWebhooks=" + this.isEnableOutgoingWebhooks() + ", enableCommands=" + this.isEnableCommands() + ", enableOnlyAdminIntegrations=" + this.isEnableOnlyAdminIntegrations() + ", enablePostUsernameOverride=" + this.isEnablePostUsernameOverride() + ", enablePostIconOverride=" + this.isEnablePostIconOverride() + ", enableLinkPreviews=" + this.isEnableLinkPreviews() + ", enableTesting=" + this.isEnableTesting() + ", enableDeveloper=" + this.isEnableDeveloper() + ", enableSecurityFixAlert=" + this.isEnableSecurityFixAlert() + ", enableInsecureOutgoingConnections=" + this.isEnableInsecureOutgoingConnections() + ", enableMultifactorAuthentication=" + this.isEnableMultifactorAuthentication() + ", enforceMultifactorAuthentication=" + this.isEnforceMultifactorAuthentication() + ", allowCorsFrom=" + this.getAllowCorsFrom() + ", sessionLengthWebInDays=" + this.getSessionLengthWebInDays() + ", sessionLengthMobileInDays=" + this.getSessionLengthMobileInDays() + ", sessionLengthSsoInDays=" + this.getSessionLengthSsoInDays() + ", sessionCacheInMinutes=" + this.getSessionCacheInMinutes() + ", websocketSecurePort=" + this.getWebsocketSecurePort() + ", websocketPort=" + this.getWebsocketPort() + ", webServerMode=" + this.getWebServerMode() + ", enableCustomEmoji=" + this.isEnableCustomEmoji() + ", restrictCustomEmojiCreation=" + this.getRestrictCustomEmojiCreation() + ", restrictPostDelete=" + this.getRestrictPostDelete() + ", allowEditPost=" + this.getAllowEditPost() + ", postEditTimeLimit=" + this.getPostEditTimeLimit() + ", timeBetweenUserTypingUpdatesMilliseconds=" + this.getTimeBetweenUserTypingUpdatesMilliseconds() + ", enablePostSearch=" + this.isEnablePostSearch() + ", enableUserTypingMessages=" + this.isEnableUserTypingMessages() + ", enableUserStatuses=" + this.isEnableUserStatuses() + ", clusterLogTimeoutMilliseconds=" + this.getClusterLogTimeoutMilliseconds() + ", goroutineHealthThreshold=" + this.getGoroutineHealthThreshold() + ", enableEmojiPicker=" + this.isEnableEmojiPicker() + ", enableChannelViewedMessages=" + this.isEnableChannelViewedMessages() + ", enableApiv3=" + this.isEnableApiv3() + ", enableUserAccessTokens=" + this.isEnableUserAccessTokens() + ", allowedUntrustedInternalConnections=" + this.getAllowedUntrustedInternalConnections() + ", sessionIdleTimeoutInMinutes=" + this.getSessionIdleTimeoutInMinutes() + ", closeUnusedDirectMessages=" + this.isCloseUnusedDirectMessages() + ", enablePreviewFeatures=" + this.isEnablePreviewFeatures() + ", experimentalEnableAuthenticationTransfer=" + this.isExperimentalEnableAuthenticationTransfer() + ", enableTutorial=" + this.isEnableTutorial() + ", imageProxyType=" + this.getImageProxyType() + ", imageProxyOptions=" + this.getImageProxyOptions() + ", imageProxyUrl=" + this.getImageProxyUrl() + ", experimentalGroupUnreadChannels=" + this.getExperimentalGroupUnreadChannels() + ", experimentalEnableDefaultChannelLeaveJoinMessages=" + this.isExperimentalEnableDefaultChannelLeaveJoinMessages() + ", allowCookiesForSubdomains=" + this.isAllowCookiesForSubdomains() + ", websocketUrl=" + this.getWebsocketUrl() + ", enableEmailInvitations=" + this.isEnableEmailInvitations() + ", enableApiTeamDeletion=" + this.isEnableApiTeamDeletion() + ", experimentalEnableHardenedMode=" + this.isExperimentalEnableHardenedMode() + ", enableGifPicker=" + this.isEnableGifPicker() + ", gfycatApiKey=" + this.getGfycatApiKey() + ", gfycatApiSecret=" + this.getGfycatApiSecret() + ", experimentalLimitClientConfig=" + this.isExperimentalLimitClientConfig() + ", corsExposedHeaders=" + this.getCorsExposedHeaders() + ", corsAllowCredentials=" + this.isCorsAllowCredentials() + ", corsDebug=" + this.isCorsDebug() + ", experimentalChannelOrganization=" + this.isExperimentalChannelOrganization() + ", tlsMinVer=" + this.getTlsMinVer() + ", tlsStrictTransport=" + this.isTlsStrictTransport() + ", tlsStrictTransportMaxAge=" + this.getTlsStrictTransportMaxAge() + ", tlsOverwriteCiphers=" + this.getTlsOverwriteCiphers() + ")";
    }
}

