/*
 * Decompiled with CFR 0.152.
 */
package net.bis5.mattermost.model;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import net.bis5.mattermost.model.HasCode;
import net.bis5.mattermost.model.serialize.HasCodeSerializer;

@JsonSerialize(using=HasCodeSerializer.class)
@JsonDeserialize(using=ComplianceStatusDeserializer.class)
public enum ComplianceStatus implements HasCode<ComplianceStatus>
{
    Created("created"),
    Running("running"),
    Finished("finished"),
    Failed("failed"),
    Removed("removed");

    private final String code;

    private ComplianceStatus(String code) {
        this.code = code;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    public static ComplianceStatus of(String code) {
        return Arrays.asList(ComplianceStatus.values()).stream().filter(s -> s.getCode().equals(code)).findFirst().orElse(null);
    }

    public static class ComplianceStatusDeserializer
    extends JsonDeserializer<ComplianceStatus> {
        public ComplianceStatus deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            String code = p.getText();
            return ComplianceStatus.of(code);
        }
    }
}

