/*
 * Decompiled with CFR 0.152.
 */
package net.bis5.mattermost.model.config.consts.saml;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import net.bis5.mattermost.model.HasCode;
import net.bis5.mattermost.model.serialize.HasCodeSerializer;

@JsonSerialize(using=HasCodeSerializer.class)
@JsonDeserialize(using=SignatureAlgorithmDeserializer.class)
public enum SignatureAlgorithm implements HasCode<SignatureAlgorithm>
{
    SHA1("RSAwithSHA1"),
    SHA256("RSAwithSHA256"),
    SHA512("RSAwithSHA512");

    private final String code;

    public static SignatureAlgorithm of(String code) {
        return Arrays.stream(SignatureAlgorithm.values()).filter(e -> e.getCode().equals(code)).findFirst().orElse(null);
    }

    private SignatureAlgorithm(String code) {
        this.code = code;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    public static class SignatureAlgorithmDeserializer
    extends JsonDeserializer<SignatureAlgorithm> {
        public SignatureAlgorithm deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            String jsonValue = p.getText();
            return SignatureAlgorithm.of(jsonValue);
        }
    }
}

