/*
 * Decompiled with CFR 0.152.
 */
package net.bis5.mattermost.model;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import net.bis5.mattermost.model.HasCode;
import net.bis5.mattermost.model.serialize.HasCodeSerializer;

@JsonSerialize(using=HasCodeSerializer.class)
@JsonDeserialize(using=ChannelTypeDeserializer.class)
public enum ChannelType implements HasCode<ChannelType>
{
    Open("O"),
    Private("P"),
    Direct("D"),
    Group("G");

    private final String code;

    private ChannelType(String code) {
        this.code = code;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    public static ChannelType of(String code) {
        for (ChannelType type : ChannelType.values()) {
            if (!type.getCode().equals(code)) continue;
            return type;
        }
        return null;
    }

    public static class ChannelTypeDeserializer
    extends JsonDeserializer<ChannelType> {
        public ChannelType deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            String jsonValue = p.getText();
            return ChannelType.of(jsonValue);
        }
    }
}

