/*
 * Decompiled with CFR 0.152.
 */
package net.bis5.mattermost.model.serialize;

import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import net.bis5.mattermost.model.Config;

public class MattermostPropertyNamingStrategy
extends PropertyNamingStrategy {
    public String nameForField(MapperConfig<?> config, AnnotatedField field, String defaultName) {
        return this.judgeStrategy((AnnotatedMember)field).nameForField(config, field, defaultName);
    }

    public String nameForGetterMethod(MapperConfig<?> config, AnnotatedMethod method, String defaultName) {
        return this.judgeStrategy((AnnotatedMember)method).nameForGetterMethod(config, method, defaultName);
    }

    public String nameForSetterMethod(MapperConfig<?> config, AnnotatedMethod method, String defaultName) {
        return this.judgeStrategy((AnnotatedMember)method).nameForSetterMethod(config, method, defaultName);
    }

    public String nameForConstructorParameter(MapperConfig<?> config, AnnotatedParameter ctorParam, String defaultName) {
        return this.judgeStrategy((AnnotatedMember)ctorParam).nameForConstructorParameter(config, ctorParam, defaultName);
    }

    protected PropertyNamingStrategy judgeStrategy(AnnotatedMember member) {
        Class clazz = member.getDeclaringClass();
        if (Config.class.isAssignableFrom(clazz)) {
            return PropertyNamingStrategy.UPPER_CAMEL_CASE;
        }
        if (clazz.getCanonicalName().startsWith("net.bis5.mattermost.model.config.")) {
            return PropertyNamingStrategy.UPPER_CAMEL_CASE;
        }
        return PropertyNamingStrategy.SNAKE_CASE;
    }
}

