/*
 * Decompiled with CFR 0.152.
 */
package net.bis5.mattermost.model;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import net.bis5.mattermost.model.HasCode;
import net.bis5.mattermost.model.serialize.HasCodeSerializer;

@JsonSerialize(using=HasCodeSerializer.class)
@JsonDeserialize(using=WebSocketEventTypeDeserializer.class)
public enum WebSocketEventType implements HasCode<WebSocketEventType>
{
    Typing("typing"),
    Posted("posted"),
    PostEdited("post_edited"),
    PostDeleted("post_deleted"),
    ChannelDeleted("channel_deleted"),
    ChannelCreated("channel_created"),
    DirectAdded("direct_added"),
    GroupAdded("group_added"),
    NewUser("new_user"),
    AddedToTeam("added_to_team"),
    LeaveTeam("leave_team"),
    UpdateTeam("update_team"),
    UserAdded("user_added"),
    UserUpdated("user_updated"),
    UserRemoved("user_removed"),
    PreferenceChanged("preference_changed"),
    PreferencesChanged("preferences_changed"),
    PreferencesDeleted("preferences_deleted"),
    EphemeralMessage("ephemeral_message"),
    StatusChange("status_change"),
    Hello("hello"),
    Webrtc("webrtc"),
    ReactionAdded("reaction_added"),
    ReactionRemoved("reaction_removed"),
    Response("response");

    private final String code;

    private WebSocketEventType(String code) {
        this.code = code;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    public static WebSocketEventType of(String code) {
        for (WebSocketEventType type : WebSocketEventType.values()) {
            if (!type.getCode().equals(code)) continue;
            return type;
        }
        return null;
    }

    public static class WebSocketEventTypeDeserializer
    extends JsonDeserializer<WebSocketEventType> {
        public WebSocketEventType deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            String code = p.getText();
            return WebSocketEventType.of(code);
        }
    }
}

