/*
 * Decompiled with CFR 0.152.
 */
package net.bis5.mattermost.model;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import net.bis5.mattermost.model.HasCode;
import net.bis5.mattermost.model.serialize.HasCodeSerializer;

@JsonSerialize(using=HasCodeSerializer.class)
@JsonDeserialize(using=PostEmbedTypeDeserializer.class)
public enum PostEmbedType implements HasCode<PostEmbedType>
{
    IMAGE("image"),
    MESSAGE_ATTACHMENT("message_attachment"),
    OPENGRAPH("opengraph");

    private final String code;

    public static PostEmbedType of(String type) {
        return Arrays.stream(PostEmbedType.values()).filter(t -> t.getCode().equals(type)).findFirst().orElse(null);
    }

    @Override
    public String getCode() {
        return this.code;
    }

    private PostEmbedType(String code) {
        this.code = code;
    }

    public static class PostEmbedTypeDeserializer
    extends JsonDeserializer<PostEmbedType> {
        public PostEmbedType deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            String code = p.getText();
            return PostEmbedType.of(code);
        }
    }
}

