/*
 * Decompiled with CFR 0.152.
 */
package net.bis5.mattermost.model.config.consts;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import net.bis5.mattermost.model.HasCode;
import net.bis5.mattermost.model.serialize.HasCodeSerializer;

@JsonSerialize(using=HasCodeSerializer.class)
@JsonDeserialize(using=PermissionsDeserializer.class)
public enum Permissions implements HasCode<Permissions>
{
    ALL("all"),
    CHANNEL_ADMIN("channel_admin"),
    TEAM_ADMIN("team_admin"),
    SYSTEM_ADMIN("system_admin");

    private final String code;

    private Permissions(String code) {
        this.code = code;
    }

    public static Permissions of(String code) {
        return Arrays.stream(Permissions.values()).filter(e -> e.getCode().equals(code)).findFirst().orElse(null);
    }

    @Override
    public String getCode() {
        return this.code;
    }

    public static class PermissionsDeserializer
    extends JsonDeserializer<Permissions> {
        public Permissions deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            String jsonValue = p.getText();
            return Permissions.of(jsonValue);
        }
    }
}

