/*
 * Decompiled with CFR 0.152.
 */
package net.bis5.mattermost.model;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import net.bis5.mattermost.model.HasCode;
import net.bis5.mattermost.model.serialize.HasCodeSerializer;

@JsonSerialize(using=HasCodeSerializer.class)
@JsonDeserialize(using=PushTypeDeserializer.class)
public enum PushType implements HasCode<PushType>
{
    MESSAGE("message"),
    CLEAR("clear");

    private final String code;

    private PushType(String code) {
        this.code = code;
    }

    public static PushType of(String code) {
        return Arrays.stream(PushType.values()).filter(e -> e.getCode().equals(code)).findFirst().orElse(null);
    }

    @Override
    public String getCode() {
        return this.code;
    }

    static class PushTypeDeserializer
    extends JsonDeserializer<PushType> {
        PushTypeDeserializer() {
        }

        public PushType deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            String jsonValue = p.getText();
            return PushType.of(jsonValue);
        }
    }
}

