/*
 * Decompiled with CFR 0.152.
 */
package net.bis5.mattermost.model;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import net.bis5.mattermost.model.HasCode;
import net.bis5.mattermost.model.serialize.HasCodeSerializer;

@JsonSerialize(using=HasCodeSerializer.class)
@JsonDeserialize(using=CommandMethodDeserializer.class)
public enum CommandMethod implements HasCode<CommandMethod>
{
    POST("P"),
    GET("G");

    private final String code;

    private CommandMethod(String code) {
        this.code = code;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    public static CommandMethod of(String code) {
        for (CommandMethod method : CommandMethod.values()) {
            if (!method.getCode().equals(code)) continue;
            return method;
        }
        return null;
    }

    public static class CommandMethodDeserializer
    extends JsonDeserializer<CommandMethod> {
        public CommandMethod deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            String code = p.getText();
            return CommandMethod.of(code);
        }
    }
}

