/*
 * Decompiled with CFR 0.152.
 */
package net.bis5.mattermost.model.config.consts.saml;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import net.bis5.mattermost.model.HasCode;
import net.bis5.mattermost.model.serialize.HasCodeSerializer;

@JsonSerialize(using=HasCodeSerializer.class)
@JsonDeserialize(using=CanonicalAlgorithmDeserializer.class)
public enum CanonicalAlgorithm implements HasCode<CanonicalAlgorithm>
{
    CANONICALIZATION("Canonical1.0"),
    CANONICALIZATION_11("Canonical1.1");

    private final String code;

    public static CanonicalAlgorithm of(String code) {
        return Arrays.stream(CanonicalAlgorithm.values()).filter(e -> e.getCode().equals(code)).findFirst().orElse(null);
    }

    @Override
    public String getCode() {
        return this.code;
    }

    private CanonicalAlgorithm(String code) {
        this.code = code;
    }

    public static class CanonicalAlgorithmDeserializer
    extends JsonDeserializer<CanonicalAlgorithm> {
        public CanonicalAlgorithm deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            String jsonValue = p.getText();
            return CanonicalAlgorithm.of(jsonValue);
        }
    }
}

