/*
 * Decompiled with CFR 0.152.
 */
package net.bis5.mattermost.model;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import net.bis5.mattermost.model.HasCode;
import net.bis5.mattermost.model.serialize.HasCodeSerializer;

@JsonSerialize(using=HasCodeSerializer.class)
@JsonDeserialize(using=PreferenceCategoryDeserializer.class)
public enum PreferenceCategory implements HasCode<PreferenceCategory>
{
    DIRECT_CHANNEL_SHOW("direct_channel_show"),
    TUTORIAL_STEPS("tutorial_step"),
    ADVANCED_SETTINGS("advanced_settings"),
    FLAGGED_POST("flagged_post"),
    DISPLAY_SETTINGS("display_settings"),
    THEME("theme"),
    AUTHORIZED_OAUTH_APP("oauth_app"),
    LAST("last"),
    NOTIFICATIONS("notifications");

    private final String code;

    private PreferenceCategory(String code) {
        this.code = code;
    }

    public static PreferenceCategory of(String code) {
        return Arrays.stream(PreferenceCategory.values()).filter(e -> e.getCode().equals(code)).findFirst().orElse(null);
    }

    @Override
    public String getCode() {
        return this.code;
    }

    static class PreferenceCategoryDeserializer
    extends JsonDeserializer<PreferenceCategory> {
        PreferenceCategoryDeserializer() {
        }

        public PreferenceCategory deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            String jsonValue = p.getText();
            return PreferenceCategory.of(jsonValue);
        }
    }
}

