/*
 * Decompiled with CFR 0.152.
 */
package net.bis5.mattermost.model.config.consts;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import net.bis5.mattermost.model.HasCode;
import net.bis5.mattermost.model.serialize.HasCodeSerializer;

@JsonSerialize(using=HasCodeSerializer.class)
@JsonDeserialize(using=WebServerModeDeserializer.class)
public enum WebServerMode implements HasCode<WebServerMode>
{
    REGULAR("regular"),
    GZIP("gzip"),
    DISABLED("disabled");

    private final String code;

    private WebServerMode(String code) {
        this.code = code;
    }

    public static WebServerMode of(String code) {
        return Arrays.stream(WebServerMode.values()).filter(e -> e.getCode().equals(code)).findFirst().orElse(REGULAR);
    }

    @Override
    public String getCode() {
        return this.code;
    }

    public static class WebServerModeDeserializer
    extends JsonDeserializer<WebServerMode> {
        public WebServerMode deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            String jsonValue = p.getText();
            return WebServerMode.of(jsonValue);
        }
    }
}

