/*
 * Decompiled with CFR 0.152.
 */
package net.bis5.mattermost.model;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import net.bis5.mattermost.model.HasCode;
import net.bis5.mattermost.model.serialize.HasCodeSerializer;

@JsonSerialize(using=HasCodeSerializer.class)
@JsonDeserialize(using=ContentTypeDeserializer.class)
public enum ContentType implements HasCode<ContentType>
{
    FORM("application/x-www-form-urlencoded"),
    JSON("application/json");

    private final String code;

    public static ContentType of(String code) {
        return Arrays.stream(ContentType.values()).filter(c -> c.getCode().equals(code)).findFirst().orElse(null);
    }

    @Override
    public String getCode() {
        return this.code;
    }

    private ContentType(String code) {
        this.code = code;
    }

    static class ContentTypeDeserializer
    extends JsonDeserializer<ContentType> {
        ContentTypeDeserializer() {
        }

        public ContentType deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            String jsonValue = p.getValueAsString();
            return ContentType.of(jsonValue);
        }
    }
}

