/*
 * Decompiled with CFR 0.152.
 */
package net.bis5.mattermost.model.config.consts;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import net.bis5.mattermost.model.HasCode;
import net.bis5.mattermost.model.serialize.HasCodeSerializer;

@JsonSerialize(using=HasCodeSerializer.class)
@JsonDeserialize(using=EmailNotificationContentDeserializer.class)
public enum EmailNotificationContent implements HasCode<EmailNotificationContent>
{
    FULL("full"),
    GENERIC("generic");

    private final String code;

    public static EmailNotificationContent of(String code) {
        return Arrays.stream(EmailNotificationContent.values()).filter(e -> e.getCode().equals(code)).findFirst().orElse(null);
    }

    @Override
    public String getCode() {
        return this.code;
    }

    private EmailNotificationContent(String code) {
        this.code = code;
    }

    static class EmailNotificationContentDeserializer
    extends JsonDeserializer<EmailNotificationContent> {
        EmailNotificationContentDeserializer() {
        }

        public EmailNotificationContent deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            String jsonValue = p.getValueAsString();
            return EmailNotificationContent.of(jsonValue);
        }
    }
}

