/*
 * Decompiled with CFR 0.152.
 */
package net.bis5.mattermost.model;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import net.bis5.mattermost.model.HasCode;
import net.bis5.mattermost.model.serialize.HasCodeSerializer;

@JsonSerialize(using=HasCodeSerializer.class)
@JsonDeserialize(using=TeamTypeDeserializer.class)
public enum TeamType implements HasCode<TeamType>
{
    OPEN("O"),
    INVITE("I");

    private final String code;

    private TeamType(String code) {
        this.code = code;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    static class TeamTypeDeserializer
    extends JsonDeserializer<TeamType> {
        TeamTypeDeserializer() {
        }

        public TeamType deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            String jsonValue = p.getText();
            return HasCode.of(TeamType::values, jsonValue, OPEN);
        }
    }
}

