/*
 * Decompiled with CFR 0.152.
 */
package net.bis5.mattermost.model;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import net.bis5.mattermost.model.HasCode;
import net.bis5.mattermost.model.serialize.HasCodeSerializer;

@JsonSerialize(using=HasCodeSerializer.class)
@JsonDeserialize(using=StatusTypeDeserializer.class)
public enum StatusType implements HasCode<StatusType>
{
    OFFLINE("offline"),
    AWAY("away"),
    ONLINE("online"),
    DND("dnd");

    private final String code;

    private StatusType(String code) {
        this.code = code;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    static class StatusTypeDeserializer
    extends JsonDeserializer<StatusType> {
        StatusTypeDeserializer() {
        }

        public StatusType deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            String jsonValue = p.getText();
            return HasCode.of(StatusType::values, jsonValue, OFFLINE);
        }
    }
}

