/*
 * Decompiled with CFR 0.152.
 */
package net.bis5.mattermost.model;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import net.bis5.mattermost.model.HasCode;
import net.bis5.mattermost.model.serialize.HasCodeSerializer;

@JsonSerialize(using=HasCodeSerializer.class)
@JsonDeserialize(using=PostTypeDeserializer.class)
public enum PostType implements HasCode<PostType>
{
    DEFAULT(""),
    SLACK_ATTACHMENT("slack_attachment"),
    SYSTEM_GENERIC("system_generic"),
    JOIN_LEAVE("system_join_leave"),
    JOIN_CHANNEL("system_join_channel"),
    LEAVE_CHANNEL("system_leave_channel"),
    ADD_REMOVE("system_add_remove"),
    ADD_TO_CHANNEL("system_add_to_channel"),
    REMOVE_FROM_CHANNEL("system_remove_from_channel"),
    HEADER_CHANGE("system_header_change"),
    DISPLAYNAME_CHANGE("system_displayname_change"),
    PURPOSE_CHANGE("system_purpose_change"),
    CHANNEL_DELETED("system_channel_deleted"),
    EPHEMERAL("system_ephemeral"),
    JOIN_TEAM("system_join_team"),
    LEAVE_TEAM("system_leave_team"),
    AUTO_RESPONDER("system_auto_responder"),
    MOVE_CHANNEL("system_move_channel"),
    ADD_TO_TEAM("system_add_to_team"),
    REMOVE_FROM_TEAM("system_remove_from_team"),
    CONVERT_CHANNEL("system_convert_channel"),
    CHANGE_CHANNEL_PRIVACY("system_change_chan_privacy");

    private final String code;

    private PostType(String code) {
        this.code = code;
    }

    public static PostType of(String code) {
        return Arrays.stream(PostType.values()).filter(e -> e.getCode().equals(code)).findFirst().orElse(DEFAULT);
    }

    @Override
    public String getCode() {
        return this.code;
    }

    static class PostTypeDeserializer
    extends JsonDeserializer<PostType> {
        PostTypeDeserializer() {
        }

        public PostType deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            String jsonValue = p.getText();
            return PostType.of(jsonValue);
        }
    }
}

