/*
 * Decompiled with CFR 0.152.
 */
package net.bis5.mattermost.model.config.consts;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import net.bis5.mattermost.model.HasCode;
import net.bis5.mattermost.model.serialize.HasCodeSerializer;

@JsonSerialize(using=HasCodeSerializer.class)
@JsonDeserialize(using=PermissionsDeletePostDeserializer.class)
public enum PermissionsDeletePost implements HasCode<PermissionsDeletePost>
{
    ALL("all"),
    TEAM_ADMIN("team_admin"),
    SYSTEM_ADMIN("system_admin");

    private final String code;

    private PermissionsDeletePost(String code) {
        this.code = code;
    }

    public static PermissionsDeletePost of(String code) {
        return Arrays.stream(PermissionsDeletePost.values()).filter(e -> e.getCode().equals(code)).findFirst().orElse(ALL);
    }

    @Override
    public String getCode() {
        return this.code;
    }

    public static class PermissionsDeletePostDeserializer
    extends JsonDeserializer<PermissionsDeletePost> {
        public PermissionsDeletePost deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            String jsonValue = p.getText();
            return PermissionsDeletePost.of(jsonValue);
        }
    }
}

