/*
 * Decompiled with CFR 0.152.
 */
package net.bis5.mattermost.model;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import net.bis5.mattermost.model.HasCode;
import net.bis5.mattermost.model.serialize.HasCodeSerializer;

@JsonSerialize(using=HasCodeSerializer.class)
@JsonDeserialize(using=AuthServiceDeserializer.class)
public enum AuthService implements HasCode<AuthService>
{
    Email("email"),
    Saml("saml"),
    GitLab("gitlab"),
    Google("google"),
    Office365("office365");

    private final String code;

    private AuthService(String code) {
        this.code = code;
    }

    public static AuthService of(String code) {
        return Arrays.stream(AuthService.values()).filter(e -> e.getCode().equals(code)).findFirst().orElse(Email);
    }

    @Override
    public String getCode() {
        return this.code;
    }

    static class AuthServiceDeserializer
    extends JsonDeserializer<AuthService> {
        AuthServiceDeserializer() {
        }

        public AuthService deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            String jsonValue = p.getText();
            return AuthService.of(jsonValue);
        }
    }
}

